<?php

if(!defined('ABSPATH')){
    exit;
}

/**
 * https://restcountries.eu/rest/v2/all
 */
return array(
    'ad' => array(
        'code' => 'ad',
        'name' => 'Andorra',
        'localized' => 'Andorra',
        'native' => 'Andorra',
        'dial' => array(
            '376',
        ),
        'capital' => 'Andorra la Vella',
        'people' => 'Andorran',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 42.5,
            'lng' => 1.5,
        ),
        'languages' => array(
            'ca',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'ae' => array(
        'code' => 'ae',
        'name' => 'United Arab Emirates',
        'localized' => 'United Arab Emirates',
        'native' => 'دولة الإمارات العربية المتحدة',
        'dial' => array(
            '971',
        ),
        'capital' => 'Abu Dhabi',
        'people' => 'Emirati',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 24.0,
            'lng' => 54.0,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'AED',
        ),
    ),
    'af' => array(
        'code' => 'af',
        'name' => 'Afghanistan',
        'localized' => 'Afghanistan',
        'native' => 'افغانستان',
        'dial' => array(
            '93',
        ),
        'capital' => 'Kabul',
        'people' => 'Afghan',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 33.0,
            'lng' => 65.0,
        ),
        'languages' => array(
            'fa_AF',
            'haz',
            'ps',
            'uz_UZ',
        ),
        'currencies' => array(
            'AFN',
        ),
    ),
    'ag' => array(
        'code' => 'ag',
        'name' => 'Antigua & Barbuda',
        'localized' => 'Antigua & Barbuda',
        'native' => 'Antigua and Barbuda',
        'dial' => array(
            '1268',
        ),
        'capital' => 'Saint John\'s',
        'people' => 'Antiguan, Barbudan',
        'continent' => 'America',
        'coords' => array(
            'lat' => 17.05,
            'lng' => -61.8,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'XCD',
        ),
    ),
    'ai' => array(
        'code' => 'ai',
        'name' => 'Anguilla',
        'localized' => 'Anguilla',
        'native' => 'Anguilla',
        'dial' => array(
            '1264',
        ),
        'capital' => 'The Valley',
        'people' => 'Anguillian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 18.25,
            'lng' => -63.16666666,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'XCD',
        ),
    ),
    'al' => array(
        'code' => 'al',
        'name' => 'Albania',
        'localized' => 'Albania',
        'native' => 'Shqipëria',
        'dial' => array(
            '355',
        ),
        'capital' => 'Tirana',
        'people' => 'Albanian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 41.0,
            'lng' => 20.0,
        ),
        'languages' => array(
            'sq',
        ),
        'currencies' => array(
            'ALL',
        ),
    ),
    'am' => array(
        'code' => 'am',
        'name' => 'Armenia',
        'localized' => 'Armenia',
        'native' => 'Հայաստան',
        'dial' => array(
            '374',
        ),
        'capital' => 'Yerevan',
        'people' => 'Armenian',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 40.0,
            'lng' => 45.0,
        ),
        'languages' => array(
            'hy',
            'ru_RU',
        ),
        'currencies' => array(
            'AMD',
        ),
    ),
    'ao' => array(
        'code' => 'ao',
        'name' => 'Angola',
        'localized' => 'Angola',
        'native' => 'Angola',
        'dial' => array(
            '244',
        ),
        'capital' => 'Luanda',
        'people' => 'Angolan',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -12.5,
            'lng' => 18.5,
        ),
        'languages' => array(
            'pt_AO',
        ),
        'currencies' => array(
            'AOA',
        ),
    ),
    'ar' => array(
        'code' => 'ar',
        'name' => 'Argentina',
        'localized' => 'Argentina',
        'native' => 'Argentina',
        'dial' => array(
            '54',
        ),
        'capital' => 'Buenos Aires',
        'people' => 'Argentinean',
        'continent' => 'America',
        'coords' => array(
            'lat' => -34.0,
            'lng' => -64.0,
        ),
        'languages' => array(
            'es_AR',
        ),
        'currencies' => array(
            'ARS',
        ),
    ),
    'as' => array(
        'code' => 'as',
        'name' => 'American Samoa',
        'localized' => 'American Samoa',
        'native' => 'American Samoa',
        'dial' => array(
            '1684',
        ),
        'capital' => 'Pago Pago',
        'people' => 'American Samoan',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -14.33333333,
            'lng' => -170.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'at' => array(
        'code' => 'at',
        'name' => 'Austria',
        'localized' => 'Austria',
        'native' => 'Österreich',
        'dial' => array(
            '43',
        ),
        'capital' => 'Vienna',
        'people' => 'Austrian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 47.33333333,
            'lng' => 13.33333333,
        ),
        'languages' => array(
            'de_AT',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'au' => array(
        'code' => 'au',
        'name' => 'Australia',
        'localized' => 'Australia',
        'native' => 'Australia',
        'dial' => array(
            '61',
        ),
        'capital' => 'Canberra',
        'people' => 'Australian',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -27.0,
            'lng' => 133.0,
        ),
        'languages' => array(
            'en_AU',
        ),
        'currencies' => array(
            'AUD',
        ),
    ),
    'aw' => array(
        'code' => 'aw',
        'name' => 'Aruba',
        'localized' => 'Aruba',
        'native' => 'Aruba',
        'dial' => array(
            '297',
        ),
        'capital' => 'Oranjestad',
        'people' => 'Aruban',
        'continent' => 'America',
        'coords' => array(
            'lat' => 12.5,
            'lng' => -69.96666666,
        ),
        'languages' => array(
            'nl_NL',
            'pa_IN',
        ),
        'currencies' => array(
            'AWG',
        ),
    ),
    'az' => array(
        'code' => 'az',
        'name' => 'Azerbaijan',
        'localized' => 'Azerbaijan',
        'native' => 'Azərbaycan',
        'dial' => array(
            '994',
        ),
        'capital' => 'Baku',
        'people' => 'Azerbaijani',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 40.5,
            'lng' => 47.5,
        ),
        'languages' => array(
            'az',
            'azb',
        ),
        'currencies' => array(
            'AZN',
        ),
    ),
    'ba' => array(
        'code' => 'ba',
        'name' => 'Bosnia & Herzegovina',
        'localized' => 'Bosnia & Herzegovina',
        'native' => 'Bosna i Hercegovina',
        'dial' => array(
            '387',
        ),
        'capital' => 'Sarajevo',
        'people' => 'Bosnian, Herzegovinian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 44.0,
            'lng' => 18.0,
        ),
        'languages' => array(
            'bs_BA',
            'hr',
            'sr_RS',
        ),
        'currencies' => array(
            'BAM',
        ),
    ),
    'bb' => array(
        'code' => 'bb',
        'name' => 'Barbados',
        'localized' => 'Barbados',
        'native' => 'Barbados',
        'dial' => array(
            '1246',
        ),
        'capital' => 'Bridgetown',
        'people' => 'Barbadian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 13.16666666,
            'lng' => -59.53333333,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'BBD',
        ),
    ),
    'bd' => array(
        'code' => 'bd',
        'name' => 'Bangladesh',
        'localized' => 'Bangladesh',
        'native' => 'Bangladesh',
        'dial' => array(
            '880',
        ),
        'capital' => 'Dhaka',
        'people' => 'Bangladeshi',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 24.0,
            'lng' => 90.0,
        ),
        'languages' => array(
            'bn_BD',
        ),
        'currencies' => array(
            'BDT',
        ),
    ),
    'be' => array(
        'code' => 'be',
        'name' => 'Belgium',
        'localized' => 'Belgium',
        'native' => 'België',
        'dial' => array(
            '32',
        ),
        'capital' => 'Brussels',
        'people' => 'Belgian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 50.83333333,
            'lng' => 4.0,
        ),
        'languages' => array(
            'de_DE',
            'fr_BE',
            'nl_BE',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'bf' => array(
        'code' => 'bf',
        'name' => 'Burkina Faso',
        'localized' => 'Burkina Faso',
        'native' => 'Burkina Faso',
        'dial' => array(
            '226',
        ),
        'capital' => 'Ouagadougou',
        'people' => 'Burkinabe',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 13.0,
            'lng' => -2.0,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'XOF',
        ),
    ),
    'bg' => array(
        'code' => 'bg',
        'name' => 'Bulgaria',
        'localized' => 'Bulgaria',
        'native' => 'България',
        'dial' => array(
            '359',
        ),
        'capital' => 'Sofia',
        'people' => 'Bulgarian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 43.0,
            'lng' => 25.0,
        ),
        'languages' => array(
            'bg_BG',
        ),
        'currencies' => array(
            'BGN',
        ),
    ),
    'bh' => array(
        'code' => 'bh',
        'name' => 'Bahrain',
        'localized' => 'Bahrain',
        'native' => '‏البحرين',
        'dial' => array(
            '973',
        ),
        'capital' => 'Manama',
        'people' => 'Bahraini',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 26.0,
            'lng' => 50.55,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'BHD',
        ),
    ),
    'bi' => array(
        'code' => 'bi',
        'name' => 'Burundi',
        'localized' => 'Burundi',
        'native' => 'Burundi',
        'dial' => array(
            '257',
        ),
        'capital' => 'Bujumbura',
        'people' => 'Burundian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -3.5,
            'lng' => 30.0,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'BIF',
        ),
    ),
    'bj' => array(
        'code' => 'bj',
        'name' => 'Benin',
        'localized' => 'Benin',
        'native' => 'Bénin',
        'dial' => array(
            '229',
        ),
        'capital' => 'Porto-Novo',
        'people' => 'Beninese',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 9.5,
            'lng' => 2.25,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'XOF',
        ),
    ),
    'bl' => array(
        'code' => 'bl',
        'name' => 'St. Barthélemy',
        'localized' => 'St. Barthélemy',
        'native' => 'Saint-Barthélemy',
        'dial' => array(
            '590',
        ),
        'capital' => 'Gustavia',
        'people' => 'Saint Barthélemy Islander',
        'continent' => 'America',
        'coords' => array(
            'lat' => 18.5,
            'lng' => -63.41666666,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'bm' => array(
        'code' => 'bm',
        'name' => 'Bermuda',
        'localized' => 'Bermuda',
        'native' => 'Bermuda',
        'dial' => array(
            '1441',
        ),
        'capital' => 'Hamilton',
        'people' => 'Bermudian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 32.33333333,
            'lng' => -64.75,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'BMD',
        ),
    ),
    'bn' => array(
        'code' => 'bn',
        'name' => 'Brunei',
        'localized' => 'Brunei',
        'native' => 'Negara Brunei Darussalam',
        'dial' => array(
            '673',
        ),
        'capital' => 'Bandar Seri Begawan',
        'people' => 'Bruneian',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 4.5,
            'lng' => 114.66666666,
        ),
        'languages' => array(
            'ms_MY',
        ),
        'currencies' => array(
            'BND',
            'SGD',
        ),
    ),
    'bo' => array(
        'code' => 'bo',
        'name' => 'Bolivia',
        'localized' => 'Bolivia',
        'native' => 'Bolivia',
        'dial' => array(
            '591',
        ),
        'capital' => 'Sucre',
        'people' => 'Bolivian',
        'continent' => 'America',
        'coords' => array(
            'lat' => -17.0,
            'lng' => -65.0,
        ),
        'languages' => array(
            'es_ES',
        ),
        'currencies' => array(
            'BOB',
        ),
    ),
    'br' => array(
        'code' => 'br',
        'name' => 'Brazil',
        'localized' => 'Brazil',
        'native' => 'Brasil',
        'dial' => array(
            '55',
        ),
        'capital' => 'Brasília',
        'people' => 'Brazilian',
        'continent' => 'America',
        'coords' => array(
            'lat' => -10.0,
            'lng' => -55.0,
        ),
        'languages' => array(
            'pt_BR',
        ),
        'currencies' => array(
            'BRL',
        ),
    ),
    'bs' => array(
        'code' => 'bs',
        'name' => 'Bahamas',
        'localized' => 'Bahamas',
        'native' => 'Bahamas',
        'dial' => array(
            '1242',
        ),
        'capital' => 'Nassau',
        'people' => 'Bahamian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 24.25,
            'lng' => -76.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'BSD',
        ),
    ),
    'bt' => array(
        'code' => 'bt',
        'name' => 'Bhutan',
        'localized' => 'Bhutan',
        'native' => 'ʼbrug-yul',
        'dial' => array(
            '975',
        ),
        'capital' => 'Thimphu',
        'people' => 'Bhutanese',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 27.5,
            'lng' => 90.5,
        ),
        'languages' => array(
            'dzo',
        ),
        'currencies' => array(
            'BTN',
            'INR',
        ),
    ),
    'bw' => array(
        'code' => 'bw',
        'name' => 'Botswana',
        'localized' => 'Botswana',
        'native' => 'Botswana',
        'dial' => array(
            '267',
        ),
        'capital' => 'Gaborone',
        'people' => 'Motswana',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -22.0,
            'lng' => 24.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'BWP',
        ),
    ),
    'by' => array(
        'code' => 'by',
        'name' => 'Belarus',
        'localized' => 'Belarus',
        'native' => 'Белару́сь',
        'dial' => array(
            '375',
        ),
        'capital' => 'Minsk',
        'people' => 'Belarusian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 53.0,
            'lng' => 28.0,
        ),
        'languages' => array(
            'bel',
            'ru_RU',
        ),
        'currencies' => array(
            'BYN',
            'BYR',
        ),
    ),
    'bz' => array(
        'code' => 'bz',
        'name' => 'Belize',
        'localized' => 'Belize',
        'native' => 'Belize',
        'dial' => array(
            '501',
        ),
        'capital' => 'Belmopan',
        'people' => 'Belizean',
        'continent' => 'America',
        'coords' => array(
            'lat' => 17.25,
            'lng' => -88.75,
        ),
        'languages' => array(
            'en_US',
            'es_ES',
        ),
        'currencies' => array(
            'BZD',
        ),
    ),
    'ca' => array(
        'code' => 'ca',
        'name' => 'Canada',
        'localized' => 'Canada',
        'native' => 'Canada',
        'dial' => array(
            '1',
        ),
        'capital' => 'Ottawa',
        'people' => 'Canadian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 60.0,
            'lng' => -95.0,
        ),
        'languages' => array(
            'en_CA',
            'fr_CA',
        ),
        'currencies' => array(
            'CAD',
        ),
    ),
    'cc' => array(
        'code' => 'cc',
        'name' => 'Cocos (Keeling) Islands',
        'localized' => 'Cocos (Keeling) Islands',
        'native' => 'Cocos (Keeling) Islands',
        'dial' => array(
            '61',
        ),
        'capital' => 'West Island',
        'people' => 'Cocos Islander',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => -12.5,
            'lng' => 96.83333333,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'AUD',
        ),
    ),
    'cd' => array(
        'code' => 'cd',
        'name' => 'Congo - Kinshasa',
        'localized' => 'Congo - Kinshasa',
        'native' => 'République démocratique du Congo',
        'dial' => array(
            '243',
        ),
        'capital' => 'Kinshasa',
        'people' => 'Congolese',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 0.0,
            'lng' => 25.0,
        ),
        'languages' => array(
            'fr_FR',
            'sw',
        ),
        'currencies' => array(
            'CDF',
        ),
    ),
    'cf' => array(
        'code' => 'cf',
        'name' => 'Central African Republic',
        'localized' => 'Central African Republic',
        'native' => 'Ködörösêse tî Bêafrîka',
        'dial' => array(
            '236',
        ),
        'capital' => 'Bangui',
        'people' => 'Central African',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 7.0,
            'lng' => 21.0,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'XAF',
        ),
    ),
    'cg' => array(
        'code' => 'cg',
        'name' => 'Congo - Brazzaville',
        'localized' => 'Congo - Brazzaville',
        'native' => 'République du Congo',
        'dial' => array(
            '242',
        ),
        'capital' => 'Brazzaville',
        'people' => 'Congolese',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -1.0,
            'lng' => 15.0,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'XAF',
        ),
    ),
    'ch' => array(
        'code' => 'ch',
        'name' => 'Switzerland',
        'localized' => 'Switzerland',
        'native' => 'Schweiz',
        'dial' => array(
            '41',
        ),
        'capital' => 'Bern',
        'people' => 'Swiss',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 47.0,
            'lng' => 8.0,
        ),
        'languages' => array(
            'de_CH',
            'de_CH_informal',
            'fr_FR',
            'it_IT',
        ),
        'currencies' => array(
            'CHF',
        ),
    ),
    'ci' => array(
        'code' => 'ci',
        'name' => 'Côte d’Ivoire',
        'localized' => 'Côte d’Ivoire',
        'native' => 'Côte d\'Ivoire',
        'dial' => array(
            '225',
        ),
        'capital' => 'Yamoussoukro',
        'people' => 'Ivorian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 8.0,
            'lng' => -5.0,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'XOF',
        ),
    ),
    'ck' => array(
        'code' => 'ck',
        'name' => 'Cook Islands',
        'localized' => 'Cook Islands',
        'native' => 'Cook Islands',
        'dial' => array(
            '682',
        ),
        'capital' => 'Avarua',
        'people' => 'Cook Islander',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -21.23333333,
            'lng' => -159.76666666,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'NZD',
            'CKD',
        ),
    ),
    'cl' => array(
        'code' => 'cl',
        'name' => 'Chile',
        'localized' => 'Chile',
        'native' => 'Chile',
        'dial' => array(
            '56',
        ),
        'capital' => 'Santiago',
        'people' => 'Chilean',
        'continent' => 'America',
        'coords' => array(
            'lat' => -30.0,
            'lng' => -71.0,
        ),
        'languages' => array(
            'es_CL',
        ),
        'currencies' => array(
            'CLP',
        ),
    ),
    'cm' => array(
        'code' => 'cm',
        'name' => 'Cameroon',
        'localized' => 'Cameroon',
        'native' => 'Cameroon',
        'dial' => array(
            '237',
        ),
        'capital' => 'Yaoundé',
        'people' => 'Cameroonian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 6.0,
            'lng' => 12.0,
        ),
        'languages' => array(
            'en_US',
            'fr_FR',
        ),
        'currencies' => array(
            'XAF',
        ),
    ),
    'cn' => array(
        'code' => 'cn',
        'name' => 'China',
        'localized' => 'China',
        'native' => '中国',
        'dial' => array(
            '86',
        ),
        'capital' => 'Beijing',
        'people' => 'Chinese',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 35.0,
            'lng' => 105.0,
        ),
        'languages' => array(
            'bo',
            'ug_CN',
            'zh_CN',
        ),
        'currencies' => array(
            'CNY',
        ),
    ),
    'co' => array(
        'code' => 'co',
        'name' => 'Colombia',
        'localized' => 'Colombia',
        'native' => 'Colombia',
        'dial' => array(
            '57',
        ),
        'capital' => 'Bogotá',
        'people' => 'Colombian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 4.0,
            'lng' => -72.0,
        ),
        'languages' => array(
            'es_CO',
        ),
        'currencies' => array(
            'COP',
        ),
    ),
    'cr' => array(
        'code' => 'cr',
        'name' => 'Costa Rica',
        'localized' => 'Costa Rica',
        'native' => 'Costa Rica',
        'dial' => array(
            '506',
        ),
        'capital' => 'San José',
        'people' => 'Costa Rican',
        'continent' => 'America',
        'coords' => array(
            'lat' => 10.0,
            'lng' => -84.0,
        ),
        'languages' => array(
            'es_CR',
        ),
        'currencies' => array(
            'CRC',
        ),
    ),
    'cu' => array(
        'code' => 'cu',
        'name' => 'Cuba',
        'localized' => 'Cuba',
        'native' => 'Cuba',
        'dial' => array(
            '53',
        ),
        'capital' => 'Havana',
        'people' => 'Cuban',
        'continent' => 'America',
        'coords' => array(
            'lat' => 21.5,
            'lng' => -80.0,
        ),
        'languages' => array(
            'es_ES',
        ),
        'currencies' => array(
            'CUC',
            'CUP',
        ),
    ),
    'cv' => array(
        'code' => 'cv',
        'name' => 'Cape Verde',
        'localized' => 'Cape Verde',
        'native' => 'Cabo Verde',
        'dial' => array(
            '238',
        ),
        'capital' => 'Praia',
        'people' => 'Cape Verdian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 16.0,
            'lng' => -24.0,
        ),
        'languages' => array(
            'pt_PT',
        ),
        'currencies' => array(
            'CVE',
        ),
    ),
    'cx' => array(
        'code' => 'cx',
        'name' => 'Christmas Island',
        'localized' => 'Christmas Island',
        'native' => 'Christmas Island',
        'dial' => array(
            '61',
        ),
        'capital' => 'Flying Fish Cove',
        'people' => 'Christmas Island',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => -10.5,
            'lng' => 105.66666666,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'AUD',
        ),
    ),
    'cy' => array(
        'code' => 'cy',
        'name' => 'Cyprus',
        'localized' => 'Cyprus',
        'native' => 'Κύπρος',
        'dial' => array(
            '357',
        ),
        'capital' => 'Nicosia',
        'people' => 'Cypriot',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 35.0,
            'lng' => 33.0,
        ),
        'languages' => array(
            'el',
            'hy',
            'tr_TR',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'cz' => array(
        'code' => 'cz',
        'name' => 'Czechia',
        'localized' => 'Czechia',
        'native' => 'Česká republika',
        'dial' => array(
            '420',
        ),
        'capital' => 'Prague',
        'people' => 'Czech',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 49.75,
            'lng' => 15.5,
        ),
        'languages' => array(
            'cs_CZ',
            'sk_SK',
        ),
        'currencies' => array(
            'CZK',
        ),
    ),
    'de' => array(
        'code' => 'de',
        'name' => 'Germany',
        'localized' => 'Germany',
        'native' => 'Deutschland',
        'dial' => array(
            '49',
        ),
        'capital' => 'Berlin',
        'people' => 'German',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 51.0,
            'lng' => 9.0,
        ),
        'languages' => array(
            'de_DE',
            'de_DE_formal',
            'dsb',
            'hsb',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'dj' => array(
        'code' => 'dj',
        'name' => 'Djibouti',
        'localized' => 'Djibouti',
        'native' => 'Djibouti',
        'dial' => array(
            '253',
        ),
        'capital' => 'Djibouti',
        'people' => 'Djibouti',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 11.5,
            'lng' => 43.0,
        ),
        'languages' => array(
            'ar',
            'fr_FR',
        ),
        'currencies' => array(
            'DJF',
        ),
    ),
    'dk' => array(
        'code' => 'dk',
        'name' => 'Denmark',
        'localized' => 'Denmark',
        'native' => 'Danmark',
        'dial' => array(
            '45',
        ),
        'capital' => 'Copenhagen',
        'people' => 'Danish',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 56.0,
            'lng' => 10.0,
        ),
        'languages' => array(
            'da_DK',
        ),
        'currencies' => array(
            'DKK',
        ),
    ),
    'dm' => array(
        'code' => 'dm',
        'name' => 'Dominica',
        'localized' => 'Dominica',
        'native' => 'Dominica',
        'dial' => array(
            '1767',
        ),
        'capital' => 'Roseau',
        'people' => 'Dominican',
        'continent' => 'America',
        'coords' => array(
            'lat' => 15.41666666,
            'lng' => -61.33333333,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'XCD',
        ),
    ),
    'do' => array(
        'code' => 'do',
        'name' => 'Dominican Republic',
        'localized' => 'Dominican Republic',
        'native' => 'República Dominicana',
        'dial' => array(
            '1809',
            '1829',
            '1849',
        ),
        'capital' => 'Santo Domingo',
        'people' => 'Dominican',
        'continent' => 'America',
        'coords' => array(
            'lat' => 19.0,
            'lng' => -70.66666666,
        ),
        'languages' => array(
            'es_ES',
        ),
        'currencies' => array(
            'DOP',
        ),
    ),
    'dz' => array(
        'code' => 'dz',
        'name' => 'Algeria',
        'localized' => 'Algeria',
        'native' => 'الجزائر',
        'dial' => array(
            '213',
        ),
        'capital' => 'Algiers',
        'people' => 'Algerian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 28.0,
            'lng' => 3.0,
        ),
        'languages' => array(
            'ar',
            'kab',
        ),
        'currencies' => array(
            'DZD',
        ),
    ),
    'ec' => array(
        'code' => 'ec',
        'name' => 'Ecuador',
        'localized' => 'Ecuador',
        'native' => 'Ecuador',
        'dial' => array(
            '593',
        ),
        'capital' => 'Quito',
        'people' => 'Ecuadorean',
        'continent' => 'America',
        'coords' => array(
            'lat' => -2.0,
            'lng' => -77.5,
        ),
        'languages' => array(
            'es_EC',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'ee' => array(
        'code' => 'ee',
        'name' => 'Estonia',
        'localized' => 'Estonia',
        'native' => 'Eesti',
        'dial' => array(
            '372',
        ),
        'capital' => 'Tallinn',
        'people' => 'Estonian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 59.0,
            'lng' => 26.0,
        ),
        'languages' => array(
            'et',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'eg' => array(
        'code' => 'eg',
        'name' => 'Egypt',
        'localized' => 'Egypt',
        'native' => 'مصر‎',
        'dial' => array(
            '20',
        ),
        'capital' => 'Cairo',
        'people' => 'Egyptian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 27.0,
            'lng' => 30.0,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'EGP',
        ),
    ),
    'eh' => array(
        'code' => 'eh',
        'name' => 'Western Sahara',
        'localized' => 'Western Sahara',
        'native' => 'الصحراء الغربية',
        'dial' => array(
            '212',
        ),
        'capital' => 'El Aaiún',
        'people' => 'Sahrawi',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 24.5,
            'lng' => -13.0,
        ),
        'languages' => array(
            'es_ES',
        ),
        'currencies' => array(
            'MAD',
            'DZD',
        ),
    ),
    'er' => array(
        'code' => 'er',
        'name' => 'Eritrea',
        'localized' => 'Eritrea',
        'native' => 'ኤርትራ',
        'dial' => array(
            '291',
        ),
        'capital' => 'Asmara',
        'people' => 'Eritrean',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 15.0,
            'lng' => 39.0,
        ),
        'languages' => array(
            'ar',
            'en_US',
        ),
        'currencies' => array(
            'ERN',
        ),
    ),
    'es' => array(
        'code' => 'es',
        'name' => 'Spain',
        'localized' => 'Spain',
        'native' => 'España',
        'dial' => array(
            '34',
        ),
        'capital' => 'Madrid',
        'people' => 'Spanish',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 40.0,
            'lng' => -4.0,
        ),
        'languages' => array(
            'ca',
            'es_ES',
            'gl_ES',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'et' => array(
        'code' => 'et',
        'name' => 'Ethiopia',
        'localized' => 'Ethiopia',
        'native' => 'ኢትዮጵያ',
        'dial' => array(
            '251',
        ),
        'capital' => 'Addis Ababa',
        'people' => 'Ethiopian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 8.0,
            'lng' => 38.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'ETB',
        ),
    ),
    'fi' => array(
        'code' => 'fi',
        'name' => 'Finland',
        'localized' => 'Finland',
        'native' => 'Suomi',
        'dial' => array(
            '358',
        ),
        'capital' => 'Helsinki',
        'people' => 'Finnish',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 64.0,
            'lng' => 26.0,
        ),
        'languages' => array(
            'fi',
            'sv_SE',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'fj' => array(
        'code' => 'fj',
        'name' => 'Fiji',
        'localized' => 'Fiji',
        'native' => 'Fiji',
        'dial' => array(
            '679',
        ),
        'capital' => 'Suva',
        'people' => 'Fijian',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -18.0,
            'lng' => 175.0,
        ),
        'languages' => array(
            'en_US',
            'hi_IN',
            'ur',
        ),
        'currencies' => array(
            'FJD',
        ),
    ),
    'fk' => array(
        'code' => 'fk',
        'name' => 'Falkland Islands',
        'localized' => 'Falkland Islands',
        'native' => 'Falkland Islands',
        'dial' => array(
            '500',
        ),
        'capital' => 'Stanley',
        'people' => 'Falkland Islander',
        'continent' => 'America',
        'coords' => array(
            'lat' => -51.75,
            'lng' => -59.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'FKP',
        ),
    ),
    'fm' => array(
        'code' => 'fm',
        'name' => 'Micronesia',
        'localized' => 'Micronesia',
        'native' => 'Micronesia',
        'dial' => array(
            '691',
        ),
        'capital' => 'Palikir',
        'people' => 'Micronesian',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => 6.91666666,
            'lng' => 158.25,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'fo' => array(
        'code' => 'fo',
        'name' => 'Faroe Islands',
        'localized' => 'Faroe Islands',
        'native' => 'Føroyar',
        'dial' => array(
            '298',
        ),
        'capital' => 'Tórshavn',
        'people' => 'Faroese',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 62.0,
            'lng' => -7.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'DKK',
        ),
    ),
    'fr' => array(
        'code' => 'fr',
        'name' => 'France',
        'localized' => 'France',
        'native' => 'France',
        'dial' => array(
            '33',
        ),
        'capital' => 'Paris',
        'people' => 'French',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 46.0,
            'lng' => 2.0,
        ),
        'languages' => array(
            'eu',
            'fr_FR',
            'oci',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'ga' => array(
        'code' => 'ga',
        'name' => 'Gabon',
        'localized' => 'Gabon',
        'native' => 'Gabon',
        'dial' => array(
            '241',
        ),
        'capital' => 'Libreville',
        'people' => 'Gabonese',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -1.0,
            'lng' => 11.75,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'XAF',
        ),
    ),
    'gb' => array(
        'code' => 'gb',
        'name' => 'United Kingdom',
        'localized' => 'United Kingdom',
        'native' => 'United Kingdom',
        'dial' => array(
            '44',
        ),
        'capital' => 'London',
        'people' => 'British',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 54.0,
            'lng' => -2.0,
        ),
        'languages' => array(
            'cy',
            'en_GB',
            'gd',
        ),
        'currencies' => array(
            'GBP',
        ),
    ),
    'gd' => array(
        'code' => 'gd',
        'name' => 'Grenada',
        'localized' => 'Grenada',
        'native' => 'Grenada',
        'dial' => array(
            '1473',
        ),
        'capital' => 'St. George\'s',
        'people' => 'Grenadian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 12.11666666,
            'lng' => -61.66666666,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'XCD',
        ),
    ),
    'ge' => array(
        'code' => 'ge',
        'name' => 'Georgia',
        'localized' => 'Georgia',
        'native' => 'საქართველო',
        'dial' => array(
            '995',
        ),
        'capital' => 'Tbilisi',
        'people' => 'Georgian',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 42.0,
            'lng' => 43.5,
        ),
        'languages' => array(
            'ka_GE',
        ),
        'currencies' => array(
            'GEL',
        ),
    ),
    'gf' => array(
        'code' => 'gf',
        'name' => 'French Guiana',
        'localized' => 'French Guiana',
        'native' => 'Guyane française',
        'dial' => array(
            '594',
        ),
        'capital' => 'Cayenne',
        'people' => '',
        'continent' => 'America',
        'coords' => array(
            'lat' => 4.0,
            'lng' => -53.0,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'gh' => array(
        'code' => 'gh',
        'name' => 'Ghana',
        'localized' => 'Ghana',
        'native' => 'Ghana',
        'dial' => array(
            '233',
        ),
        'capital' => 'Accra',
        'people' => 'Ghanaian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 8.0,
            'lng' => -2.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'GHS',
        ),
    ),
    'gi' => array(
        'code' => 'gi',
        'name' => 'Gibraltar',
        'localized' => 'Gibraltar',
        'native' => 'Gibraltar',
        'dial' => array(
            '350',
        ),
        'capital' => 'Gibraltar',
        'people' => 'Gibraltar',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 36.13333333,
            'lng' => -5.35,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'GIP',
        ),
    ),
    'gl' => array(
        'code' => 'gl',
        'name' => 'Greenland',
        'localized' => 'Greenland',
        'native' => 'Kalaallit Nunaat',
        'dial' => array(
            '299',
        ),
        'capital' => 'Nuuk',
        'people' => 'Greenlandic',
        'continent' => 'America',
        'coords' => array(
            'lat' => 72.0,
            'lng' => -40.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'DKK',
        ),
    ),
    'gm' => array(
        'code' => 'gm',
        'name' => 'Gambia',
        'localized' => 'Gambia',
        'native' => 'Gambia',
        'dial' => array(
            '220',
        ),
        'capital' => 'Banjul',
        'people' => 'Gambian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 13.46666666,
            'lng' => -16.56666666,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'GMD',
        ),
    ),
    'gn' => array(
        'code' => 'gn',
        'name' => 'Guinea',
        'localized' => 'Guinea',
        'native' => 'Guinée',
        'dial' => array(
            '224',
        ),
        'capital' => 'Conakry',
        'people' => 'Guinean',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 11.0,
            'lng' => -10.0,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'GNF',
        ),
    ),
    'gp' => array(
        'code' => 'gp',
        'name' => 'Guadeloupe',
        'localized' => 'Guadeloupe',
        'native' => 'Guadeloupe',
        'dial' => array(
            '590',
        ),
        'capital' => 'Basse-Terre',
        'people' => 'Guadeloupian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 16.25,
            'lng' => -61.583333,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'gq' => array(
        'code' => 'gq',
        'name' => 'Equatorial Guinea',
        'localized' => 'Equatorial Guinea',
        'native' => 'Guinea Ecuatorial',
        'dial' => array(
            '240',
        ),
        'capital' => 'Malabo',
        'people' => 'Equatorial Guinean',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 2.0,
            'lng' => 10.0,
        ),
        'languages' => array(
            'es_ES',
            'fr_FR',
        ),
        'currencies' => array(
            'XAF',
        ),
    ),
    'gr' => array(
        'code' => 'gr',
        'name' => 'Greece',
        'localized' => 'Greece',
        'native' => 'Ελλάδα',
        'dial' => array(
            '30',
        ),
        'capital' => 'Athens',
        'people' => 'Greek',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 39.0,
            'lng' => 22.0,
        ),
        'languages' => array(
            'el',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'gt' => array(
        'code' => 'gt',
        'name' => 'Guatemala',
        'localized' => 'Guatemala',
        'native' => 'Guatemala',
        'dial' => array(
            '502',
        ),
        'capital' => 'Guatemala City',
        'people' => 'Guatemalan',
        'continent' => 'America',
        'coords' => array(
            'lat' => 15.5,
            'lng' => -90.25,
        ),
        'languages' => array(
            'es_GT',
        ),
        'currencies' => array(
            'GTQ',
        ),
    ),
    'gu' => array(
        'code' => 'gu',
        'name' => 'Guam',
        'localized' => 'Guam',
        'native' => 'Guam',
        'dial' => array(
            '1671',
        ),
        'capital' => 'Hagåtña',
        'people' => 'Guamanian',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => 13.46666666,
            'lng' => 144.78333333,
        ),
        'languages' => array(
            'en_US',
            'es_ES',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'gw' => array(
        'code' => 'gw',
        'name' => 'Guinea-Bissau',
        'localized' => 'Guinea-Bissau',
        'native' => 'Guiné-Bissau',
        'dial' => array(
            '245',
        ),
        'capital' => 'Bissau',
        'people' => 'Guinea-Bissauan',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 12.0,
            'lng' => -15.0,
        ),
        'languages' => array(
            'pt_PT',
        ),
        'currencies' => array(
            'XOF',
        ),
    ),
    'gy' => array(
        'code' => 'gy',
        'name' => 'Guyana',
        'localized' => 'Guyana',
        'native' => 'Guyana',
        'dial' => array(
            '592',
        ),
        'capital' => 'Georgetown',
        'people' => 'Guyanese',
        'continent' => 'America',
        'coords' => array(
            'lat' => 5.0,
            'lng' => -59.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'GYD',
        ),
    ),
    'hk' => array(
        'code' => 'hk',
        'name' => 'Hong Kong SAR China',
        'localized' => 'Hong Kong SAR China',
        'native' => '香港',
        'dial' => array(
            '852',
        ),
        'capital' => 'City of Victoria',
        'people' => 'Chinese',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 22.25,
            'lng' => 114.16666666,
        ),
        'languages' => array(
            'en_US',
            'zh_HK',
        ),
        'currencies' => array(
            'HKD',
        ),
    ),
    'hn' => array(
        'code' => 'hn',
        'name' => 'Honduras',
        'localized' => 'Honduras',
        'native' => 'Honduras',
        'dial' => array(
            '504',
        ),
        'capital' => 'Tegucigalpa',
        'people' => 'Honduran',
        'continent' => 'America',
        'coords' => array(
            'lat' => 15.0,
            'lng' => -86.5,
        ),
        'languages' => array(
            'es_ES',
        ),
        'currencies' => array(
            'HNL',
        ),
    ),
    'hr' => array(
        'code' => 'hr',
        'name' => 'Croatia',
        'localized' => 'Croatia',
        'native' => 'Hrvatska',
        'dial' => array(
            '385',
        ),
        'capital' => 'Zagreb',
        'people' => 'Croatian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 45.16666666,
            'lng' => 15.5,
        ),
        'languages' => array(
            'hr',
        ),
        'currencies' => array(
            'HRK',
        ),
    ),
    'ht' => array(
        'code' => 'ht',
        'name' => 'Haiti',
        'localized' => 'Haiti',
        'native' => 'Haïti',
        'dial' => array(
            '509',
        ),
        'capital' => 'Port-au-Prince',
        'people' => 'Haitian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 19.0,
            'lng' => -72.41666666,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'HTG',
        ),
    ),
    'hu' => array(
        'code' => 'hu',
        'name' => 'Hungary',
        'localized' => 'Hungary',
        'native' => 'Magyarország',
        'dial' => array(
            '36',
        ),
        'capital' => 'Budapest',
        'people' => 'Hungarian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 47.0,
            'lng' => 20.0,
        ),
        'languages' => array(
            'hu_HU',
        ),
        'currencies' => array(
            'HUF',
        ),
    ),
    'id' => array(
        'code' => 'id',
        'name' => 'Indonesia',
        'localized' => 'Indonesia',
        'native' => 'Indonesia',
        'dial' => array(
            '62',
        ),
        'capital' => 'Jakarta',
        'people' => 'Indonesian',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => -5.0,
            'lng' => 120.0,
        ),
        'languages' => array(
            'id_ID',
            'jv_ID',
        ),
        'currencies' => array(
            'IDR',
        ),
    ),
    'ie' => array(
        'code' => 'ie',
        'name' => 'Ireland',
        'localized' => 'Ireland',
        'native' => 'Éire',
        'dial' => array(
            '353',
        ),
        'capital' => 'Dublin',
        'people' => 'Irish',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 53.0,
            'lng' => -8.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'il' => array(
        'code' => 'il',
        'name' => 'Israel',
        'localized' => 'Israel',
        'native' => 'יִשְׂרָאֵל',
        'dial' => array(
            '972',
        ),
        'capital' => 'Jerusalem',
        'people' => 'Israeli',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 31.5,
            'lng' => 34.75,
        ),
        'languages' => array(
            'ar',
            'he_IL',
        ),
        'currencies' => array(
            'ILS',
        ),
    ),
    'im' => array(
        'code' => 'im',
        'name' => 'Isle of Man',
        'localized' => 'Isle of Man',
        'native' => 'Isle of Man',
        'dial' => array(
            '44',
        ),
        'capital' => 'Douglas',
        'people' => 'Manx',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 54.25,
            'lng' => -4.5,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'GBP',
            'IMP[G]',
        ),
    ),
    'in' => array(
        'code' => 'in',
        'name' => 'India',
        'localized' => 'India',
        'native' => 'भारत',
        'dial' => array(
            '91',
        ),
        'capital' => 'New Delhi',
        'people' => 'Indian',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 20.0,
            'lng' => 77.0,
        ),
        'languages' => array(
            'as',
            'en_US',
            'gu',
            'hi_IN',
            'kn',
            'ml_IN',
            'mr',
            'pa_IN',
            'ta_IN',
            'te',
        ),
        'currencies' => array(
            'INR',
        ),
    ),
    'iq' => array(
        'code' => 'iq',
        'name' => 'Iraq',
        'localized' => 'Iraq',
        'native' => 'العراق',
        'dial' => array(
            '964',
        ),
        'capital' => 'Baghdad',
        'people' => 'Iraqi',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 33.0,
            'lng' => 44.0,
        ),
        'languages' => array(
            'ar',
            'ckb',
        ),
        'currencies' => array(
            'IQD',
        ),
    ),
    'ir' => array(
        'code' => 'ir',
        'name' => 'Iran',
        'localized' => 'Iran',
        'native' => 'ایران',
        'dial' => array(
            '98',
        ),
        'capital' => 'Tehran',
        'people' => 'Iranian',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 32.0,
            'lng' => 53.0,
        ),
        'languages' => array(
            'ckb',
            'fa_IR',
        ),
        'currencies' => array(
            'IRR',
        ),
    ),
    'is' => array(
        'code' => 'is',
        'name' => 'Iceland',
        'localized' => 'Iceland',
        'native' => 'Ísland',
        'dial' => array(
            '354',
        ),
        'capital' => 'Reykjavík',
        'people' => 'Icelander',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 65.0,
            'lng' => -18.0,
        ),
        'languages' => array(
            'is_IS',
        ),
        'currencies' => array(
            'ISK',
        ),
    ),
    'it' => array(
        'code' => 'it',
        'name' => 'Italy',
        'localized' => 'Italy',
        'native' => 'Italia',
        'dial' => array(
            '39',
        ),
        'capital' => 'Rome',
        'people' => 'Italian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 42.83333333,
            'lng' => 12.83333333,
        ),
        'languages' => array(
            'fur',
            'it_IT',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'je' => array(
        'code' => 'je',
        'name' => 'Jersey',
        'localized' => 'Jersey',
        'native' => 'Jersey',
        'dial' => array(
            '44',
        ),
        'capital' => 'Saint Helier',
        'people' => 'Channel Islander',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 49.25,
            'lng' => -2.16666666,
        ),
        'languages' => array(
            'en_US',
            'fr_FR',
        ),
        'currencies' => array(
            'GBP',
            'JEP[G]',
        ),
    ),
    'jm' => array(
        'code' => 'jm',
        'name' => 'Jamaica',
        'localized' => 'Jamaica',
        'native' => 'Jamaica',
        'dial' => array(
            '1876',
        ),
        'capital' => 'Kingston',
        'people' => 'Jamaican',
        'continent' => 'America',
        'coords' => array(
            'lat' => 18.25,
            'lng' => -77.5,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'JMD',
        ),
    ),
    'jo' => array(
        'code' => 'jo',
        'name' => 'Jordan',
        'localized' => 'Jordan',
        'native' => 'الأردن',
        'dial' => array(
            '962',
        ),
        'capital' => 'Amman',
        'people' => 'Jordanian',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 31.0,
            'lng' => 36.0,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'JOD',
        ),
    ),
    'jp' => array(
        'code' => 'jp',
        'name' => 'Japan',
        'localized' => 'Japan',
        'native' => '日本',
        'dial' => array(
            '81',
        ),
        'capital' => 'Tokyo',
        'people' => 'Japanese',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 36.0,
            'lng' => 138.0,
        ),
        'languages' => array(
            'ja',
        ),
        'currencies' => array(
            'JPY',
        ),
    ),
    'ke' => array(
        'code' => 'ke',
        'name' => 'Kenya',
        'localized' => 'Kenya',
        'native' => 'Kenya',
        'dial' => array(
            '254',
        ),
        'capital' => 'Nairobi',
        'people' => 'Kenyan',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 1.0,
            'lng' => 38.0,
        ),
        'languages' => array(
            'en_US',
            'sw',
        ),
        'currencies' => array(
            'KES',
        ),
    ),
    'kg' => array(
        'code' => 'kg',
        'name' => 'Kyrgyzstan',
        'localized' => 'Kyrgyzstan',
        'native' => 'Кыргызстан',
        'dial' => array(
            '996',
        ),
        'capital' => 'Bishkek',
        'people' => 'Kirghiz',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 41.0,
            'lng' => 75.0,
        ),
        'languages' => array(
            'ru_RU',
        ),
        'currencies' => array(
            'KGS',
        ),
    ),
    'kh' => array(
        'code' => 'kh',
        'name' => 'Cambodia',
        'localized' => 'Cambodia',
        'native' => 'Kâmpŭchéa',
        'dial' => array(
            '855',
        ),
        'capital' => 'Phnom Penh',
        'people' => 'Cambodian',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 13.0,
            'lng' => 105.0,
        ),
        'languages' => array(
            'km',
        ),
        'currencies' => array(
            'KHR',
            'USD',
        ),
    ),
    'ki' => array(
        'code' => 'ki',
        'name' => 'Kiribati',
        'localized' => 'Kiribati',
        'native' => 'Kiribati',
        'dial' => array(
            '686',
        ),
        'capital' => 'South Tarawa',
        'people' => 'I-Kiribati',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => 1.41666666,
            'lng' => 173.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'AUD',
        ),
    ),
    'km' => array(
        'code' => 'km',
        'name' => 'Comoros',
        'localized' => 'Comoros',
        'native' => 'Komori',
        'dial' => array(
            '269',
        ),
        'capital' => 'Moroni',
        'people' => 'Comoran',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -12.16666666,
            'lng' => 44.25,
        ),
        'languages' => array(
            'ar',
            'fr_FR',
        ),
        'currencies' => array(
            'KMF',
        ),
    ),
    'kn' => array(
        'code' => 'kn',
        'name' => 'St. Kitts & Nevis',
        'localized' => 'St. Kitts & Nevis',
        'native' => 'Saint Kitts and Nevis',
        'dial' => array(
            '1869',
        ),
        'capital' => 'Basseterre',
        'people' => 'Kittian and Nevisian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 17.33333333,
            'lng' => -62.75,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'XCD',
        ),
    ),
    'kp' => array(
        'code' => 'kp',
        'name' => 'North Korea',
        'localized' => 'North Korea',
        'native' => '북한',
        'dial' => array(
            '850',
        ),
        'capital' => 'Pyongyang',
        'people' => 'North Korean',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 40.0,
            'lng' => 127.0,
        ),
        'languages' => array(
            'ko_KR',
        ),
        'currencies' => array(
            'KPW',
        ),
    ),
    'kr' => array(
        'code' => 'kr',
        'name' => 'South Korea',
        'localized' => 'South Korea',
        'native' => '대한민국',
        'dial' => array(
            '82',
        ),
        'capital' => 'Seoul',
        'people' => 'South Korean',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 37.0,
            'lng' => 127.5,
        ),
        'languages' => array(
            'ko_KR',
        ),
        'currencies' => array(
            'KRW',
        ),
    ),
    'kw' => array(
        'code' => 'kw',
        'name' => 'Kuwait',
        'localized' => 'Kuwait',
        'native' => 'الكويت',
        'dial' => array(
            '965',
        ),
        'capital' => 'Kuwait City',
        'people' => 'Kuwaiti',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 29.5,
            'lng' => 45.75,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'KWD',
        ),
    ),
    'ky' => array(
        'code' => 'ky',
        'name' => 'Cayman Islands',
        'localized' => 'Cayman Islands',
        'native' => 'Cayman Islands',
        'dial' => array(
            '1345',
        ),
        'capital' => 'George Town',
        'people' => 'Caymanian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 19.5,
            'lng' => -80.5,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'KYD',
        ),
    ),
    'kz' => array(
        'code' => 'kz',
        'name' => 'Kazakhstan',
        'localized' => 'Kazakhstan',
        'native' => 'Қазақстан',
        'dial' => array(
            '76',
            '77',
        ),
        'capital' => 'Astana',
        'people' => 'Kazakhstani',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 48.0,
            'lng' => 68.0,
        ),
        'languages' => array(
            'kk',
            'ru_RU',
        ),
        'currencies' => array(
            'KZT',
        ),
    ),
    'la' => array(
        'code' => 'la',
        'name' => 'Laos',
        'localized' => 'Laos',
        'native' => 'ສປປລາວ',
        'dial' => array(
            '856',
        ),
        'capital' => 'Vientiane',
        'people' => 'Laotian',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 18.0,
            'lng' => 105.0,
        ),
        'languages' => array(
            'lo',
        ),
        'currencies' => array(
            'LAK',
        ),
    ),
    'lb' => array(
        'code' => 'lb',
        'name' => 'Lebanon',
        'localized' => 'Lebanon',
        'native' => 'لبنان',
        'dial' => array(
            '961',
        ),
        'capital' => 'Beirut',
        'people' => 'Lebanese',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 33.83333333,
            'lng' => 35.83333333,
        ),
        'languages' => array(
            'ar',
            'fr_FR',
        ),
        'currencies' => array(
            'LBP',
        ),
    ),
    'lc' => array(
        'code' => 'lc',
        'name' => 'St. Lucia',
        'localized' => 'St. Lucia',
        'native' => 'Saint Lucia',
        'dial' => array(
            '1758',
        ),
        'capital' => 'Castries',
        'people' => 'Saint Lucian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 13.88333333,
            'lng' => -60.96666666,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'XCD',
        ),
    ),
    'li' => array(
        'code' => 'li',
        'name' => 'Liechtenstein',
        'localized' => 'Liechtenstein',
        'native' => 'Liechtenstein',
        'dial' => array(
            '423',
        ),
        'capital' => 'Vaduz',
        'people' => 'Liechtensteiner',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 47.26666666,
            'lng' => 9.53333333,
        ),
        'languages' => array(
            'de_DE',
        ),
        'currencies' => array(
            'CHF',
        ),
    ),
    'lk' => array(
        'code' => 'lk',
        'name' => 'Sri Lanka',
        'localized' => 'Sri Lanka',
        'native' => 'śrī laṃkāva',
        'dial' => array(
            '94',
        ),
        'capital' => 'Colombo',
        'people' => 'Sri Lankan',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 7.0,
            'lng' => 81.0,
        ),
        'languages' => array(
            'si_LK',
            'ta_LK',
        ),
        'currencies' => array(
            'LKR',
        ),
    ),
    'lr' => array(
        'code' => 'lr',
        'name' => 'Liberia',
        'localized' => 'Liberia',
        'native' => 'Liberia',
        'dial' => array(
            '231',
        ),
        'capital' => 'Monrovia',
        'people' => 'Liberian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 6.5,
            'lng' => -9.5,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'LRD',
        ),
    ),
    'ls' => array(
        'code' => 'ls',
        'name' => 'Lesotho',
        'localized' => 'Lesotho',
        'native' => 'Lesotho',
        'dial' => array(
            '266',
        ),
        'capital' => 'Maseru',
        'people' => 'Mosotho',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -29.5,
            'lng' => 28.5,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'LSL',
            'ZAR',
        ),
    ),
    'lt' => array(
        'code' => 'lt',
        'name' => 'Lithuania',
        'localized' => 'Lithuania',
        'native' => 'Lietuva',
        'dial' => array(
            '370',
        ),
        'capital' => 'Vilnius',
        'people' => 'Lithuanian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 56.0,
            'lng' => 24.0,
        ),
        'languages' => array(
            'lt_LT',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'lu' => array(
        'code' => 'lu',
        'name' => 'Luxembourg',
        'localized' => 'Luxembourg',
        'native' => 'Luxembourg',
        'dial' => array(
            '352',
        ),
        'capital' => 'Luxembourg',
        'people' => 'Luxembourger',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 49.75,
            'lng' => 6.16666666,
        ),
        'languages' => array(
            'de_DE',
            'fr_FR',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'lv' => array(
        'code' => 'lv',
        'name' => 'Latvia',
        'localized' => 'Latvia',
        'native' => 'Latvija',
        'dial' => array(
            '371',
        ),
        'capital' => 'Riga',
        'people' => 'Latvian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 57.0,
            'lng' => 25.0,
        ),
        'languages' => array(
            'lv',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'ly' => array(
        'code' => 'ly',
        'name' => 'Libya',
        'localized' => 'Libya',
        'native' => '‏ليبيا',
        'dial' => array(
            '218',
        ),
        'capital' => 'Tripoli',
        'people' => 'Libyan',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 25.0,
            'lng' => 17.0,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'LYD',
        ),
    ),
    'ma' => array(
        'code' => 'ma',
        'name' => 'Morocco',
        'localized' => 'Morocco',
        'native' => 'المغرب',
        'dial' => array(
            '212',
        ),
        'capital' => 'Rabat',
        'people' => 'Moroccan',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 32.0,
            'lng' => -5.0,
        ),
        'languages' => array(
            'ary',
        ),
        'currencies' => array(
            'MAD',
        ),
    ),
    'mc' => array(
        'code' => 'mc',
        'name' => 'Monaco',
        'localized' => 'Monaco',
        'native' => 'Monaco',
        'dial' => array(
            '377',
        ),
        'capital' => 'Monaco',
        'people' => 'Monegasque',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 43.73333333,
            'lng' => 7.4,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'md' => array(
        'code' => 'md',
        'name' => 'Moldova',
        'localized' => 'Moldova',
        'native' => 'Moldova',
        'dial' => array(
            '373',
        ),
        'capital' => 'Chișinău',
        'people' => 'Moldovan',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 47.0,
            'lng' => 29.0,
        ),
        'languages' => array(
            'ro_RO',
        ),
        'currencies' => array(
            'MDL',
        ),
    ),
    'me' => array(
        'code' => 'me',
        'name' => 'Montenegro',
        'localized' => 'Montenegro',
        'native' => 'Црна Гора',
        'dial' => array(
            '382',
        ),
        'capital' => 'Podgorica',
        'people' => 'Montenegrin',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 42.5,
            'lng' => 19.3,
        ),
        'languages' => array(
            'bs_BA',
            'hr',
            'sq',
            'sr_RS',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'mg' => array(
        'code' => 'mg',
        'name' => 'Madagascar',
        'localized' => 'Madagascar',
        'native' => 'Madagasikara',
        'dial' => array(
            '261',
        ),
        'capital' => 'Antananarivo',
        'people' => 'Malagasy',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -20.0,
            'lng' => 47.0,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'MGA',
        ),
    ),
    'mh' => array(
        'code' => 'mh',
        'name' => 'Marshall Islands',
        'localized' => 'Marshall Islands',
        'native' => 'M̧ajeļ',
        'dial' => array(
            '692',
        ),
        'capital' => 'Majuro',
        'people' => 'Marshallese',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => 9.0,
            'lng' => 168.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'mk' => array(
        'code' => 'mk',
        'name' => 'North Macedonia',
        'localized' => 'North Macedonia',
        'native' => 'Македонија',
        'dial' => array(
            '389',
        ),
        'capital' => 'Skopje',
        'people' => 'Macedonian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 41.83333333,
            'lng' => 22.0,
        ),
        'languages' => array(
            'mk_MK',
        ),
        'currencies' => array(
            'MKD',
        ),
    ),
    'ml' => array(
        'code' => 'ml',
        'name' => 'Mali',
        'localized' => 'Mali',
        'native' => 'Mali',
        'dial' => array(
            '223',
        ),
        'capital' => 'Bamako',
        'people' => 'Malian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 17.0,
            'lng' => -4.0,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'XOF',
        ),
    ),
    'mm' => array(
        'code' => 'mm',
        'name' => 'Myanmar (Burma)',
        'localized' => 'Myanmar (Burma)',
        'native' => 'Myanma',
        'dial' => array(
            '95',
        ),
        'capital' => 'Naypyidaw',
        'people' => 'Burmese',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 22.0,
            'lng' => 98.0,
        ),
        'languages' => array(
            'my_MM',
            'rhg',
        ),
        'currencies' => array(
            'MMK',
        ),
    ),
    'mn' => array(
        'code' => 'mn',
        'name' => 'Mongolia',
        'localized' => 'Mongolia',
        'native' => 'Монгол улс',
        'dial' => array(
            '976',
        ),
        'capital' => 'Ulan Bator',
        'people' => 'Mongolian',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 46.0,
            'lng' => 105.0,
        ),
        'languages' => array(
            'mn',
        ),
        'currencies' => array(
            'MNT',
        ),
    ),
    'mo' => array(
        'code' => 'mo',
        'name' => 'Macao SAR China',
        'localized' => 'Macao SAR China',
        'native' => '澳門',
        'dial' => array(
            '853',
        ),
        'capital' => '',
        'people' => 'Chinese',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 22.16666666,
            'lng' => 113.55,
        ),
        'languages' => array(
            'pt_PT',
            'zh_CN',
            'zh_HK',
            'zh_TW',
        ),
        'currencies' => array(
            'MOP',
        ),
    ),
    'mp' => array(
        'code' => 'mp',
        'name' => 'Northern Mariana Islands',
        'localized' => 'Northern Mariana Islands',
        'native' => 'Northern Mariana Islands',
        'dial' => array(
            '1670',
        ),
        'capital' => 'Saipan',
        'people' => 'American',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => 15.2,
            'lng' => 145.75,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'mq' => array(
        'code' => 'mq',
        'name' => 'Martinique',
        'localized' => 'Martinique',
        'native' => 'Martinique',
        'dial' => array(
            '596',
        ),
        'capital' => 'Fort-de-France',
        'people' => 'French',
        'continent' => 'America',
        'coords' => array(
            'lat' => 14.666667,
            'lng' => -61.0,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'mr' => array(
        'code' => 'mr',
        'name' => 'Mauritania',
        'localized' => 'Mauritania',
        'native' => 'موريتانيا',
        'dial' => array(
            '222',
        ),
        'capital' => 'Nouakchott',
        'people' => 'Mauritanian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 20.0,
            'lng' => -12.0,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'MRO',
        ),
    ),
    'ms' => array(
        'code' => 'ms',
        'name' => 'Montserrat',
        'localized' => 'Montserrat',
        'native' => 'Montserrat',
        'dial' => array(
            '1664',
        ),
        'capital' => 'Plymouth',
        'people' => 'Montserratian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 16.75,
            'lng' => -62.2,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'XCD',
        ),
    ),
    'mt' => array(
        'code' => 'mt',
        'name' => 'Malta',
        'localized' => 'Malta',
        'native' => 'Malta',
        'dial' => array(
            '356',
        ),
        'capital' => 'Valletta',
        'people' => 'Maltese',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 35.83333333,
            'lng' => 14.58333333,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'mu' => array(
        'code' => 'mu',
        'name' => 'Mauritius',
        'localized' => 'Mauritius',
        'native' => 'Maurice',
        'dial' => array(
            '230',
        ),
        'capital' => 'Port Louis',
        'people' => 'Mauritian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -20.28333333,
            'lng' => 57.55,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'MUR',
        ),
    ),
    'mv' => array(
        'code' => 'mv',
        'name' => 'Maldives',
        'localized' => 'Maldives',
        'native' => 'Maldives',
        'dial' => array(
            '960',
        ),
        'capital' => 'Malé',
        'people' => 'Maldivan',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 3.25,
            'lng' => 73.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'MVR',
        ),
    ),
    'mw' => array(
        'code' => 'mw',
        'name' => 'Malawi',
        'localized' => 'Malawi',
        'native' => 'Malawi',
        'dial' => array(
            '265',
        ),
        'capital' => 'Lilongwe',
        'people' => 'Malawian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -13.5,
            'lng' => 34.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'MWK',
        ),
    ),
    'mx' => array(
        'code' => 'mx',
        'name' => 'Mexico',
        'localized' => 'Mexico',
        'native' => 'México',
        'dial' => array(
            '52',
        ),
        'capital' => 'Mexico City',
        'people' => 'Mexican',
        'continent' => 'America',
        'coords' => array(
            'lat' => 23.0,
            'lng' => -102.0,
        ),
        'languages' => array(
            'es_MX',
        ),
        'currencies' => array(
            'MXN',
        ),
    ),
    'my' => array(
        'code' => 'my',
        'name' => 'Malaysia',
        'localized' => 'Malaysia',
        'native' => 'Malaysia',
        'dial' => array(
            '60',
        ),
        'capital' => 'Kuala Lumpur',
        'people' => 'Malaysian',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 2.5,
            'lng' => 112.5,
        ),
        'languages' => array(
            'ms_MY',
        ),
        'currencies' => array(
            'MYR',
        ),
    ),
    'mz' => array(
        'code' => 'mz',
        'name' => 'Mozambique',
        'localized' => 'Mozambique',
        'native' => 'Moçambique',
        'dial' => array(
            '258',
        ),
        'capital' => 'Maputo',
        'people' => 'Mozambican',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -18.25,
            'lng' => 35.0,
        ),
        'languages' => array(
            'pt_PT',
        ),
        'currencies' => array(
            'MZN',
        ),
    ),
    'na' => array(
        'code' => 'na',
        'name' => 'Namibia',
        'localized' => 'Namibia',
        'native' => 'Namibia',
        'dial' => array(
            '264',
        ),
        'capital' => 'Windhoek',
        'people' => 'Namibian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -22.0,
            'lng' => 17.0,
        ),
        'languages' => array(
            'af',
            'en_US',
        ),
        'currencies' => array(
            'NAD',
            'ZAR',
        ),
    ),
    'nc' => array(
        'code' => 'nc',
        'name' => 'New Caledonia',
        'localized' => 'New Caledonia',
        'native' => 'Nouvelle-Calédonie',
        'dial' => array(
            '687',
        ),
        'capital' => 'Nouméa',
        'people' => 'New Caledonian',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -21.5,
            'lng' => 165.5,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'XPF',
        ),
    ),
    'ne' => array(
        'code' => 'ne',
        'name' => 'Niger',
        'localized' => 'Niger',
        'native' => 'Niger',
        'dial' => array(
            '227',
        ),
        'capital' => 'Niamey',
        'people' => 'Nigerien',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 16.0,
            'lng' => 8.0,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'XOF',
        ),
    ),
    'nf' => array(
        'code' => 'nf',
        'name' => 'Norfolk Island',
        'localized' => 'Norfolk Island',
        'native' => 'Norfolk Island',
        'dial' => array(
            '672',
        ),
        'capital' => 'Kingston',
        'people' => 'Norfolk Islander',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -29.03333333,
            'lng' => 167.95,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'AUD',
        ),
    ),
    'ng' => array(
        'code' => 'ng',
        'name' => 'Nigeria',
        'localized' => 'Nigeria',
        'native' => 'Nigeria',
        'dial' => array(
            '234',
        ),
        'capital' => 'Abuja',
        'people' => 'Nigerian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 10.0,
            'lng' => 8.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'NGN',
        ),
    ),
    'ni' => array(
        'code' => 'ni',
        'name' => 'Nicaragua',
        'localized' => 'Nicaragua',
        'native' => 'Nicaragua',
        'dial' => array(
            '505',
        ),
        'capital' => 'Managua',
        'people' => 'Nicaraguan',
        'continent' => 'America',
        'coords' => array(
            'lat' => 13.0,
            'lng' => -85.0,
        ),
        'languages' => array(
            'es_ES',
        ),
        'currencies' => array(
            'NIO',
        ),
    ),
    'nl' => array(
        'code' => 'nl',
        'name' => 'Netherlands',
        'localized' => 'Netherlands',
        'native' => 'Nederland',
        'dial' => array(
            '31',
        ),
        'capital' => 'Amsterdam',
        'people' => 'Dutch',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 52.5,
            'lng' => 5.75,
        ),
        'languages' => array(
            'nl_NL',
            'nl_NL_formal',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'no' => array(
        'code' => 'no',
        'name' => 'Norway',
        'localized' => 'Norway',
        'native' => 'Norge',
        'dial' => array(
            '47',
        ),
        'capital' => 'Oslo',
        'people' => 'Norwegian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 62.0,
            'lng' => 10.0,
        ),
        'languages' => array(
            'nb_NO',
            'nn_NO',
        ),
        'currencies' => array(
            'NOK',
        ),
    ),
    'np' => array(
        'code' => 'np',
        'name' => 'Nepal',
        'localized' => 'Nepal',
        'native' => 'नेपाल',
        'dial' => array(
            '977',
        ),
        'capital' => 'Kathmandu',
        'people' => 'Nepalese',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 28.0,
            'lng' => 84.0,
        ),
        'languages' => array(
            'ne_NP',
        ),
        'currencies' => array(
            'NPR',
        ),
    ),
    'nr' => array(
        'code' => 'nr',
        'name' => 'Nauru',
        'localized' => 'Nauru',
        'native' => 'Nauru',
        'dial' => array(
            '674',
        ),
        'capital' => 'Yaren',
        'people' => 'Nauruan',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -0.53333333,
            'lng' => 166.91666666,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'AUD',
        ),
    ),
    'nu' => array(
        'code' => 'nu',
        'name' => 'Niue',
        'localized' => 'Niue',
        'native' => 'Niuē',
        'dial' => array(
            '683',
        ),
        'capital' => 'Alofi',
        'people' => 'Niuean',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -19.03333333,
            'lng' => -169.86666666,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'NZD',
        ),
    ),
    'nz' => array(
        'code' => 'nz',
        'name' => 'New Zealand',
        'localized' => 'New Zealand',
        'native' => 'New Zealand',
        'dial' => array(
            '64',
        ),
        'capital' => 'Wellington',
        'people' => 'New Zealander',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -41.0,
            'lng' => 174.0,
        ),
        'languages' => array(
            'en_NZ',
        ),
        'currencies' => array(
            'NZD',
        ),
    ),
    'om' => array(
        'code' => 'om',
        'name' => 'Oman',
        'localized' => 'Oman',
        'native' => 'عمان',
        'dial' => array(
            '968',
        ),
        'capital' => 'Muscat',
        'people' => 'Omani',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 21.0,
            'lng' => 57.0,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'OMR',
        ),
    ),
    'pa' => array(
        'code' => 'pa',
        'name' => 'Panama',
        'localized' => 'Panama',
        'native' => 'Panamá',
        'dial' => array(
            '507',
        ),
        'capital' => 'Panama City',
        'people' => 'Panamanian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 9.0,
            'lng' => -80.0,
        ),
        'languages' => array(
            'es_ES',
        ),
        'currencies' => array(
            'PAB',
            'USD',
        ),
    ),
    'pe' => array(
        'code' => 'pe',
        'name' => 'Peru',
        'localized' => 'Peru',
        'native' => 'Perú',
        'dial' => array(
            '51',
        ),
        'capital' => 'Lima',
        'people' => 'Peruvian',
        'continent' => 'America',
        'coords' => array(
            'lat' => -10.0,
            'lng' => -76.0,
        ),
        'languages' => array(
            'es_PE',
        ),
        'currencies' => array(
            'PEN',
        ),
    ),
    'pf' => array(
        'code' => 'pf',
        'name' => 'French Polynesia',
        'localized' => 'French Polynesia',
        'native' => 'Polynésie française',
        'dial' => array(
            '689',
        ),
        'capital' => 'Papeetē',
        'people' => 'French Polynesian',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -15.0,
            'lng' => -140.0,
        ),
        'languages' => array(
            'fr_FR',
            'tah',
        ),
        'currencies' => array(
            'XPF',
        ),
    ),
    'pg' => array(
        'code' => 'pg',
        'name' => 'Papua New Guinea',
        'localized' => 'Papua New Guinea',
        'native' => 'Papua Niugini',
        'dial' => array(
            '675',
        ),
        'capital' => 'Port Moresby',
        'people' => 'Papua New Guinean',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -6.0,
            'lng' => 147.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'PGK',
        ),
    ),
    'ph' => array(
        'code' => 'ph',
        'name' => 'Philippines',
        'localized' => 'Philippines',
        'native' => 'Pilipinas',
        'dial' => array(
            '63',
        ),
        'capital' => 'Manila',
        'people' => 'Filipino',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 13.0,
            'lng' => 122.0,
        ),
        'languages' => array(
            'ceb',
            'en_US',
            'tl',
        ),
        'currencies' => array(
            'PHP',
        ),
    ),
    'pk' => array(
        'code' => 'pk',
        'name' => 'Pakistan',
        'localized' => 'Pakistan',
        'native' => 'Pakistan',
        'dial' => array(
            '92',
        ),
        'capital' => 'Islamabad',
        'people' => 'Pakistani',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 30.0,
            'lng' => 70.0,
        ),
        'languages' => array(
            'en_US',
            'skr',
            'snd',
            'ur',
        ),
        'currencies' => array(
            'PKR',
        ),
    ),
    'pl' => array(
        'code' => 'pl',
        'name' => 'Poland',
        'localized' => 'Poland',
        'native' => 'Polska',
        'dial' => array(
            '48',
        ),
        'capital' => 'Warsaw',
        'people' => 'Polish',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 52.0,
            'lng' => 20.0,
        ),
        'languages' => array(
            'pl_PL',
            'szl',
        ),
        'currencies' => array(
            'PLN',
        ),
    ),
    'pm' => array(
        'code' => 'pm',
        'name' => 'St. Pierre & Miquelon',
        'localized' => 'St. Pierre & Miquelon',
        'native' => 'Saint-Pierre-et-Miquelon',
        'dial' => array(
            '508',
        ),
        'capital' => 'Saint-Pierre',
        'people' => 'French',
        'continent' => 'America',
        'coords' => array(
            'lat' => 46.83333333,
            'lng' => -56.33333333,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'pr' => array(
        'code' => 'pr',
        'name' => 'Puerto Rico',
        'localized' => 'Puerto Rico',
        'native' => 'Puerto Rico',
        'dial' => array(
            '1787',
            '1939',
        ),
        'capital' => 'San Juan',
        'people' => 'Puerto Rican',
        'continent' => 'America',
        'coords' => array(
            'lat' => 18.25,
            'lng' => -66.5,
        ),
        'languages' => array(
            'en_US',
            'es_PR',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'ps' => array(
        'code' => 'ps',
        'name' => 'Palestinian Territories',
        'localized' => 'Palestinian Territories',
        'native' => 'فلسطين',
        'dial' => array(
            '970',
        ),
        'capital' => 'Ramallah',
        'people' => 'Palestinian',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 31.9,
            'lng' => 35.2,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'ILS',
        ),
    ),
    'pt' => array(
        'code' => 'pt',
        'name' => 'Portugal',
        'localized' => 'Portugal',
        'native' => 'Portugal',
        'dial' => array(
            '351',
        ),
        'capital' => 'Lisbon',
        'people' => 'Portuguese',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 39.5,
            'lng' => -8.0,
        ),
        'languages' => array(
            'pt_PT',
            'pt_PT_ao90',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'pw' => array(
        'code' => 'pw',
        'name' => 'Palau',
        'localized' => 'Palau',
        'native' => 'Palau',
        'dial' => array(
            '680',
        ),
        'capital' => 'Ngerulmud',
        'people' => 'Palauan',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => 7.5,
            'lng' => 134.5,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'py' => array(
        'code' => 'py',
        'name' => 'Paraguay',
        'localized' => 'Paraguay',
        'native' => 'Paraguay',
        'dial' => array(
            '595',
        ),
        'capital' => 'Asunción',
        'people' => 'Paraguayan',
        'continent' => 'America',
        'coords' => array(
            'lat' => -23.0,
            'lng' => -58.0,
        ),
        'languages' => array(
            'es_ES',
        ),
        'currencies' => array(
            'PYG',
        ),
    ),
    'qa' => array(
        'code' => 'qa',
        'name' => 'Qatar',
        'localized' => 'Qatar',
        'native' => 'قطر',
        'dial' => array(
            '974',
        ),
        'capital' => 'Doha',
        'people' => 'Qatari',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 25.5,
            'lng' => 51.25,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'QAR',
        ),
    ),
    're' => array(
        'code' => 're',
        'name' => 'Réunion',
        'localized' => 'Réunion',
        'native' => 'La Réunion',
        'dial' => array(
            '262',
        ),
        'capital' => 'Saint-Denis',
        'people' => 'French',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -21.15,
            'lng' => 55.5,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'ro' => array(
        'code' => 'ro',
        'name' => 'Romania',
        'localized' => 'Romania',
        'native' => 'România',
        'dial' => array(
            '40',
        ),
        'capital' => 'Bucharest',
        'people' => 'Romanian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 46.0,
            'lng' => 25.0,
        ),
        'languages' => array(
            'ro_RO',
        ),
        'currencies' => array(
            'RON',
        ),
    ),
    'rs' => array(
        'code' => 'rs',
        'name' => 'Serbia',
        'localized' => 'Serbia',
        'native' => 'Србија',
        'dial' => array(
            '381',
        ),
        'capital' => 'Belgrade',
        'people' => 'Serbian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 44.0,
            'lng' => 21.0,
        ),
        'languages' => array(
            'sr_RS',
        ),
        'currencies' => array(
            'RSD',
        ),
    ),
    'ru' => array(
        'code' => 'ru',
        'name' => 'Russia',
        'localized' => 'Russia',
        'native' => 'Россия',
        'dial' => array(
            '7',
        ),
        'capital' => 'Moscow',
        'people' => 'Russian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 60.0,
            'lng' => 100.0,
        ),
        'languages' => array(
            'ru_RU',
            'sah',
            'tt_RU',
        ),
        'currencies' => array(
            'RUB',
        ),
    ),
    'rw' => array(
        'code' => 'rw',
        'name' => 'Rwanda',
        'localized' => 'Rwanda',
        'native' => 'Rwanda',
        'dial' => array(
            '250',
        ),
        'capital' => 'Kigali',
        'people' => 'Rwandan',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -2.0,
            'lng' => 30.0,
        ),
        'languages' => array(
            'en_US',
            'fr_FR',
        ),
        'currencies' => array(
            'RWF',
        ),
    ),
    'sa' => array(
        'code' => 'sa',
        'name' => 'Saudi Arabia',
        'localized' => 'Saudi Arabia',
        'native' => 'العربية السعودية',
        'dial' => array(
            '966',
        ),
        'capital' => 'Riyadh',
        'people' => 'Saudi Arabian',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 25.0,
            'lng' => 45.0,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'SAR',
        ),
    ),
    'sb' => array(
        'code' => 'sb',
        'name' => 'Solomon Islands',
        'localized' => 'Solomon Islands',
        'native' => 'Solomon Islands',
        'dial' => array(
            '677',
        ),
        'capital' => 'Honiara',
        'people' => 'Solomon Islander',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -8.0,
            'lng' => 159.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'SBD',
        ),
    ),
    'sc' => array(
        'code' => 'sc',
        'name' => 'Seychelles',
        'localized' => 'Seychelles',
        'native' => 'Seychelles',
        'dial' => array(
            '248',
        ),
        'capital' => 'Victoria',
        'people' => 'Seychellois',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -4.58333333,
            'lng' => 55.66666666,
        ),
        'languages' => array(
            'en_US',
            'fr_FR',
        ),
        'currencies' => array(
            'SCR',
        ),
    ),
    'sd' => array(
        'code' => 'sd',
        'name' => 'Sudan',
        'localized' => 'Sudan',
        'native' => 'السودان',
        'dial' => array(
            '249',
        ),
        'capital' => 'Khartoum',
        'people' => 'Sudanese',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 15.0,
            'lng' => 30.0,
        ),
        'languages' => array(
            'ar',
            'en_US',
        ),
        'currencies' => array(
            'SDG',
        ),
    ),
    'se' => array(
        'code' => 'se',
        'name' => 'Sweden',
        'localized' => 'Sweden',
        'native' => 'Sverige',
        'dial' => array(
            '46',
        ),
        'capital' => 'Stockholm',
        'people' => 'Swedish',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 62.0,
            'lng' => 15.0,
        ),
        'languages' => array(
            'sv_SE',
        ),
        'currencies' => array(
            'SEK',
        ),
    ),
    'sg' => array(
        'code' => 'sg',
        'name' => 'Singapore',
        'localized' => 'Singapore',
        'native' => 'Singapore',
        'dial' => array(
            '65',
        ),
        'capital' => 'Singapore',
        'people' => 'Singaporean',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 1.36666666,
            'lng' => 103.8,
        ),
        'languages' => array(
            'en_US',
            'ms_MY',
            'ta_IN',
            'ta_LK',
            'zh_CN',
            'zh_HK',
            'zh_TW',
        ),
        'currencies' => array(
            'BND',
            'SGD',
        ),
    ),
    'sh' => array(
        'code' => 'sh',
        'name' => 'St. Helena',
        'localized' => 'St. Helena',
        'native' => 'Saint Helena',
        'dial' => array(
            '290',
        ),
        'capital' => 'Jamestown',
        'people' => 'Saint Helenian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -15.95,
            'lng' => -5.7,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'SHP',
        ),
    ),
    'si' => array(
        'code' => 'si',
        'name' => 'Slovenia',
        'localized' => 'Slovenia',
        'native' => 'Slovenija',
        'dial' => array(
            '386',
        ),
        'capital' => 'Ljubljana',
        'people' => 'Slovene',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 46.11666666,
            'lng' => 14.81666666,
        ),
        'languages' => array(
            'sl_SI',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'sk' => array(
        'code' => 'sk',
        'name' => 'Slovakia',
        'localized' => 'Slovakia',
        'native' => 'Slovensko',
        'dial' => array(
            '421',
        ),
        'capital' => 'Bratislava',
        'people' => 'Slovak',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 48.66666666,
            'lng' => 19.5,
        ),
        'languages' => array(
            'sk_SK',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'sl' => array(
        'code' => 'sl',
        'name' => 'Sierra Leone',
        'localized' => 'Sierra Leone',
        'native' => 'Sierra Leone',
        'dial' => array(
            '232',
        ),
        'capital' => 'Freetown',
        'people' => 'Sierra Leonean',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 8.5,
            'lng' => -11.5,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'SLL',
        ),
    ),
    'sm' => array(
        'code' => 'sm',
        'name' => 'San Marino',
        'localized' => 'San Marino',
        'native' => 'San Marino',
        'dial' => array(
            '378',
        ),
        'capital' => 'City of San Marino',
        'people' => 'Sammarinese',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 43.76666666,
            'lng' => 12.41666666,
        ),
        'languages' => array(
            'it_IT',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'sn' => array(
        'code' => 'sn',
        'name' => 'Senegal',
        'localized' => 'Senegal',
        'native' => 'Sénégal',
        'dial' => array(
            '221',
        ),
        'capital' => 'Dakar',
        'people' => 'Senegalese',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 14.0,
            'lng' => -14.0,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'XOF',
        ),
    ),
    'so' => array(
        'code' => 'so',
        'name' => 'Somalia',
        'localized' => 'Somalia',
        'native' => 'Soomaaliya',
        'dial' => array(
            '252',
        ),
        'capital' => 'Mogadishu',
        'people' => 'Somali',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 10.0,
            'lng' => 49.0,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'SOS',
        ),
    ),
    'sr' => array(
        'code' => 'sr',
        'name' => 'Suriname',
        'localized' => 'Suriname',
        'native' => 'Suriname',
        'dial' => array(
            '597',
        ),
        'capital' => 'Paramaribo',
        'people' => 'Surinamer',
        'continent' => 'America',
        'coords' => array(
            'lat' => 4.0,
            'lng' => -56.0,
        ),
        'languages' => array(
            'nl_NL',
        ),
        'currencies' => array(
            'SRD',
        ),
    ),
    'st' => array(
        'code' => 'st',
        'name' => 'São Tomé & Príncipe',
        'localized' => 'São Tomé & Príncipe',
        'native' => 'São Tomé e Príncipe',
        'dial' => array(
            '239',
        ),
        'capital' => 'São Tomé',
        'people' => 'Sao Tomean',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 1.0,
            'lng' => 7.0,
        ),
        'languages' => array(
            'pt_PT',
        ),
        'currencies' => array(
            'STD',
        ),
    ),
    'sv' => array(
        'code' => 'sv',
        'name' => 'El Salvador',
        'localized' => 'El Salvador',
        'native' => 'El Salvador',
        'dial' => array(
            '503',
        ),
        'capital' => 'San Salvador',
        'people' => 'Salvadoran',
        'continent' => 'America',
        'coords' => array(
            'lat' => 13.83333333,
            'lng' => -88.91666666,
        ),
        'languages' => array(
            'es_ES',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'sy' => array(
        'code' => 'sy',
        'name' => 'Syria',
        'localized' => 'Syria',
        'native' => 'سوريا',
        'dial' => array(
            '963',
        ),
        'capital' => 'Damascus',
        'people' => 'Syrian',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 35.0,
            'lng' => 38.0,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'SYP',
        ),
    ),
    'sz' => array(
        'code' => 'sz',
        'name' => 'Eswatini',
        'localized' => 'Eswatini',
        'native' => 'Swaziland',
        'dial' => array(
            '268',
        ),
        'capital' => 'Lobamba',
        'people' => 'Swazi',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -26.5,
            'lng' => 31.5,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'SZL',
        ),
    ),
    'tc' => array(
        'code' => 'tc',
        'name' => 'Turks & Caicos Islands',
        'localized' => 'Turks & Caicos Islands',
        'native' => 'Turks and Caicos Islands',
        'dial' => array(
            '1649',
        ),
        'capital' => 'Cockburn Town',
        'people' => 'Turks and Caicos Islander',
        'continent' => 'America',
        'coords' => array(
            'lat' => 21.75,
            'lng' => -71.58333333,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'td' => array(
        'code' => 'td',
        'name' => 'Chad',
        'localized' => 'Chad',
        'native' => 'Tchad',
        'dial' => array(
            '235',
        ),
        'capital' => 'N\'Djamena',
        'people' => 'Chadian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 15.0,
            'lng' => 19.0,
        ),
        'languages' => array(
            'ar',
            'fr_FR',
        ),
        'currencies' => array(
            'XAF',
        ),
    ),
    'tg' => array(
        'code' => 'tg',
        'name' => 'Togo',
        'localized' => 'Togo',
        'native' => 'Togo',
        'dial' => array(
            '228',
        ),
        'capital' => 'Lomé',
        'people' => 'Togolese',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 8.0,
            'lng' => 1.16666666,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'XOF',
        ),
    ),
    'th' => array(
        'code' => 'th',
        'name' => 'Thailand',
        'localized' => 'Thailand',
        'native' => 'ประเทศไทย',
        'dial' => array(
            '66',
        ),
        'capital' => 'Bangkok',
        'people' => 'Thai',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 15.0,
            'lng' => 100.0,
        ),
        'languages' => array(
            'th',
        ),
        'currencies' => array(
            'THB',
        ),
    ),
    'tj' => array(
        'code' => 'tj',
        'name' => 'Tajikistan',
        'localized' => 'Tajikistan',
        'native' => 'Тоҷикистон',
        'dial' => array(
            '992',
        ),
        'capital' => 'Dushanbe',
        'people' => 'Tadzhik',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 39.0,
            'lng' => 71.0,
        ),
        'languages' => array(
            'ru_RU',
        ),
        'currencies' => array(
            'TJS',
        ),
    ),
    'tk' => array(
        'code' => 'tk',
        'name' => 'Tokelau',
        'localized' => 'Tokelau',
        'native' => 'Tokelau',
        'dial' => array(
            '690',
        ),
        'capital' => 'Fakaofo',
        'people' => 'Tokelauan',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -9.0,
            'lng' => -172.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'NZD',
        ),
    ),
    'tl' => array(
        'code' => 'tl',
        'name' => 'Timor-Leste',
        'localized' => 'Timor-Leste',
        'native' => 'Timor-Leste',
        'dial' => array(
            '670',
        ),
        'capital' => 'Dili',
        'people' => 'East Timorese',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => -8.83333333,
            'lng' => 125.91666666,
        ),
        'languages' => array(
            'pt_PT',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'tm' => array(
        'code' => 'tm',
        'name' => 'Turkmenistan',
        'localized' => 'Turkmenistan',
        'native' => 'Türkmenistan',
        'dial' => array(
            '993',
        ),
        'capital' => 'Ashgabat',
        'people' => 'Turkmen',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 40.0,
            'lng' => 60.0,
        ),
        'languages' => array(
            'ru_RU',
        ),
        'currencies' => array(
            'TMT',
        ),
    ),
    'tn' => array(
        'code' => 'tn',
        'name' => 'Tunisia',
        'localized' => 'Tunisia',
        'native' => 'تونس',
        'dial' => array(
            '216',
        ),
        'capital' => 'Tunis',
        'people' => 'Tunisian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 34.0,
            'lng' => 9.0,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'TND',
        ),
    ),
    'to' => array(
        'code' => 'to',
        'name' => 'Tonga',
        'localized' => 'Tonga',
        'native' => 'Tonga',
        'dial' => array(
            '676',
        ),
        'capital' => 'Nuku\'alofa',
        'people' => 'Tongan',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -20.0,
            'lng' => -175.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'TOP',
        ),
    ),
    'tr' => array(
        'code' => 'tr',
        'name' => 'Turkey',
        'localized' => 'Turkey',
        'native' => 'Türkiye',
        'dial' => array(
            '90',
        ),
        'capital' => 'Ankara',
        'people' => 'Turkish',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 39.0,
            'lng' => 35.0,
        ),
        'languages' => array(
            'tr_TR',
        ),
        'currencies' => array(
            'TRY',
        ),
    ),
    'tt' => array(
        'code' => 'tt',
        'name' => 'Trinidad & Tobago',
        'localized' => 'Trinidad & Tobago',
        'native' => 'Trinidad and Tobago',
        'dial' => array(
            '1868',
        ),
        'capital' => 'Port of Spain',
        'people' => 'Trinidadian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 11.0,
            'lng' => -61.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'TTD',
        ),
    ),
    'tv' => array(
        'code' => 'tv',
        'name' => 'Tuvalu',
        'localized' => 'Tuvalu',
        'native' => 'Tuvalu',
        'dial' => array(
            '688',
        ),
        'capital' => 'Funafuti',
        'people' => 'Tuvaluan',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -8.0,
            'lng' => 178.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'AUD',
            'TVD[G]',
        ),
    ),
    'tw' => array(
        'code' => 'tw',
        'name' => 'Taiwan',
        'localized' => 'Taiwan',
        'native' => '臺灣',
        'dial' => array(
            '886',
        ),
        'capital' => 'Taipei',
        'people' => 'Taiwanese',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 23.5,
            'lng' => 121.0,
        ),
        'languages' => array(
            'zh_TW',
        ),
        'currencies' => array(
            'TWD',
        ),
    ),
    'tz' => array(
        'code' => 'tz',
        'name' => 'Tanzania',
        'localized' => 'Tanzania',
        'native' => 'Tanzania',
        'dial' => array(
            '255',
        ),
        'capital' => 'Dodoma',
        'people' => 'Tanzanian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -6.0,
            'lng' => 35.0,
        ),
        'languages' => array(
            'en_US',
            'sw',
        ),
        'currencies' => array(
            'TZS',
        ),
    ),
    'ua' => array(
        'code' => 'ua',
        'name' => 'Ukraine',
        'localized' => 'Ukraine',
        'native' => 'Україна',
        'dial' => array(
            '380',
        ),
        'capital' => 'Kiev',
        'people' => 'Ukrainian',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 49.0,
            'lng' => 32.0,
        ),
        'languages' => array(
            'uk',
        ),
        'currencies' => array(
            'UAH',
        ),
    ),
    'ug' => array(
        'code' => 'ug',
        'name' => 'Uganda',
        'localized' => 'Uganda',
        'native' => 'Uganda',
        'dial' => array(
            '256',
        ),
        'capital' => 'Kampala',
        'people' => 'Ugandan',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => 1.0,
            'lng' => 32.0,
        ),
        'languages' => array(
            'en_US',
            'sw',
        ),
        'currencies' => array(
            'UGX',
        ),
    ),
    'us' => array(
        'code' => 'us',
        'name' => 'United States',
        'localized' => 'United States',
        'native' => 'United States',
        'dial' => array(
            '1',
        ),
        'capital' => 'Washington, D.C.',
        'people' => 'American',
        'continent' => 'America',
        'coords' => array(
            'lat' => 38.0,
            'lng' => -97.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'uy' => array(
        'code' => 'uy',
        'name' => 'Uruguay',
        'localized' => 'Uruguay',
        'native' => 'Uruguay',
        'dial' => array(
            '598',
        ),
        'capital' => 'Montevideo',
        'people' => 'Uruguayan',
        'continent' => 'America',
        'coords' => array(
            'lat' => -33.0,
            'lng' => -56.0,
        ),
        'languages' => array(
            'es_UY',
        ),
        'currencies' => array(
            'UYU',
        ),
    ),
    'uz' => array(
        'code' => 'uz',
        'name' => 'Uzbekistan',
        'localized' => 'Uzbekistan',
        'native' => 'O‘zbekiston',
        'dial' => array(
            '998',
        ),
        'capital' => 'Tashkent',
        'people' => 'Uzbekistani',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 41.0,
            'lng' => 64.0,
        ),
        'languages' => array(
            'ru_RU',
            'uz_UZ',
        ),
        'currencies' => array(
            'UZS',
        ),
    ),
    'va' => array(
        'code' => 'va',
        'name' => 'Vatican City',
        'localized' => 'Vatican City',
        'native' => 'Sancta Sedes',
        'dial' => array(
            '379',
        ),
        'capital' => 'Rome',
        'people' => '',
        'continent' => 'Europe',
        'coords' => array(
            'lat' => 41.9,
            'lng' => 12.45,
        ),
        'languages' => array(
            'de_DE',
            'fr_FR',
            'it_IT',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'vc' => array(
        'code' => 'vc',
        'name' => 'St. Vincent & Grenadines',
        'localized' => 'St. Vincent & Grenadines',
        'native' => 'Saint Vincent and the Grenadines',
        'dial' => array(
            '1784',
        ),
        'capital' => 'Kingstown',
        'people' => 'Saint Vincentian',
        'continent' => 'America',
        'coords' => array(
            'lat' => 13.25,
            'lng' => -61.2,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'XCD',
        ),
    ),
    've' => array(
        'code' => 've',
        'name' => 'Venezuela',
        'localized' => 'Venezuela',
        'native' => 'Venezuela',
        'dial' => array(
            '58',
        ),
        'capital' => 'Caracas',
        'people' => 'Venezuelan',
        'continent' => 'America',
        'coords' => array(
            'lat' => 8.0,
            'lng' => -66.0,
        ),
        'languages' => array(
            'es_VE',
        ),
        'currencies' => array(
            'VEF',
        ),
    ),
    'vg' => array(
        'code' => 'vg',
        'name' => 'British Virgin Islands',
        'localized' => 'British Virgin Islands',
        'native' => 'British Virgin Islands',
        'dial' => array(
            '1284',
        ),
        'capital' => 'Road Town',
        'people' => 'Virgin Islander',
        'continent' => 'America',
        'coords' => array(
            'lat' => 18.431383,
            'lng' => -64.62305,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'vi' => array(
        'code' => 'vi',
        'name' => 'U.S. Virgin Islands',
        'localized' => 'U.S. Virgin Islands',
        'native' => 'Virgin Islands of the United States',
        'dial' => array(
            '1 340',
        ),
        'capital' => 'Charlotte Amalie',
        'people' => 'Virgin Islander',
        'continent' => 'America',
        'coords' => array(
            'lat' => 18.34,
            'lng' => -64.93,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'USD',
        ),
    ),
    'vn' => array(
        'code' => 'vn',
        'name' => 'Vietnam',
        'localized' => 'Vietnam',
        'native' => 'Việt Nam',
        'dial' => array(
            '84',
        ),
        'capital' => 'Hanoi',
        'people' => 'Vietnamese',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 16.16666666,
            'lng' => 107.83333333,
        ),
        'languages' => array(
            'vi',
        ),
        'currencies' => array(
            'VND',
        ),
    ),
    'vu' => array(
        'code' => 'vu',
        'name' => 'Vanuatu',
        'localized' => 'Vanuatu',
        'native' => 'Vanuatu',
        'dial' => array(
            '678',
        ),
        'capital' => 'Port Vila',
        'people' => 'Ni-Vanuatu',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -16.0,
            'lng' => 167.0,
        ),
        'languages' => array(
            'en_US',
            'fr_FR',
        ),
        'currencies' => array(
            'VUV',
        ),
    ),
    'wf' => array(
        'code' => 'wf',
        'name' => 'Wallis & Futuna',
        'localized' => 'Wallis & Futuna',
        'native' => 'Wallis et Futuna',
        'dial' => array(
            '681',
        ),
        'capital' => 'Mata-Utu',
        'people' => 'Wallis and Futuna Islander',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -13.3,
            'lng' => -176.2,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'XPF',
        ),
    ),
    'ws' => array(
        'code' => 'ws',
        'name' => 'Samoa',
        'localized' => 'Samoa',
        'native' => 'Samoa',
        'dial' => array(
            '685',
        ),
        'capital' => 'Apia',
        'people' => 'Samoan',
        'continent' => 'Oceania',
        'coords' => array(
            'lat' => -13.58333333,
            'lng' => -172.33333333,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'WST',
        ),
    ),
    'ye' => array(
        'code' => 'ye',
        'name' => 'Yemen',
        'localized' => 'Yemen',
        'native' => 'اليَمَن',
        'dial' => array(
            '967',
        ),
        'capital' => 'Sana\'a',
        'people' => 'Yemeni',
        'continent' => 'Asia',
        'coords' => array(
            'lat' => 15.0,
            'lng' => 48.0,
        ),
        'languages' => array(
            'ar',
        ),
        'currencies' => array(
            'YER',
        ),
    ),
    'yt' => array(
        'code' => 'yt',
        'name' => 'Mayotte',
        'localized' => 'Mayotte',
        'native' => 'Mayotte',
        'dial' => array(
            '262',
        ),
        'capital' => 'Mamoudzou',
        'people' => 'French',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -12.83333333,
            'lng' => 45.16666666,
        ),
        'languages' => array(
            'fr_FR',
        ),
        'currencies' => array(
            'EUR',
        ),
    ),
    'za' => array(
        'code' => 'za',
        'name' => 'South Africa',
        'localized' => 'South Africa',
        'native' => 'South Africa',
        'dial' => array(
            '27',
        ),
        'capital' => 'Pretoria',
        'people' => 'South African',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -29.0,
            'lng' => 24.0,
        ),
        'languages' => array(
            'af',
            'en_ZA',
        ),
        'currencies' => array(
            'ZAR',
        ),
    ),
    'zm' => array(
        'code' => 'zm',
        'name' => 'Zambia',
        'localized' => 'Zambia',
        'native' => 'Zambia',
        'dial' => array(
            '260',
        ),
        'capital' => 'Lusaka',
        'people' => 'Zambian',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -15.0,
            'lng' => 30.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'ZMW',
        ),
    ),
    'zw' => array(
        'code' => 'zw',
        'name' => 'Zimbabwe',
        'localized' => 'Zimbabwe',
        'native' => 'Zimbabwe',
        'dial' => array(
            '263',
        ),
        'capital' => 'Harare',
        'people' => 'Zimbabwean',
        'continent' => 'Africa',
        'coords' => array(
            'lat' => -20.0,
            'lng' => 30.0,
        ),
        'languages' => array(
            'en_US',
        ),
        'currencies' => array(
            'BWP',
            'GBP',
            'CNY',
            'EUR',
            'INR',
            'JPY',
            'ZAR',
            'USD',
        ),
    ),
);