<?php
/**
 * Event scheduled trigger class
 */

namespace underDEV\AdvancedCronManagerPRO\Integration\Notification;

use BracketSpace\Notification\Repository\Trigger\BaseTrigger;
use BracketSpace\Notification\Repository\MergeTag;

/**
 * Event scheduled trigger class
 */
class EventScheduledTrigger extends BaseTrigger {

	/**
	 * Event hook.
	 *
	 * @var  string
	 */
	public $hook;

	/**
	 * Event schedule.
	 *
	 * @var  string
	 */
	public $schedule;

	/**
	 * Event arguments.
	 *
	 * @var  array
	 */
	public $args;

	/**
	 * Event next call datetime.
	 *
	 * @var  int
	 */
	public $datetime_next_call;

	/**
	 * Event schedule datetime.
	 *
	 * @var  int
	 */
	public $datetime_scheduled;


	/**
	 * Constructor
	 */
	public function __construct() {

		parent::__construct(
			'advanced-cron-manager/event-scheduled',
			__( 'Event scheduled', 'advanced-cron-manager' )
		);

		$this->addAction( 'advanced-cron-manager/event/scheduled', 10, 4 );

		$this->setGroup( __( 'Advanced Cron Manager', 'advanced-cron-manager' ) );

		$this->setDescription(
			__( 'Fires when cron even is scheduled with ACM', 'advanced-cron-manager' )
		);

	}

	/**
	 * Assigns action callback args to object
	 * Return `false` if you want to abort the trigger execution
	 *
	 * You can use the action method arguments as usually.
	 *
	 * @return mixed void or false if no notifications should be sent
	 */
	public function context( $hook, $execution_timestamp, $schedule, $args ) {
		$this->hook               = $hook;
		$this->schedule           = $schedule->slug;
		$this->args               = $args;
		$this->datetime_next_call = $execution_timestamp;
		$this->datetime_scheduled = time();
	}

	/**
	 * Registers attached merge tags
	 *
	 * @return void
	 */
	public function mergeTags() {

		$this->addMergeTag( new MergeTag\StringTag( array(
			'slug'        => 'event_hook',
			'name'        => __( 'Event hook', 'advanced-cron-manager' ),
			'description' => 'cron_hook',
			'example'     => true,
			'resolver'    => function( $trigger ) {
				return $trigger->hook;
			},
		) ) );

		$this->addMergeTag( new MergeTag\StringTag( array(
			'slug'        => 'event_schedule',
			'name'        => __( 'Event schedule', 'advanced-cron-manager' ),
			'description' => 'daily',
			'example'     => true,
			'resolver'    => function( $trigger ) {
				return $trigger->schedule;
			},
		) ) );

		$this->addMergeTag( new MergeTag\StringTag( array(
			'slug'        => 'event_args',
			'name'        => __( 'Event args', 'advanced-cron-manager' ),
			'description' => '1, single',
			'example'     => true,
			'resolver'    => function( $trigger ) {
				return implode( ', ', $trigger->args );
			},
		) ) );

		$this->addMergeTag( new MergeTag\DateTime\DateTime( array(
			'slug' => 'datetime_scheduled',
			'name' => __( 'Date and Time scheduled', 'advanced-cron-manager' ),
		) ) );

		$this->addMergeTag( new MergeTag\DateTime\DateTime( array(
			'slug' => 'datetime_next_call',
			'name' => __( 'Date and Time of the next call', 'advanced-cron-manager' ),
		) ) );

    }

}
