<?php
/**
 * Cron error trigger class
 */

namespace underDEV\AdvancedCronManagerPRO\Integration\Notification;

use BracketSpace\Notification\Repository\Trigger\BaseTrigger;
use BracketSpace\Notification\Repository\MergeTag;

/**
 * Cron error trigger class
 */
class CronErrorTrigger extends BaseTrigger {

	/**
	 * Event instance.
	 *
	 * @var  object
	 */
	public $event;

	/**
	 * Event error message.
	 *
	 * @var  string
	 */
	public $error;

	/**
	 * Event error type.
	 *
	 * @var  string
	 */
	public $error_type;

	/**
	 * Event call datetime.
	 *
	 * @var  int
	 */
	public $time_called;


	/**
	 * Constructor
	 */
	public function __construct() {

		parent::__construct(
			'advanced-cron-manager/event-fail',
			__( 'Event failed to execute', 'advanced-cron-manager' )
		);

		$this->addAction( 'advanced-cron-manager/error', 10, 4 );

		$this->setGroup( __( 'Advanced Cron Manager', 'advanced-cron-manager' ) );

		$this->setDescription(
			__( 'Fires when any cron event fail', 'advanced-cron-manager' )
		);

	}

	/**
	 * Assigns action callback args to object
	 * Return `false` if you want to abort the trigger execution
	 *
	 * You can use the action method arguments as usually.
	 *
	 * @return mixed void or false if no notifications should be sent
	 */
	public function context( $deprecated, $event, $error, $error_type ) {
		$this->event       = $event;
		$this->error       = $error;
		$this->error_type  = $error_type;
		$this->time_called = time();
	}

	/**
	 * Registers attached merge tags
	 *
	 * @return void
	 */
	public function mergeTags() {

		$this->addMergeTag( new MergeTag\StringTag( array(
			'slug'        => 'event_hook',
			'name'        => __( 'Event hook', 'advanced-cron-manager' ),
			'description' => 'cron_hook',
			'example'     => true,
			'resolver'    => function( $trigger ) {
				return $trigger->event->hook;
			},
		) ) );

		$this->addMergeTag( new MergeTag\StringTag( array(
			'slug'        => 'event_schedule',
			'name'        => __( 'Event schedule', 'advanced-cron-manager' ),
			'description' => 'daily',
			'example'     => true,
			'resolver'    => function( $trigger ) {
				return $trigger->event->schedule;
			},
		) ) );

		$this->addMergeTag( new MergeTag\StringTag( array(
			'slug'        => 'event_args',
			'name'        => __( 'Event args', 'advanced-cron-manager' ),
			'description' => '1, single',
			'example'     => true,
			'resolver'    => function( $trigger ) {
				return implode( ', ', $trigger->event->args );
			},
		) ) );

		$this->addMergeTag( new MergeTag\DateTime\DateTime( array(
			'slug' => 'time_called',
			'name' => __( 'Time called', 'advanced-cron-manager' ),
		) ) );

		$this->addMergeTag( new MergeTag\StringTag( array(
			'slug'        => 'error_type',
			'name'        => __( 'Error type', 'advanced-cron-manager' ),
			'description' => 'fatal or warning (includes warnings and notices)',
			'resolver'    => function( $trigger ) {
				return $trigger->error_type;
			},
		) ) );

		$this->addMergeTag( new MergeTag\StringTag( array(
			'slug'        => 'error_message',
			'name'        => __( 'Error message', 'advanced-cron-manager' ),
			'description' => 'Fatal error: Call to undefined function dupa() in /var/www/html/wp-content/plugins/cron-dummy.php at line 69',
			'example'     => true,
			'resolver'    => function( $trigger ) {
				return $trigger->error;
			},
		) ) );

    }

}
