<?php

namespace KaliForms\Inc\Backend\PredefinedForms;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class Gaming_Tournament_Registration_Form
 *
 * @package Inc\Backend\PredefinedForms
 */
class Gaming_Tournament_Registration_Form extends Predefined_Form
{
    /**
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->id = 'gamingTournament';
        $this->name = __('Gaming tournament registration', 'kaliforms');
        $this->description = __('Allow ESL teams to join your tournament through this form.', 'kaliforms');
        $this->emails = [
            ["fromName" => "Tournament Event", "fromEmail" => "{admin_email}", "toEmail" => "{email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "Tournament registration confirmation!", "emailAttachment" => "", "emailBody" => "<p>Thank you for registering your team for our event.</p><p>Your registration number is => XXXXXXXX.</p><p>The registration number will be needed at the event venue, please make sure to print this email or take a screenshot.</p>", "emailAttachmentFilePaths" => "", "emailAttachmentMediaIds" => ""],
            ["fromName" => "{team-coach} - {team-name}", "fromEmail" => "{email}", "toEmail" => "{admin_email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "A new team has registered for the tournament!", "emailAttachment" => "", "emailBody" => "<p>A new team has registered for the tournament.</p><p>{imagePreview=>{team-logo}}</p><p>{team-name} - {team coach}</p><p>{country-of-origin}</p><p>Games competing in: {games}</p><p>--------------------------------------------------------</p><p>Team players=></p><p>{player1},{player2},{player3},{player4},{player5},{player6},{player7},{player8},{player9},{player10}</p>", "emailAttachmentFilePaths" => "", "emailAttachmentMediaIds" => ""],
        ];
        $this->thank_you_message = ['key' => 'thankYouMessage', 'value' => 'Thank you for your registration!'];
        $this->form_info = [
            'thankYouMessage' => 'Thank you for your registration!',
            'showThankYouMessage' => '1',
			'requiredFieldMark' => '*',
			'saveFormSubmissions' => '1',
        ];

        $this->grid = [
            ["w" => 12, "h" => 1, "x" => 0, "y" => 0, "i" => "freeText0", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 10, "h" => 1, "x" => 0, "y" => 4, "i" => "textbox1", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 10, "h" => 1, "x" => 0, "y" => 2, "i" => "textbox2", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 1, "i" => "divider3", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 10, "h" => 1, "x" => 0, "y" => 3, "i" => "textbox4", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 6, "i" => "checkbox5", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 10, "h" => 1, "x" => 0, "y" => 5, "i" => "fileUpload6", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 7, "i" => "divider7", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 6, "h" => 1, "x" => 0, "y" => 8, "i" => "textbox8", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 6, "h" => 1, "x" => 6, "y" => 8, "i" => "textbox9", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 6, "h" => 1, "x" => 0, "y" => 9, "i" => "textbox10", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 6, "h" => 1, "x" => 6, "y" => 9, "i" => "textbox11", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 6, "h" => 1, "x" => 0, "y" => 10, "i" => "textbox12", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 6, "h" => 1, "x" => 6, "y" => 10, "i" => "textbox13", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 6, "h" => 1, "x" => 0, "y" => 11, "i" => "textbox14", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 6, "h" => 1, "x" => 6, "y" => 11, "i" => "textbox15", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 6, "h" => 1, "x" => 0, "y" => 12, "i" => "textbox16", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 13, "i" => "freeText17", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 14, "i" => "submitButton18", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 6, "h" => 1, "x" => 6, "y" => 12, "i" => "textbox19", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
        ];
        $this->field_components = [
            ["id" => "freeText", "label" => "Free Text", "internalId" => "freeText0", "properties" => ["id" => "instructions", "content" => "Register your team players and the titles your team will participate in."], "constraint" => "none"],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox1", "properties" => ["id" => "country-of-origin", "name" => "country-of-origin", "caption" => "Country of origin", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none"],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox2", "properties" => ["id" => "team-name", "name" => "team-name", "caption" => "Team name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none"],
            ["id" => "divider", "label" => "Divider", "internalId" => "divider3", "properties" => ["id" => "team-info", "name" => "team-info", "caption" => "Team info", "type" => "line"], "constraint" => 12],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox4", "properties" => ["id" => "team-coach", "name" => "team-coach", "caption" => "Team coach", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none"],
            ["id" => "checkbox", "label" => "Checkbox", "internalId" => "checkbox5", "properties" => ["id" => "games", "name" => "games", "caption" => "Select the games you will compete in:", "description" => "", "default" => "", "flow" => "vertical", "choices" => [["value" => "lol", "label" => "League of Legends"], ["value" => "wow", "label" => "World of Warcraft Arena"], ["value" => "destiny2", "label" => "Destiny 2 competitive"], ["value" => "overwatch", "label" => "Overwatch"]], "required" => true, "readonly" => false], "constraint" => 0],
            ["id" => "fileUpload", "label" => "File upload", "internalId" => "fileUpload6", "properties" => ["id" => "team-logo", "name" => "team-logo", "caption" => "Team logo", "description" => "", "default" => "", "maxFileSize" => "", "acceptedExtensions" => "", "filePrefix" => "", "instantUpload" => true, "imagePreview" => true, "required" => false, "readonly" => false], "constraint" => "none"],
            ["id" => "divider", "label" => "Divider", "internalId" => "divider7", "properties" => ["id" => "team-players", "name" => "team-players", "caption" => "Team players", "type" => "line"], "constraint" => 12],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox8", "properties" => ["id" => "player1", "name" => "player1", "caption" => "Player #1", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none"],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox9", "properties" => ["id" => "player2", "name" => "player2", "caption" => "Player #2", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => 0],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox10", "properties" => ["id" => "player3", "name" => "player3", "caption" => "Player #3", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => 0],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox11", "properties" => ["id" => "player4", "name" => "player4", "caption" => "Player #4", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none"],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox12", "properties" => ["id" => "player5", "name" => "player5", "caption" => "Player #5", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none"],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox13", "properties" => ["id" => "player6", "name" => "player6", "caption" => "Player #6", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none"],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox14", "properties" => ["id" => "player7", "name" => "player7", "caption" => "Player #7", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => 0],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox15", "properties" => ["id" => "player8", "name" => "player8", "caption" => "Player #8", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => 0],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox16", "properties" => ["id" => "player9", "name" => "player9", "caption" => "Player #9", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => 0],
            ["id" => "freeText", "label" => "Free Text", "internalId" => "freeText17", "properties" => ["id" => "closing-notes", "content" => "The tournament brackets and schedule are published online, please make sure to register enough players since matches can overlap."], "constraint" => "none"],
            ["id" => "submitButton", "label" => "Submit Button", "internalId" => "submitButton18", "properties" => ["id" => "submit", "caption" => "Enter team", "description" => ""], "constraint" => 0],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox19", "properties" => ["id" => "player10", "name" => "player10", "caption" => "Player #10", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none"],
        ];
    }
}
