<?php
namespace KaliForms\Inc;

use KaliForms\Inc\Backend\BuilderFormFields;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class constructor
 */
class Pro_Form_Fields
{
    /**
     * Plugin slug
     *
     * @var string
     */
    protected $slug = 'kaliforms-pro';
    /**
     * Parent plugin slug
     *
     * @var string
     */
    protected $parent_slug = 'kaliforms';
    /**
     * Construct function
     */
    public function __construct()
    {
        add_filter($this->parent_slug . '_default_form_fields', [$this, 'register_fields']);
        add_filter($this->parent_slug . '_frontend_field_types', [$this, 'register_frontend_fields']);
    }

    /**
     * Undocumented function
     *
     * @param [type] $types
     * @return void
     */
    public function register_frontend_fields($types)
    {
        return array_merge($types, [
            'range'              => 'KaliForms\Inc\Frontend\FormFields\Range',
            'password'           => 'KaliForms\Inc\Frontend\FormFields\Password',
            'dateTimePicker'     => 'KaliForms\Inc\Frontend\FormFields\Date_Time_Picker',
            'choices'            => 'KaliForms\Inc\Frontend\FormFields\Choices',
            'pageBreak'          => 'KaliForms\Inc\Frontend\FormFields\PageBreak',
            'smartTextOutput'    => 'KaliForms\Inc\Frontend\FormFields\Smart_Text_Output',
            'rating'             => 'KaliForms\Inc\Frontend\FormFields\Rating',
            'colorPicker'        => 'KaliForms\Inc\Frontend\FormFields\Color_Picker',
            'termsAndConditions' => 'KaliForms\Inc\Frontend\FormFields\Terms_And_Conditions',
            'gdpr'               => 'KaliForms\Inc\Frontend\FormFields\GDPR',
        ]);
    }

    /**
     * Register form fields in the main plugin array
     *
     * @param [type] $fields
     * @return void
     */
    public function register_fields($fields)
    {
        foreach ($fields as $k => $group) {
            if ($group['id'] === 'advanced') {
                $fields[$k]['fields'] = array_merge($fields[$k]['fields'], $this->get_advanced_fields());
            }
        }

        return $fields;
    }

    public function get_advanced_fields()
    {
        return [
            new BuilderFormFields\GDPR([]),
            new BuilderFormFields\Terms_And_Conditions([
                'termsType' => [
                    'type'    => 'select',
                    'label'   => esc_html__('Field type', 'kaliforms'),
                    'value'   => 'url',
                    'choices' => [
                        ['value' => 'url', 'label' => esc_html__('URL', 'kaliforms')],
                        ['value' => 'text', 'label' => esc_html__('Custom text', 'kaliforms')],
                    ],
                ],
                'termsUrl'  => [
                    'type'      => 'url',
                    'label'     => esc_html__('URL to your Terms and Conditions page', 'kaliforms'),
                    'dependent' => [
                        'field' => 'termsType',
                        'value' => 'url',
                    ],
                ],
                'content'   => [
                    'type'      => 'textarea',
                    'label'     => esc_html__('Terms and Conditions text body', 'kaliforms'),
                    'dependent' => [
                        'field' => 'termsType',
                        'value' => 'text',
                    ],
                ],
            ]),
            new BuilderFormFields\Color_Picker([
                'default'  => [
                    'label' => esc_html__('Default value', 'kaliforms'),
                    'type'  => 'color',
                    'value' => '#fff',
                    'group' => 'advanced',
                ],
                'required' => [
                    'label' => esc_html__('Required', 'kaliforms'),
                    'type'  => 'toggle',
                    'value' => false,
                ],
                'readonly' => [
                    'label' => esc_html__('Readonly', 'kaliforms'),
                    'type'  => 'toggle',
                    'value' => false,
                    'group' => 'advanced',
                ],
            ]),
            new BuilderFormFields\Rating([
                'size'    => [
                    'label'   => esc_html__('Size', 'kaliforms'),
                    'type'    => 'select',
                    'value'   => 'normal',
                    'choices' => [
                        ['value' => 'mini', 'label' => esc_html__('Mini', 'kaliforms')],
                        ['value' => 'tiny', 'label' => esc_html__('Tiny', 'kaliforms')],
                        ['value' => 'small', 'label' => esc_html__('Small', 'kaliforms')],
                        ['value' => 'normal', 'label' => esc_html__('Normal', 'kaliforms')],
                        ['value' => 'large', 'label' => esc_html__('Large', 'kaliforms')],
                        ['value' => 'huge', 'label' => esc_html__('Huge', 'kaliforms')],
                        ['value' => 'massive', 'label' => esc_html__('Massive', 'kaliforms')],
                    ],
                    'group'   => 'general',
                ],
                'color'   => [
                    'label'   => esc_html__('color', 'kaliforms'),
                    'type'    => 'select',
                    'value'   => 'default',
                    'choices' => [
                        ['value' => 'default', 'label' => esc_html__('Default', 'kaliforms')],
                        ['value' => 'red', 'label' => esc_html__('Red', 'kaliforms')],
                        ['value' => 'orange', 'label' => esc_html__('Orange', 'kaliforms')],
                        ['value' => 'yellow', 'label' => esc_html__('Yellow', 'kaliforms')],
                        ['value' => 'olive', 'label' => esc_html__('Olive', 'kaliforms')],
                        ['value' => 'green', 'label' => esc_html__('Green', 'kaliforms')],
                        ['value' => 'teal', 'label' => esc_html__('Teal', 'kaliforms')],
                        ['value' => 'blue', 'label' => esc_html__('Blue', 'kaliforms')],
                        ['value' => 'violet', 'label' => esc_html__('Violet', 'kaliforms')],
                        ['value' => 'purple', 'label' => esc_html__('Purple', 'kaliforms')],
                        ['value' => 'pink', 'label' => esc_html__('Pink', 'kaliforms')],
                        ['value' => 'brown', 'label' => esc_html__('Brown', 'kaliforms')],
                        ['value' => 'grey', 'label' => esc_html__('Grey', 'kaliforms')],
                        ['value' => 'black', 'label' => esc_html__('Black', 'kaliforms')],
                    ],
                    'group'   => 'general',
                ],
                'icon'    => [
                    'label'   => esc_html__('Icon', 'kaliforms'),
                    'type'    => 'select',
                    'value'   => 'default',
                    'choices' => [
                        ['value' => 'default', 'label' => esc_html__('Default (star)', 'kaliforms')],
                        ['value' => 'circle', 'label' => esc_html__('Circle', 'kaliforms')],
                        ['value' => 'heart', 'label' => esc_html__('Heart', 'kaliforms')],
                        ['value' => 'star', 'label' => esc_html__('Star', 'kaliforms')],
                        ['value' => 'coffee', 'label' => esc_html__('Coffee', 'kaliforms')],
                        ['value' => 'beer', 'label' => esc_html__('Beer', 'kaliforms')],
                        ['value' => 'smile', 'label' => esc_html__('Smile', 'kaliforms')],
                        ['value' => 'angry', 'label' => esc_html__('Angry', 'kaliforms')],
                        ['value' => 'frown', 'label' => esc_html__('Frown', 'kaliforms')],
                        ['value' => 'grin-alternate', 'label' => esc_html__('Grin', 'kaliforms')],
                        ['value' => 'grin-hearts', 'label' => esc_html__('Grin with hearts', 'kaliforms')],
                        ['value' => 'hand-middle-finger', 'label' => esc_html__('Middle finger', 'kaliforms')],
                        ['value' => 'thumbs-up', 'label' => esc_html__('Thumbs up', 'kaliforms')],
                        ['value' => 'thumbs-down', 'label' => esc_html__('Thumbs down', 'kaliforms')],
                        ['value' => 'bolt', 'label' => esc_html__('Bolt', 'kaliforms')],
                    ],
                    'group'   => 'general',
                ],
                'default' => [
                    'label' => esc_html__('Default rating', 'kaliforms'),
                    'type'  => 'number',
                    'value' => 0,
                    'group' => 'advanced',
                ],
                'max'     => [
                    'label' => esc_html__('Maximum rating (number of items)', 'kaliforms'),
                    'type'  => 'number',
                    'value' => 5,
                    'group' => 'advanced',
                ],
            ]),
            new BuilderFormFields\Smart_Text_Output([
                'content'         => [
                    'label' => esc_html__('Content', 'kaliforms'),
                    'type'  => 'textarea',
                    'value' => '',
                ],
                'outputIn'        => [
                    'label'   => esc_html__('Result output', 'kaliforms'),
                    'type'    => 'select',
                    'value'   => 'input',
                    'group'   => 'advanced',
                    'choices' => [
                        'input',
                        'textarea',
                        'div',
                    ],
                ],
                'copyToClipboard' => [
                    'label' => esc_html__('Copy to clipboard button', 'kaliforms'),
                    'type'  => 'toggle',
                    'value' => false,
                    'group' => 'advanced',
                ],
            ]),
            new BuilderFormFields\Range([
                'default'   => [
                    'label' => esc_html__('Default value', 'kaliforms'),
                    'type'  => 'number',
                    'value' => '',
                    'group' => 'advanced',
                ],
                'gradation' => [
                    'label' => esc_html__('Show gradation', 'kaliforms'),
                    'type'  => 'toggle',
                    'value' => true,
                ],
                'min'       => [
                    'label' => esc_html__('Minimum value', 'kaliforms'),
                    'type'  => 'number',
                    'value' => 0,
                    'group' => 'advanced',
                ],
                'max'       => [
                    'label' => esc_html__('Maximum value', 'kaliforms'),
                    'type'  => 'number',
                    'value' => '',
                    'group' => 'advanced',
                ],
                'step'      => [
                    'label' => esc_html__('Step', 'kaliforms'),
                    'type'  => 'number',
                    'value' => 1,
                    'group' => 'advanced',
                ],
                'required'  => [
                    'label' => esc_html__('Required', 'kaliforms'),
                    'type'  => 'toggle',
                    'value' => false,
                ],
                'readonly'  => [
                    'label' => esc_html__('Readonly', 'kaliforms'),
                    'type'  => 'toggle',
                    'value' => false,
                    'group' => 'advanced',
                ],
            ]),
            new BuilderFormFields\Password([
                'hashPassword' => [
                    'label' => esc_html__('Hash password? (encode it)', 'kaliforms'),
                    'type'  => 'toggle',
                    'value' => false,
                    'group' => 'advanced',
                ],
                'required'     => [
                    'label' => esc_html__('Required', 'kaliforms'),
                    'type'  => 'toggle',
                    'value' => false,
                ],
                'readonly'     => [
                    'label' => esc_html__('Readonly', 'kaliforms'),
                    'type'  => 'toggle',
                    'value' => false,
                    'group' => 'advanced',
                ],
            ]),
            new BuilderFormFields\Choices([
                'placeholder'     => [
                    'label' => esc_html__('Field placeholder', 'kaliforms'),
                    'type'  => 'textbox',
                    'value' => esc_html__('Select an option', 'kaliforms'),
                ],
                'choices'         => [
                    'label'          => esc_html__('Choices', 'kaliforms'),
                    'type'           => 'addableList',
                    'selectableType' => 'multiple',
                    'value'          => [],
                    'group'          => 'addable',
                ],
                'maxItemCount'    => [
                    'label' => esc_html__('Max selectable items', 'kaliforms'),
                    'type'  => 'number',
                    'value' => 1,
                    'group' => 'advanced',
                ],
                'required'        => [
                    'label' => esc_html__('Required', 'kaliforms'),
                    'type'  => 'toggle',
                    'value' => false,
                ],
                'readonly'        => [
                    'label' => esc_html__('Readonly', 'kaliforms'),
                    'type'  => 'toggle',
                    'value' => false,
                    'group' => 'advanced',
                ],
                'populateFromApi' => [
                    'label' => esc_html__('Populate items from API', 'kaliforms'),
                    'type'  => 'textbox',
                    'value' => '',
                    'group' => 'advanced',
                ],
                'dataFormat'      => [
                    'label' => esc_html__('Data format', 'kaliforms'),
                    'type'  => 'textbox',
                    'value' => 'value,label',
                    'group' => 'advanced',
                ],
            ]),
            new BuilderFormFields\Date_Time_Picker(
                [
                    //@todo change to select with examples
                    'inlineCalendar'             => [
                        'label' => esc_html__('Inline calendar (always shown)', 'kaliforms'),
                        'type'  => 'toggle',
                        'value' => false,
                        'group' => 'advanced',
                    ],
                    'dateFormat'                 => [
                        'label' => esc_html__('Date format', 'kaliforms'),
                        'type'  => 'textbox',
                        'value' => 'd-m-Y',
                        'group' => 'advanced',
                    ],
                    'weekDayStarts'              => [
                        'label'   => esc_html__('Week starts on day', 'kaliforms'),
                        'type'    => 'select',
                        'group'   => 'advanced',
                        'value'   => 1,
                        'choices' => [
                            ['value' => 0, 'label' => esc_html__('Sunday', 'kaliforms')],
                            ['value' => 1, 'label' => esc_html__('Monday', 'kaliforms')],
                            ['value' => 2, 'label' => esc_html__('Tuesday', 'kaliforms')],
                            ['value' => 3, 'label' => esc_html__('Wednesday', 'kaliforms')],
                            ['value' => 4, 'label' => esc_html__('Thursday', 'kaliforms')],
                            ['value' => 5, 'label' => esc_html__('Friday', 'kaliforms')],
                            ['value' => 6, 'label' => esc_html__('Saturday', 'kaliforms')],
                        ],
                    ],
                    'minDateToday'               => [
                        'label' => esc_html__('Start date is today?', 'kaliforms'),
                        'type'  => 'toggle',
                        'value' => false,
                        'group' => 'date',
                    ],
                    'minDate'                    => [
                        'label'     => esc_html__('Start date', 'kaliforms'),
                        'type'      => 'calendar',
                        'value'     => '',
                        'group'     => 'date',
                        'dependent' => [
                            'field' => 'minDateToday',
                            'value' => false,
                        ],
                    ],
                    'minDateDependency'          => [
                        'label'         => esc_html__('Start date depending on other date picker?', 'kaliforms'),
                        'type'          => 'fieldDependancyByType',
                        'value'         => '',
                        'choice_source' => 'dateTimePicker',
                        'group'         => 'date',
                        'dependent'     => [
                            'field' => 'minDateToday',
                            'value' => false,
                        ],
                    ],
                    'minDateDependencyOffset'    => [
                        'label'     => esc_html__('Offset dependency', 'kaliforms'),
                        'type'      => 'number',
                        'value'     => 0,
                        'group'     => 'date',
                        'dependent' => [
                            'field' => 'minDateDependency',
                            'value' => '',
                            'logic' => 'not-empty',
                        ],
                    ],
                    'maxDate'                    => [
                        'label' => esc_html__('End date', 'kaliforms'),
                        'type'  => 'calendar',
                        'value' => '',
                        'group' => 'date',
                    ],
                    'showTime'                   => [
                        'label' => esc_html__('Show time?', 'kaliforms'),
                        'type'  => 'toggle',
                        'value' => false,
                        'group' => 'advanced',
                    ],
                    'minTime'                    => [
                        'label'     => esc_html__('Start time', 'kaliforms'),
                        'type'      => 'timePicker',
                        'dependent' => [
                            'field' => 'showTime',
                            'value' => true,
                        ],
                        'value'     => '',
                        'group'     => 'advanced',
                    ],
                    'maxTime'                    => [
                        'label'     => esc_html__('End time', 'kaliforms'),
                        'type'      => 'timePicker',
                        'dependent' => [
                            'field' => 'showTime',
                            'value' => true,
                        ],
                        'value'     => '',
                        'group'     => 'advanced',
                    ],
                    'disabledDates'              => [
                        'label' => esc_html__('Disable following dates', 'kaliforms'),
                        'type'  => 'textarea',
                        'value' => '',
                        'group' => 'date',
                    ],
                    'disabledPreviousSavedDates' => [
                        'label' => esc_html__('Disable previous saved dates', 'kaliforms'),
                        'type'  => 'toggle',
                        'value' => false,
                        'group' => 'date',
                    ],
                    'coDependancyField'          => [
                        'label' => esc_html__('Field dependancy for disabling (except the date)', 'kaliforms'),
                        'type'  => 'fieldDependancy',
                        'value' => '',
                        'group' => 'date',
                    ],
                    'required'                   => [
                        'label' => esc_html__('Required', 'kaliforms'),
                        'type'  => 'toggle',
                        'value' => false,
                    ],
                    'readonly'                   => [
                        'label' => esc_html__('Readonly', 'kaliforms'),
                        'type'  => 'toggle',
                        'value' => false,
                        'group' => 'advanced',
                    ],
                ]
            ),
            new BuilderFormFields\PageBreak([
                'progressBar'    => [
                    'label' => esc_html__('Show progress bar', 'kaliforms'),
                    'type'  => 'toggle',
                    'value' => false,
                    'group' => 'advanced',
                ],
                'validateOnNext' => [
                    'label' => esc_html__('Validate on next page', 'kaliforms'),
                    'type'  => 'toggle',
                    'value' => false,
                    'group' => 'advanced',
                ],
                'backLabel'      => [
                    'label' => esc_html__('Back button label', 'kaliforms'),
                    'type'  => 'textbox',
                    'value' => esc_html__('Back', 'kaliforms'),
                    'group' => 'advanced',
                ],
                'nextLabel'      => [
                    'label' => esc_html__('Next button label', 'kaliforms'),
                    'type'  => 'textbox',
                    'value' => esc_html__('Next', 'kaliforms'),
                    'group' => 'advanced',
                ],
            ])
        ];
    }
}
