<?php

namespace KaliForms\Inc\Frontend\FormFields;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class Terms_And_Conditions
 *
 * @package Inc\Frontend\FormFields;
 */
class Terms_And_Conditions extends Form_Field
{
    /**
     * Class constructor
     */
    public function __construct()
    {
        $this->id = 'termsAndConditions';
    }

    /**
     * Render function
     *
     * @return void
     */
    public function render($item, $form_info)
    {
        $item['type']     = 'checkbox';
        $div              = '';
        $offset           = isset($item['offset']) && $item['offset'] > 0 ? 'offset-md-' . absint($item['offset']) : '';
        $div              = '<div class="col-12 col-md-' . absint($item['col']) . ' ' . $offset . '">';
        $item['termsUrl'] = isset($item['termsUrl']) ? $item['termsUrl'] : '';
		$item['content']  = isset($item['content']) ? $item['content'] : '';

        $div .= '<label class="checkbox-label">';
        $attributes = $this->generate_attribute_string($item);
        $div .= '<input ' . $attributes . ' required value="yes" />';
        switch ($item['termsType']) {
            case 'url':
                $div .= '<span style="position:relative;bottom:3px">' . $this->render_required_mark($form_info['required_field_mark']) . ' <a href="' . esc_url($item['termsUrl']) . '" target="_blank">' . esc_html($item['caption']) . '</a></span>';

                break;
            case 'text':
                $div .= '<span style="position:relative;bottom:3px">' . $this->render_required_mark($form_info['required_field_mark']) . ' ' . esc_html($item['caption']) . '</span>';

                $div .= '<span style="max-height:250px;overflow-y:scroll;display:block;">' . do_shortcode(wp_kses_post($item['content'])) . '</span>';

                break;
        }

        $div .= '</label>';

        $div .= !empty($item['description']) ? '<small>' . esc_html($item['description']) . '</small>' : '';
        $div .= '</div>';

        return $div;
    }
}
