<?php

namespace KaliForms\Inc\Backend\PredefinedForms;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class Appointment_Form
 *
 * @package Inc\Backend\PredefinedForms
 */
class Appointment_Form extends Predefined_Form
{
    /**
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->id = 'appointmentForm';
        $this->name = __('Appointment form', 'kaliforms');
        $this->description = __('Use this as a starting point in building an appointment service on your site.', 'kaliforms');
        $this->emails = [
            ["fromName" => "{sitetitle}", "fromEmail" => "{admin_email}", "toEmail" => "{email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "This is your appointment", "emailAttachment" => "", "emailBody" => "<p>Hello {name},</p> <p>Your appointment with {department} on {appointment-date} at {appointment-time} has been scheduled. We will be expecting you.</p><p>Have a good day</p>", "emailAttachmentFilePaths" => "", "emailAttachmentMediaIds" => ""],
        ];
        $this->thank_you_message = ['key' => 'thankYouMessage', 'value' => '{name}, thank you for your submission!'];
        $this->form_info = [
            'thankYouMessage' => '{name}, thank you for your submission!',
            'showThankYouMessage' => '1',
			'requiredFieldMark' => '*',
			'saveFormSubmissions' => '1',
        ];
        $this->grid = [
            ["w" => 12, "h" => 1, "x" => 0, "y" => 0, "i" => "freeText0", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 7, "h" => 1, "x" => 0, "y" => 3, "i" => "textbox1", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 2, "i" => "textbox2", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 5, "h" => 1, "x" => 7, "y" => 3, "i" => "textbox3", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 4, "h" => 1, "x" => 0, "y" => 5, "i" => "dropdown4", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 5, "h" => 1, "x" => 4, "y" => 5, "i" => "date5", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 3, "h" => 1, "x" => 9, "y" => 5, "i" => "dropdown6", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 7, "i" => "textarea7", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 9, "i" => "submitButton8", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 1, "i" => "divider9", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 4, "i" => "divider10", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 6, "i" => "divider11", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 8, "i" => "divider12", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
        ];
        $this->field_components = [
            ["id" => "freeText", "label" => "Free Text", "internalId" => "freeText0", "properties" => ["id" => "instructions", "content" => "Hello, please use the following form in order to set an appointment with one of our departments."], "constraint" => "none"],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox1", "properties" => ["id" => "full-name", "name" => "name", "caption" => "Enter your name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none"],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox2", "properties" => ["id" => "email", "name" => "email", "caption" => "Email", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => 0],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox3", "properties" => ["id" => "phone-number", "name" => "phone-number", "caption" => "Enter your phone number", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false], "constraint" => 0],
            ["id" => "dropdown", "label" => "Dropdown", "internalId" => "dropdown4", "properties" => ["id" => "department", "name" => "department", "caption" => "Appointment with", "description" => "", "default" => "", "choices" => [["value" => "John Doe", "label" => "Dr John Doe"], ["value" => "Jane Doe", "label" => "Dr Jane Doe"]], "required" => true, "readonly" => false], "constraint" => "none"],
            ["id" => "date", "label" => "Date field", "internalId" => "date5", "properties" => ["id" => "date-of-appointment", "name" => "appointment-date", "caption" => "Date", "description" => "", "default" => "", "required" => true, "readonly" => false], "constraint" => 0],
            ["id" => "dropdown", "label" => "Dropdown", "internalId" => "dropdown6", "properties" => ["id" => "time-of-appointment", "name" => "appointment-time", "caption" => "Time", "description" => "", "default" => "", "choices" => [["value" => "10:00", "label" => "10 AM"], ["value" => "11:00", "label" => "11:00"], ["value" => "12:00", "label" => "12:00"], ["value" => "13:00", "label" => "13:00"], ["value" => "14:00", "label" => "14:00"], ["value" => "15:00", "label" => "15:00"], ["value" => "16:00", "label" => "16:00"], ["value" => "17:00", "label" => "17:00"]], "required" => true, "readonly" => false], "constraint" => "none"],
            ["id" => "textarea", "label" => "Textarea", "internalId" => "textarea7", "properties" => ["id" => "extra", "name" => "extra", "caption" => "If you have any extra mentions, please use the following field", "description" => "", "default" => "", "placeholder" => "", "required" => false, "readonly" => false], "constraint" => 0],
            ["id" => "submitButton", "label" => "Submit Button", "internalId" => "submitButton8", "properties" => ["id" => "set-appointment", "caption" => "Set appointment", "description" => ""], "constraint" => 0],
            ["id" => "divider", "label" => "Divider", "internalId" => "divider9", "properties" => ["id" => "first-divider", "name" => "first-divider", "caption" => "", "type" => "line"], "constraint" => 12],
            ["id" => "divider", "label" => "Divider", "internalId" => "divider10", "properties" => ["id" => "second-divider", "name" => "second-divider", "caption" => "", "type" => "both"], "constraint" => 12],
            ["id" => "divider", "label" => "Divider", "internalId" => "divider11", "properties" => ["id" => "third-divider", "name" => "third divider", "caption" => "", "type" => "both"], "constraint" => 12],
            ["id" => "divider", "label" => "Divider", "internalId" => "divider12", "properties" => ["id" => "divider12", "name" => "divider", "caption" => "", "type" => "space"], "constraint" => 12],
        ];
    }
}
