<?php

namespace KaliForms\Inc\Backend\PredefinedForms;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class Customer_Satisfaction_Form
 *
 * @package Inc\Backend\PredefinedForms
 */
class Customer_Satisfaction_Form extends Predefined_Form
{
    /**
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->id = 'customerSatisfaction';
        $this->name = __('Customer feedback form', 'kaliforms');
        $this->description = __('Collect feedback from customers and improve your services.', 'kaliforms');
        $this->emails = [
            ["fromName" => "{sitetitle}", "fromEmail" => "{admin_email}", "toEmail" => "{email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "Thank your for your feedback!", "emailAttachment" => "", "emailBody" => "<p>Thank you for taking the time to submit our feedback form. We will strive to develop and improve our portfolio and services so that we can provide the best experience for you and our other users.</p>", "emailAttachmentFilePaths" => "", "emailAttachmentMediaIds" => ""],
            ["fromName" => "{name}", "fromEmail" => "{email}", "toEmail" => "{admin_email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "A new feedback form submission has been made!", "emailAttachment" => "", "emailBody" => "<p>We have received a new submission from the <strong>{sitetitle}</strong> feedback form=></p><p><strong>Submitting User</strong> => {name}, {email}</p><p><strong>Portfolio size</strong>=> {products-rating}</p><p><strong>Products used by the submitting user</strong>=> {products-number}</p><p><strong>Experience with our products</strong>=> {experience-satisfaction}</p><p><strong>Willing to try another product</strong>=> {other-products}</p><p><strong>Contacted support</strong>=> {contact-support}</p><p><strong>Experience with our support team</strong>=> {support-satisfaction}</p><p><strong>Cause of the experience</strong>=>&nbsp;</p><p>{support-review}</p><p><strong>Other mentions</strong>=></p><p>{message}</p>", "emailAttachmentFilePaths" => "", "emailAttachmentMediaIds" => ""],
        ];
        $this->thank_you_message = ['key' => 'thankYouMessage', 'value' => 'Thank you for your submission!'];
        $this->form_info = [
            'thankYouMessage' => 'Thank you for your submission!',
            'showThankYouMessage' => '1',
			'requiredFieldMark' => '*',
			'saveFormSubmissions' => '1',
        ];

        $this->grid = [
            ["w" => 12, "h" => 1, "x" => 0, "y" => 0, "i" => "freeText0", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 1, "i" => "divider1", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 4, "i" => "radio2", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 6, "i" => "radio3", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 5, "i" => "radio4", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 6, "h" => 1, "x" => 0, "y" => 2, "i" => "textbox5", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 3, "i" => "divider6", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 6, "h" => 1, "x" => 6, "y" => 2, "i" => "textbox7", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 9, "i" => "radio8", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 10, "i" => "radio9", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 7, "i" => "radio10", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 8, "i" => "divider11", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 11, "i" => "textarea12", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 14, "i" => "submitButton13", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 12, "i" => "divider14", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 13, "i" => "textarea15", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
        ];
        $this->field_components = [
            ["id" => "freeText", "label" => "Free Text", "internalId" => "freeText0", "properties" => ["id" => "instructions", "content" => "We value your opinion as a customer, please take 5 minutes to complete the following form and let us know what you think of our products and services."], "constraint" => 0],
            ["id" => "divider", "label" => "Divider", "internalId" => "divider1", "properties" => ["id" => "first-divider", "name" => "first-divider", "caption" => "", "type" => "line"], "constraint" => 12],
            ["id" => "radio", "label" => "Radio", "internalId" => "radio2", "properties" => ["id" => "products-rating", "name" => "products-rating", "caption" => "What do you think about our portfolio size?", "description" => "", "default" => "", "choices" => [["value" => "very small number", "label" => "Very small number of products."], ["value" => "small number", "label" => "Small number of products."], ["value" => "good number", "label" => "Good number of products"], ["value" => "impressive number", "label" => "Impressive number of products"], ["value" => "amazing number", "label" => "Amazing number of products."]], "required" => true, "readonly" => false, "flow" => "vertical"], "constraint" => 0],
            ["id" => "radio", "label" => "Radio", "internalId" => "radio3", "properties" => ["id" => "experience-satisfaction", "name" => "experience-satisfaction", "caption" => "How was your experience with our products?", "description" => "", "default" => "", "choices" => [["value" => "very unsatisfying", "label" => "Very Unsatisfying"], ["value" => "unsatisfying", "label" => "Unsatisfying"], ["value" => "neutral", "label" => "Neutral"], ["value" => "satisfying", "label" => "Satisfying"], ["value" => "very satisfying", "label" => "Very Satisfying"]], "required" => true, "readonly" => false, "flow" => "vertical"], "constraint" => "none"],
            ["id" => "radio", "label" => "Radio", "internalId" => "radio4", "properties" => ["id" => "products-number", "name" => "products-number", "caption" => "How many products from our portfolio are you using?", "description" => "", "default" => "", "choices" => [["value" => "1", "label" => "One"], ["value" => "2", "label" => "A couple"], ["value" => "3", "label" => "More than two"], ["value" => "4", "label" => "A large number"], ["value" => "5", "label" => "All of them"]], "required" => true, "readonly" => false, "flow" => "vertical"], "constraint" => 0],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox5", "properties" => ["id" => "name", "name" => "name", "caption" => "Name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => 0],
            ["id" => "divider", "label" => "Divider", "internalId" => "divider6", "properties" => ["id" => "second-divider", "name" => "second-divider", "caption" => "Products", "type" => "line"], "constraint" => 12],
            ["id" => "textbox", "label" => "Text box", "internalId" => "textbox7", "properties" => ["id" => "email", "name" => "email", "caption" => "Email", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false], "constraint" => "none"],
            ["id" => "radio", "label" => "Radio", "internalId" => "radio8", "properties" => ["id" => "contact-support", "name" => "contact-support", "caption" => "Have you contacted our team for help with your purchased products?", "description" => "", "default" => "", "choices" => [["value" => "no", "label" => "No"], ["value" => "yes", "label" => "Yes"]], "required" => true, "readonly" => false, "flow" => "vertical"], "constraint" => "none"],
            ["id" => "radio", "label" => "Radio", "internalId" => "radio9", "properties" => ["id" => "support-satisfaction", "name" => "support-satisfaction", "caption" => "How was your experience with our staff personel?", "description" => "", "default" => "", "choices" => [["value" => "very unhelpful", "label" => "Very unhelpful"], ["value" => "unhelpful", "label" => "Unhelpful"], ["value" => "neutral", "label" => "Neutral"], ["value" => "helpful", "label" => "Helpful"], ["value" => "very helpful", "label" => "Very helpful"]], "required" => true, "readonly" => false, "flow" => "vertical"], "constraint" => 0],
            ["id" => "radio", "label" => "Radio", "internalId" => "radio10", "properties" => ["id" => "other-products", "name" => "other-products", "caption" => "Are you willing to try another product from our portfolio?", "description" => "", "default" => "", "choices" => [["value" => "no", "label" => "No"], ["value" => "yes", "label" => "Yes"]], "required" => true, "readonly" => false, "flow" => "vertical"], "constraint" => "none"],
            ["id" => "divider", "label" => "Divider", "internalId" => "divider11", "properties" => ["id" => "support-received", "name" => "support-received", "caption" => "Support received", "type" => "line"], "constraint" => 12],
            ["id" => "textarea", "label" => "Textarea", "internalId" => "textarea12", "properties" => ["id" => "support-review", "name" => "support-review", "caption" => "Can you let us know why you think this? (optional)", "description" => "", "default" => "", "placeholder" => "", "required" => false, "readonly" => false], "constraint" => 0],
            ["id" => "submitButton", "label" => "Submit Button", "internalId" => "submitButton13", "properties" => ["id" => "submit", "caption" => "Submit", "description" => ""], "constraint" => "none"],
            ["id" => "divider", "label" => "Divider", "internalId" => "divider14", "properties" => ["id" => "third-divider", "name" => "third-divider", "caption" => "Other mentions", "type" => "line"], "constraint" => 12],
            ["id" => "textarea", "label" => "Textarea", "internalId" => "textarea15", "properties" => ["id" => "message", "name" => "message", "caption" => "If you have any other mentions regarding our products or services please let us know below.", "description" => "", "default" => "", "placeholder" => "", "required" => false, "readonly" => false], "constraint" => 0],
        ];
    }
}
