<?php
namespace KaliForms\Inc\Backend\PredefinedForms;

if (!defined('ABSPATH')) {
    exit;
}
class Gym_Membership_Application extends Predefined_Form
{
    public function __construct()
    {
        parent::__construct();
        $this->id   = 'gymMembershipApplication';
        $this->name = esc_html__('Gym Membership Application', 'kaliforms');

        $this->field_components = array(array("id" => "textbox", "internalId" => "textbox1", "label" => "Text box", "properties" => array("id" => "textbox1", "name" => "fullName", "caption" => "Full Name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false), "constraint" => "none"), array("id" => "email", "internalId" => "email2", "label" => "Email", "properties" => array("id" => "email2", "name" => "email", "caption" => "Email", "description" => "", "default" => "", "placeholder" => "", "required" => false, "readonly" => false), "constraint" => "none"), array("id" => "telephone", "internalId" => "telephone3", "label" => "Phone", "properties" => array("id" => "telephone3", "name" => "telephone", "caption" => "Phone", "description" => "", "default" => "", "placeholder" => "", "required" => false, "format" => "us", "readonly" => false), "constraint" => "none"), array("id" => "textbox", "internalId" => "textbox4", "label" => "Text box", "properties" => array("id" => "textbox14", "name" => "age", "caption" => "Age", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false), "constraint" => "none"), array("id" => "textbox", "internalId" => "textbox5", "label" => "Text box", "properties" => array("id" => "textbox145", "name" => "height", "caption" => "Height(m)", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false), "constraint" => "none"), array("id" => "textbox", "internalId" => "textbox6", "label" => "Text box", "properties" => array("id" => "textbox1456", "name" => "weight", "caption" => "Weight(kg)", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false), "constraint" => "none"), array("id" => "pageBreak", "internalId" => "pagebreak7", "label" => "Page break", "properties" => array("id" => "pageBreak7", "name" => "pageBreak1", "caption" => "", "progressBar" => true, "validateOnNext" => false, "backLabel" => "Back", "nextLabel" => "Next"), "constraint" => 12), array("id" => "dropdown", "internalId" => "dropdown8", "label" => "Dropdown", "properties" => array("id" => "dropdown8", "name" => "workouts", "caption" => "Number of workouts per week?", "description" => "", "default" => "", "choices" => array(array("value" => "1", "label" => "One"), array("value" => "2", "label" => "Two"), array("value" => "3", "label" => "Three"), array("value" => "4", "label" => "Four"), array("value" => "5", "label" => "Five")), "required" => false, "readonly" => false), "constraint" => 0), array("id" => "radio", "internalId" => "radio9", "label" => "Radio", "properties" => array("id" => "radio9", "name" => "dietPlan", "caption" => "Do you have a diet plan?", "description" => "", "default" => "", "flow" => "vertical", "choices" => array(array("value" => "yes", "label" => "Yes"), array("value" => "no", "label" => "No")), "required" => false, "readonly" => false), "constraint" => 0), array("id" => "pageBreak", "internalId" => "pagebreak10", "label" => "Page break", "properties" => array("id" => "pageBreak10", "name" => "pageBreak2", "caption" => "", "progressBar" => true, "validateOnNext" => false, "backLabel" => "Back", "nextLabel" => "Next"), "constraint" => 12), array("id" => "smartTextOutput", "internalId" => "smarttextoutput11", "label" => "Smart Text Output", "properties" => array("id" => "smartTextOutput11", "name" => "smartTextOutput", "caption" => "Review your information", "description" => "", "content" => "Name: {fullName}
Email: {email}
Telephone: {telephone}
Height: {height}
Weight: {weight}
Age: {age}
Number of workouts per week: {workouts}
Do you have a diet plan: {dietPlan}", "outputIn" => "div", "copyToClipboard" => false), "constraint" => 0), array("id" => "submitButton", "internalId" => "submitbutton12", "label" => "Submit Button", "properties" => array("id" => "submitButton12", "clickAction" => "", "caption" => "Submit application", "description" => ""), "constraint" => 0));

        $this->grid = array(array("h" => 1, "i" => "textbox1", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 0), array("h" => 1, "i" => "email2", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 0, "y" => 1), array("h" => 1, "i" => "telephone3", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 6, "y" => 1), array("h" => 1, "i" => "textbox4", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 4, "x" => 8, "y" => 3), array("h" => 1, "i" => "textbox5", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 4, "x" => 0, "y" => 3), array("h" => 1, "i" => "textbox6", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 4, "x" => 4, "y" => 3), array("h" => 1, "i" => "pagebreak7", "maxH" => 1, "minW" => 12, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 2), array("h" => 1, "i" => "dropdown8", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 0, "y" => 4), array("h" => 1, "i" => "radio9", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 6, "y" => 4), array("h" => 1, "i" => "pagebreak10", "maxH" => 1, "minW" => 12, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 5), array("h" => 1, "i" => "smarttextoutput11", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 6), array("h" => 1, "i" => "submitbutton12", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 7));

        $this->emails = array(array("fromName" => "{sitetitle}", "fromEmail" => "{admin_email}", "toEmail" => "{email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "Thank you for your application!", "emailAttachmentFilePaths" => "", "emailAttachment" => "", "emailAttachmentMediaIds" => array(), "emailBody" => "<p>One of our trainers will reach out with further instructions for your first session at our gym.</p><p></p><p>Your application details are:</p><p>Name: {fullName}, {email}</p><p>Age: {age}</p><p>Weight: {weight}</p><p>Height: {height}</p><p>Telephone: {telephone}</p><p>Number of workouts per week: {workouts}</p><p>Diet plan: {dietPlan}</p><p></p>"), array("fromName" => "{sitetitle}", "fromEmail" => "{admin_email}", "toEmail" => "{admin_email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "A new application has bee submitted!", "emailAttachmentFilePaths" => "", "emailAttachment" => "", "emailAttachmentMediaIds" => array(), "emailBody" => "<p>Applicant information:</p><p></p><p>Name: {fullName}, {email}</p><p>Age: {age}</p><p>Weight: {weight}</p><p>Height: {height}</p><p>Telephone: {telephone}</p><p>Number of workouts per week: {workouts}</p><p>Diet plan: {dietPlan}</p><p></p>"));

        $this->form_info = [
            'saveFormSubmissions' => '1',
        ];
    }
}
