<?php
namespace KaliForms\Inc\Backend\PredefinedForms;

if (!defined('ABSPATH')) {
    exit;
}
class Simple_Booking_Form_With_Payment extends Predefined_Form
{
    public function __construct()
    {
        parent::__construct();
        $this->id               = 'simpleBookingFormWithPayment';
        $this->name             = esc_html__('Booking Form', 'kaliforms');
        $this->field_components = array(array("id" => "dateTimePicker", "internalId" => "datetimepicker2", "label" => "Date and Time picker", "properties" => array("id" => "dateTimePicker2", "name" => "booking-date", "caption" => "Date", "description" => "", "default" => "", "dateFormat" => "d-m-Y", "minDateToday" => false, "minDate" => "", "maxDate" => "", "showTime" => false, "minTime" => "", "maxTime" => "", "disabledDates" => "", "disabledPreviousSavedDates" => true, "coDependancyField" => "donation8", "required" => false, "readonly" => false), "constraint" => "none"), array("id" => "divider", "internalId" => "divider3", "label" => "Divider", "properties" => array("id" => "divider3", "name" => "divider", "caption" => "", "type" => "line"), "constraint" => 12), array("id" => "textbox", "internalId" => "textbox4", "label" => "Text box", "properties" => array("id" => "textbox4", "name" => "first-name", "caption" => "First name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false), "constraint" => "none"), array("id" => "textbox", "internalId" => "textbox5", "label" => "Text box", "properties" => array("id" => "textbox45", "name" => "last-name", "caption" => "Last name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false), "constraint" => "none"), array("id" => "email", "internalId" => "email6", "label" => "Email", "properties" => array("id" => "email6", "name" => "email", "caption" => "Email", "description" => "", "default" => "", "placeholder" => "", "required" => false, "readonly" => false), "constraint" => "none"), array("id" => "telephone", "internalId" => "telephone7", "label" => "Phone", "properties" => array("id" => "telephone7", "name" => "phone", "caption" => "Phone", "description" => "", "default" => "", "placeholder" => "", "required" => false, "format" => "free", "readonly" => false), "constraint" => "none"), array("id" => "donation", "internalId" => "donation8", "label" => "Donation", "properties" => array("id" => "donation8", "name" => "room-price", "caption" => "Room", "description" => "", "default" => "59", "donationType" => "fixed", "donationName" => "Room", "choices" => array(array("value" => "59", "label" => "Single (59$)"), array("value" => "89", "label" => "Double (89$)"))), "constraint" => "none"), array("id" => "paypal", "internalId" => "paypal9", "label" => "PayPal", "properties" => array("id" => "paypal9", "name" => "paypal", "merchantEmail" => ""), "constraint" => "none"));

        $this->grid = array(array("h" => 1, "i" => "datetimepicker2", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 1), array("h" => 1, "i" => "divider3", "maxH" => 1, "minW" => 12, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 2), array("h" => 1, "i" => "textbox4", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 0, "y" => 3), array("h" => 1, "i" => "textbox5", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 6, "y" => 3), array("h" => 1, "i" => "email6", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 0, "y" => 4), array("h" => 1, "i" => "telephone7", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 6, "y" => 4), array("h" => 1, "i" => "donation8", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 0), array("h" => 1, "i" => "paypal9", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 5));

        $this->emails = array(array("fromName" => "{sitetitle}", "fromEmail" => "{admin_email}", "toEmail" => "{email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "Hello {first-name} {last-name}", "emailAttachmentFilePaths" => "", "emailAttachment" => "", "emailAttachmentMediaIds" => array(), "emailBody" => "<p>Your booking for {booking-date} on the {room:label} has been saved. Our team will contact you directly on the specified phone number ({telephone}) for further details.</p><p></p><p>Thank you!</p>"), array("fromName" => "{sitetitle}", "fromEmail" => "{admin_email}", "toEmail" => "{admin_email}", "replyTo" => "{email}", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "A new booking has been made", "emailAttachmentFilePaths" => "", "emailAttachment" => "", "emailAttachmentMediaIds" => array(), "emailBody" => "<p>A new booking has been made!</p><p></p><p>Name: {first-name} {last-name}</p><p>Date: {booking-date}</p><p>Email: {email}</p><p>Phone: {telephone}</p><p>Room: {room:label}</p>"));

        $this->form_info = [
            'saveFormSubmissions' => '1',
            'thankYouMessage'     => '<p>Thank you for your booking!</p>',
        ];
    }
}
