<?php

namespace KaliForms\Inc\Frontend\FormFields;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class Product
 *
 * @package Inc\Frontend\FormFields;
 */
class Range extends Form_Field
{
    /**
     * Class constructor
     */
    public function __construct()
    {
        $this->id = 'range';
    }

    /**
     * Render function
     *
     * @return void
     */
    public function render($item, $form_info)
    {

        $item['min']     = empty($item['min']) ? 0 : floatval($item['min']);
        $item['max']     = empty($item['max']) ? 100 : floatval($item['max']);
        $item['default'] = empty($item['default']) ? 0 : floatval($item['default']);
        $item['step']    = empty($item['step']) ? 1 : floatval($item['step']);

        $attributes = $this->generate_attribute_string($item);

        $offset = isset($item['offset']) && $item['offset'] > 0 ? 'offset-md-' . absint($item['offset']) : '';
        $div    = '<div class="col-12 col-md-' . absint($item['col']) . ' ' . $offset . '">';
        $div .= $this->generate_label($item, $form_info);
        $div .= '<input ' . $attributes . '>';
        $div .= '<div class="kaliforms-range"></div>';
        $div .= !empty($item['description']) ? '<small>' . esc_html($item['description']) . '</small>' : '';

        $div .= '</div>';
        return $div;
    }
}
