<?php

namespace KaliForms\Inc\Frontend\FormFields;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class Smart_Text_Output
 *
 * @package Inc\Frontend\FormFields;
 */
class Smart_Text_Output extends Form_Field
{
    /**
     * Class constructor
     */
    public function __construct()
    {
        $this->id = 'smartTextOutput';
    }

    /**
     * Render function
     *
     * @return void
     */
    public function render($item, $form_info)
    {
        $item['readonly'] = true;
        $item['default'] = htmlspecialchars($item['content']);
        $item['content'] = '';
        $item['smartOutput'] = true;
        $item['type'] = $item['outputIn'] === 'div' ? '' : 'text';
        $item['class'] = 'smart-text-output';
        $attributes = $this->generate_attribute_string($item);

        $offset = isset($item['offset']) && $item['offset'] > 0 ? 'offset-md-' . absint($item['offset']) : '';
        $div = '<div class="col-12 col-md-' . absint($item['col']) . ' ' . $offset . '">';
        $div .= $this->generate_label($item, $form_info);
        $copyToClipBoard = $item['copyToClipboard'] ? '<a href="#" class="kaliforms-copy-to-clipboard">' . esc_html__('Copy', 'kaliforms') . '</a>' : '';
        switch ($item['outputIn']) {
            case 'textarea':
                $div .= '<textarea ' . $attributes . '></textarea>';
                $div .= $copyToClipBoard;
                break;
            case 'div':
                $div .= '<div style="min-height:100px; width:100%;" ' . $attributes . '><code></code></div>';
                $div .= $copyToClipBoard;
                break;
            default:
                $div .= '<input ' . $attributes . '>';
                $div .= $copyToClipBoard;
                break;
        }

        $div .= !empty($item['description']) ? '<small>' . esc_html($item['description']) . '</small>' : '';

        $div .= '</div>';
        return $div;
    }
}
