<?php
namespace KaliForms\Inc\Frontend;

if (!defined('ABSPATH')) {
    exit;
}

class Conditional_Logic
{
    /**
     * Plugin slug
     *
     * @var string
     */
    protected $slug = 'kaliforms-pro';
    /**
     * Parent plugin slug
     *
     * @var string
     */
    protected $parent_slug = 'kaliforms';
    /**
     * Parent constructor
     */
    public function __construct()
    {
        /**
         * Meta save fields
         */
        add_filter($this->parent_slug . '_meta_save_fields', [$this, 'add_meta_fields']);
        /**
         * Adds the conditional tag to the shortcode
         */
        add_filter($this->parent_slug . '_shortcode_form_info', [$this, 'add_conditional_to_shortcode']);
        /**
         * Populate the JSVars object
         */
        add_filter($this->parent_slug . '_jsvars_object', [$this, 'add_conditional_logic_to_vars']);
        add_filter($this->parent_slug . '_form_options', [$this, 'add_conditional_logic_to_vars']);
        /**
         * Adds the script to the page
         */
        add_filter($this->parent_slug . '_before_form_end', [$this, 'add_frontend_rules']);
    }
    /**
     * Add the conditional logic result to the main array
     *
     * @param [type] $jsvars
     * @return void
     */
    public function add_conditional_logic_to_vars($jsvars)
    {
        return array_merge($jsvars, $this->get_options($jsvars['formId']));
    }
    /**
     * Get options
     *
     * @param [type] $id
     * @return void
     */
    public function get_options($id)
    {
        $conditionalLogic = get_post_meta($id, $this->parent_slug . '_conditional_logic', true);
        if ($conditionalLogic === null || $conditionalLogic === '') {
            $conditionalLogic = '[]';
        }
        $data                     = [];
        $data['conditionalLogic'] = json_decode($conditionalLogic, false, 512, JSON_HEX_QUOT);
        return $data;
    }
    /**
     * Add new meta fields
     *
     * @param [type] $meta
     * @return void
     */
    public function add_meta_fields($meta)
    {
        $meta->add_fields(
            ['id' => 'conditional_logic', 'sanitize' => 'KaliForms\Inc\Backend\Sanitizers_Helper::sanitize_conditional_logic']
        );

        return $meta;
    }
    /**
     * Add conditional fields to shortcode
     *
     * @param [type] $fields
     * @return void
     */
    public function add_conditional_to_shortcode($fields)
    {
        $conditionalLogic = get_post_meta($fields['form_id'], $this->parent_slug . '_conditional_logic', true);
        if ($conditionalLogic === null) {
            $conditionalLogic = '[]';
        }

        $fields['conditionalLogic'] = json_decode($conditionalLogic);
        return $fields;
    }

    /**
     * Add frontend conditional logic rules
     *
     * @param [type] $args
     * @return void
     */
    public function add_frontend_rules($args)
    {
        if (!empty($args['context']->form_info['conditionalLogic'])) {
            $string = 'var KaliFormConditionalLogic' . $args['context']->form_info['form_id'] . ' = ' . wp_json_encode($args['context']->form_info['conditionalLogic']) . '';
            wp_add_inline_script('kaliforms-pro', $string, 'before');
        }
        return $args;
    }

}
