<?php

namespace KaliForms\Inc\Backend\PredefinedForms;

if (!defined('ABSPATH')) {
	exit;
}

/**
 * Class Job_Application_Form
 *
 * @package Inc\Backend\PredefinedForms
 */
class Job_Application_Form extends Predefined_Form
{
	public $id;
	/**
	 * Class constructor
	 *
	 * @return void
	 */
	public function __construct()
	{
		parent::__construct();
		$this->id = 'jobApplication';
		$this->name = esc_html__('Job application', 'kaliforms');
		$this->description = esc_html__('Collect resumes for the positions available in your company', 'kaliforms');
		$this->emails = [
			["fromName" => "{first-name} {last-name}", "fromEmail" => "{email}", "toEmail" => "{admin_email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "A new job application was submitted", "emailAttachment" => "", "emailBody" => "<p><u>Applicant information &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</u></p><p>{imagepreview=>{applicant-photo}}</p><p>{title} {first-name} {last-name} ({email})</p><p>{date-of-birth}</p><p>{phone}</p><p>{address1}</p><p>{address2}</p><p>Applying for position=> {position}</p><p>Does the applicant have prior experience=> {prior-experience}</p><p>{prior-experience-description}</p><p>Last workplace contact person=> {last-workplace-contact-name} - {last-workplace-contact-phone}</p><p><br></p><p><br></p><p><br></p>", "emailAttachmentFilePaths" => "", "emailAttachmentMediaIds" => ""],
		];
		$this->thank_you_message = ['key' => 'thankYouMessage', 'value' => 'Thank you for your application, we will get back to you as soon as possible.'];
		$this->form_info = [
			'thankYouMessage' => 'Thank you for your application, we will get back to you as soon as possible.',
			'showThankYouMessage' => '1',
			'requiredFieldMark' => '*',
			'saveFormSubmissions' => '1',
		];
		$this->conditional_logic = [
			["field" => "textarea10", "state" => "show", "conditioner" => "radio7", "operator" => "equal", "value" => "yes"],
		];

		$this->grid = [
			["w" => 6, "h" => 1, "x" => 0, "y" => 3, "i" => "textbox0", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 6, "h" => 1, "x" => 6, "y" => 3, "i" => "textbox1", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 4, "i" => "email19", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 6, "h" => 1, "x" => 6, "y" => 5, "i" => "telephone20", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 6, "i" => "textbox4", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 9, "i" => "textbox5", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 3, "h" => 1, "x" => 0, "y" => 1, "i" => "dropdown6", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 10, "i" => "radio7", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 8, "i" => "divider8", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 0, "i" => "divider9", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 11, "i" => "textarea10", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 6, "h" => 1, "x" => 0, "y" => 5, "i" => "date11", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 6, "h" => 1, "x" => 0, "y" => 12, "i" => "textbox12", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 2, "i" => "fileUpload13", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 14, "i" => "fileUpload14", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 15, "i" => "submitButton15", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 6, "h" => 1, "x" => 6, "y" => 12, "i" => "textbox16", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 13, "i" => "divider17", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 7, "i" => "textbox18", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
		];
		$this->field_components = [
			["id" => "textbox", "label" => "Text box", "internalId" => "textbox0", "properties" => ["id" => "first-name", "name" => "first-name", "caption" => "First name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none"],
			["id" => "textbox", "label" => "Text box", "internalId" => "textbox1", "properties" => ["id" => "last-name", "name" => "last-name", "caption" => "Last name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none"],
			["id" => "email", "label" => "Email", "properties" => ["id" => "email19", "name" => "email", "caption" => "Email", "description" => "", "default" => "", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none", "internalId" => "email19"],
			["id" => "telephone", "label" => "Phone", "properties" => ["id" => "phone", "name" => "phone", "caption" => "Phone number", "description" => "", "default" => "", "placeholder" => "", "required" => true, "format" => "free", "readonly" => false], "constraint" => "none", "internalId" => "telephone20"],
			["id" => "textbox", "label" => "Text box", "internalId" => "textbox4", "properties" => ["id" => "address1", "name" => "address1", "caption" => "Address line 1", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false], "constraint" => 0],
			["id" => "textbox", "label" => "Text box", "internalId" => "textbox5", "properties" => ["id" => "position", "name" => "position", "caption" => "Position you are applying for: ", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => 0],
			["id" => "dropdown", "label" => "Dropdown", "internalId" => "dropdown6", "properties" => ["id" => "title", "name" => "dropdown", "caption" => "", "description" => "", "default" => "", "choices" => [["value" => "mr", "label" => "Mr."], ["value" => "mrs", "label" => "Mrs."], ["value" => "ms", "label" => "Ms."]], "required" => true, "readonly" => false], "constraint" => 0],
			["id" => "radio", "label" => "Radio", "internalId" => "radio7", "properties" => ["id" => "prior-experience", "name" => "prior-experience", "caption" => "Do you have prior experience in this position?", "description" => "", "default" => "no", "flow" => "horizontal", "choices" => [["value" => "no", "label" => "No"], ["value" => "yes", "label" => "Yes"]], "required" => true, "readonly" => false], "constraint" => 0],
			["id" => "divider", "label" => "Divider", "internalId" => "divider8", "properties" => ["id" => "job-information", "name" => "job-information", "caption" => "Job information", "type" => "line"], "constraint" => 12],
			["id" => "divider", "label" => "Divider", "internalId" => "divider9", "properties" => ["id" => "applicant-information", "name" => "applicant-information", "caption" => "Applicant information", "type" => "line"], "constraint" => 12],
			["id" => "textarea", "label" => "Textarea", "internalId" => "textarea10", "properties" => ["id" => "prior-experience-description", "name" => "prior-experience-description", "caption" => "Please write the details below", "description" => "", "default" => "", "placeholder" => "", "required" => false, "readonly" => false], "constraint" => 0],
			["id" => "date", "label" => "Date field", "internalId" => "date11", "properties" => ["id" => "date-of-birth", "name" => "date-of-birth", "caption" => "Date of birth", "description" => "", "default" => "", "required" => true, "readonly" => false], "constraint" => 0],
			["id" => "textbox", "label" => "Text box", "internalId" => "textbox12", "properties" => ["id" => "last-workplace-contact-name", "name" => "last-workplace-contact-name", "caption" => "Last workplace contact person", "description" => "for recommendations purposes", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false], "constraint" => 0],
			["id" => "fileUpload", "label" => "File upload", "internalId" => "fileUpload13", "properties" => ["id" => "applicant-photo", "name" => "applicant-photo", "caption" => "Photo", "description" => "", "default" => "", "maxFileSize" => "", "acceptedExtensions" => "", "filePrefix" => "", "instantUpload" => true, "imagePreview" => true, "required" => false, "readonly" => false], "constraint" => "none"],
			["id" => "fileUpload", "label" => "File upload", "internalId" => "fileUpload14", "properties" => ["id" => "cv", "name" => "cv", "caption" => "C.V upload", "description" => "pdf format only", "default" => "", "maxFileSize" => "", "acceptedExtensions" => "", "filePrefix" => "", "instantUpload" => true, "imagePreview" => false, "required" => true, "readonly" => false], "constraint" => "none"],
			["id" => "submitButton", "label" => "Submit Button", "internalId" => "submitButton15", "properties" => ["id" => "submit", "caption" => "Submit application", "description" => ""], "constraint" => 0],
			["id" => "textbox", "label" => "Text box", "internalId" => "textbox16", "properties" => ["id" => "last-workplace-contact-phone", "name" => "last-workplace-contact-phone", "caption" => "Contact phone", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false], "constraint" => 0],
			["id" => "divider", "label" => "Divider", "internalId" => "divider17", "properties" => ["id" => "cv-divider", "name" => "cv-divider", "caption" => "", "type" => "line"], "constraint" => 12],
			["id" => "textbox", "label" => "Text box", "internalId" => "textbox18", "properties" => ["id" => "address2", "name" => "address2", "caption" => "Address line 2", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false], "constraint" => "none"],
		];
	}
}
