<?php

namespace KaliForms\Inc\Backend\PredefinedForms;

if (!defined('ABSPATH')) {
	exit;
}
class Request_A_Quote extends Predefined_Form
{
	public $id;
	public $formInfo;
	public function __construct()
	{
		parent::__construct();
		$this->id               = 'requestAQuote';
		$this->name = esc_html__('Request a Quote', 'kaliforms');
		$this->field_components = array(array("id" => "textbox", "internalId" => "textbox1", "label" => "Text box", "properties" => array("id" => "textbox1", "name" => "name", "caption" => "Name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false), "constraint" => "none"), array("id" => "textbox", "internalId" => "textbox2", "label" => "Text box", "properties" => array("id" => "textbox12", "name" => "email", "caption" => "Email", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false), "constraint" => "none"), array("id" => "telephone", "internalId" => "telephone3", "label" => "Phone", "properties" => array("id" => "telephone3", "name" => "telephone", "caption" => "Phone", "description" => "", "default" => "", "placeholder" => "", "required" => true, "format" => "free", "readonly" => false), "constraint" => "none"), array("id" => "checkbox", "internalId" => "checkbox4", "label" => "Checkbox", "properties" => array("id" => "checkbox4", "name" => "service", "caption" => "Services", "description" => "", "default" => "", "flow" => "vertical", "choices" => array(array("value" => "mowing", "label" => "Mowing (2.5$)"), array("value" => "mulching", "label" => "Mulching (5$)"), array("value" => "treatment", "label" => "Lawn Treatment (7$)")), "required" => false, "readonly" => false), "constraint" => "none"), array("id" => "textbox", "internalId" => "textbox5", "label" => "Text box", "properties" => array("id" => "textbox125", "name" => "size", "caption" => "Size of lawn area (squared meters)", "description" => "", "default" => "", "type" => "number", "placeholder" => "", "required" => true, "readonly" => false), "constraint" => "none"), array("id" => "checkbox", "internalId" => "checkbox6", "label" => "Checkbox", "properties" => array("id" => "checkbox6", "name" => "urgent", "caption" => "Urgent?", "description" => "", "default" => "", "flow" => "horizontal", "choices" => array(array("value" => "10", "label" => "Yes (10$ fee)")), "required" => false, "readonly" => false), "constraint" => 0), array("id" => "hidden", "internalId" => "hidden7", "label" => "Hidden field", "properties" => array("id" => "hidden7", "name" => "quoteprice", "default" => ""), "constraint" => "none"), array("id" => "smartTextOutput", "internalId" => "smarttextoutput8", "label" => "Smart Text Output", "properties" => array("id" => "smartTextOutput8", "name" => "smartTextOutput", "caption" => "", "description" => "", "content" => "Estimated price for the requested services is: {quoteprice}$.
Please keep in mind that this is a quote and the real price may differ based on real life conditions.", "outputIn" => "div", "copyToClipboard" => false), "constraint" => 0), array("id" => "submitButton", "internalId" => "submitbutton9", "label" => "Submit Button", "properties" => array("id" => "submitButton9", "clickAction" => "", "caption" => "Request quote", "description" => ""), "constraint" => "none"));
		$this->grid   = array(array("h" => 1, "i" => "textbox1", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 0, "y" => 0), array("h" => 1, "i" => "textbox2", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 6, "y" => 0), array("h" => 1, "i" => "telephone3", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 1), array("h" => 1, "i" => "checkbox4", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 0, "y" => 2), array("h" => 1, "i" => "textbox5", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 6, "y" => 2), array("h" => 1, "i" => "checkbox6", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 3), array("h" => 1, "i" => "hidden7", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 4), array("h" => 1, "i" => "smarttextoutput8", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 5), array("h" => 1, "i" => "submitbutton9", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 6));
		$this->emails = array(array("fromName" => "{name}", "fromEmail" => "{email}", "toEmail" => "{admin_email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "New quote request", "emailAttachmentFilePaths" => "", "emailAttachment" => "", "emailAttachmentMediaIds" => array(), "emailBody" => "<p>A new quote request from {sitetitle}</p><p></p><p>Name: {name}</p><p>Email: {email}</p><p>Phone: {telephone}</p><p>Service: {service:label}</p><p>Lawn area: {size} squared meters</p><p>Estimated price: {quoteprice} $</p>"), array("fromName" => "{sitetitle}", "fromEmail" => "{admin_email}", "toEmail" => "{email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "Quote confirmation", "emailAttachmentFilePaths" => "", "emailAttachment" => "", "emailAttachmentMediaIds" => array(), "emailBody" => "<p>You requested a quote on {sitetitle}</p><p></p><p>Name: {name}</p><p>Email: {email}</p><p>Phone: {telephone}</p><p>Service: {service:label}</p><p>Lawn area: {size} squared meters</p><p>Estimated price: {quoteprice} $</p><p></p><p>You will be contacted directly by our team.</p>"));

		$this->form_calculator = "mowing=2.5
mulching=5
treatment=7
quoteprice=(service * size) + urgent";

		$this->formInfo = [
			'requiredFieldMark'           => '*',
			'multipleSelectionsSeparator' => ',',
			'globalerrorMessage'          => 'Hey, it seems that something went wrong. Please check your input and try again!',
			'showThankYouMessage'         => '1',
			'saveFormSubmissions'         => '1',
			'thankYouMessage'             => '<p>Thank you for your reaching out! You will receive a confirmation email and you will be contacted directly to create a schedule.</p>
<p>{service}</p>',
			'selectedFormStyle'           => 'straightBorders',
		];
	}
}
