<?php
namespace KaliForms\Inc\Backend\BuilderFormFields;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class PageBreak
 *
 * @package Inc\Backend\BuilderFormFields
 */
class PageBreak extends Form_Field
{
    /**
     * @var string
     */
    public $id = 'pageBreak';
    /**
     * @var string
     */
    public $type = 'pageBreak';
    /**
     * Constraint. Should always occupy 12 rows ( CANT BE SMALLER )
     *
     * @var string
     */
    public $constraint = 12;
    /**
     * Product constructor.
     *
     * @param $args
     */
    public function __construct($args)
    {
        parent::__construct($args);
        $this->remove_props(['default', 'description']);
        $this->icon  = 'icon-page-break';
        $this->label = esc_html__('Page break', 'kaliforms');
    }
}
