<?php

namespace KaliForms\Inc\Frontend\FormFields;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class PageBreak
 *
 * @package Inc\Frontend\FormFields;
 */
class PageBreak extends Form_Field
{
    /**
     * Class constructor
     */
    public function __construct()
    {
        $this->id = 'pageBreak';
    }

    /**
     * Render function
     *
     * @return void
     */
    public function render($item, $form_info)
    {
        $validateOnNext  = isset($item['validateOnNext']) && $item['validateOnNext'] ? 'validateOnNext' : '';
        $showProgressBar = isset($item['progressBar']) && $item['progressBar'] ? 'progressBar' : '';

        $backLabel  = isset($item['backLabel']) ? esc_html($item['backLabel']) : esc_html__('Back', 'kaliforms');
        $nextLabel  = isset($item['nextLabel']) ? esc_html($item['nextLabel']) : esc_html__('Next', 'kaliforms');
        $attributes = $this->generate_attribute_string($item);
        $title      = !empty($item['caption']) ? 'data-page-title="' . esc_attr($item['caption']) . '"' : '';
        $div        = '<div class="col-12">';
        $div .= '<div class="row kaliforms-pagebreak" id="' . esc_attr($item['id']) . '" ' . $showProgressBar . ' ' . $title . '>';
        $div .= '<div class="col"> <button class="button kaliforms-pagebreak__button" data-direction="prev" >' . $backLabel . '</button> </div>';
        $div .= '<div class="col text-right"> <button class="button kaliforms-pagebreak__button" ' . $validateOnNext . ' data-direction="next">' . $nextLabel . '</button> </div>';
        $div .= '</div>';
        $div .= '</div>';
        return $div;
    }
}
