<?php

namespace KaliForms\Inc\Backend\PredefinedForms;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class GDPR_Friendly_Contact_Form
 *
 * @package Inc\Backend\PredefinedForms
 */
class GDPR_Friendly_Contact_Form extends Predefined_Form
{
    /**
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->id = 'contact';
        $this->name = esc_html__('GDPR-Friendly contact form', 'kaliforms');
        $this->description = esc_html__('A simple gdpr-friendly form meant to help you comunicate with your site users.', 'kaliforms');
        $this->emails = [
            ["fromName" => "{sitetitle}", "fromEmail" => "{admin_email}", "toEmail" => "{email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "Contact form confirmation", "emailAttachment" => "", "emailBody" => "<p>Hello {first-name},</p> <p>This is your confirmation email for the form submitted on <a href='{homeurl}'>{sitetitle}</a>.</p><p>Have a good day</p>", "emailAttachmentFilePaths" => "", "emailAttachmentMediaIds" => ""],
        ];
        $this->thank_you_message = ['key' => 'thankYouMessage', 'value' => '{first-name}, thank you for your submission!'];
        $this->form_info = [
            'thankYouMessage' => '{first-name}, thank you for your submission!',
            'showThankYouMessage' => '1',
			'requiredFieldMark' => '*',
			'saveFormSubmissions' => '1',
        ];

        $this->grid = [
            ["w" => 6, "h" => 1, "x" => 0, "y" => 0, "i" => "textbox2", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 6, "h" => 1, "x" => 6, "y" => 0, "i" => "textbox3", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 2, "i" => "textbox4", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 4, "i" => "textarea5", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 6, "i" => "submitbutton6", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
            ["w" => 12, "h" => 1, "x" => 0, "y" => 5, "i" => "checkbox11", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
        ];
        $this->field_components = [
            ["id" => "textbox", "internalId" => "textbox2", "label" => "Text box", "properties" => ["id" => "first-name", "name" => "first-name", "caption" => "First Name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none"],
            ["id" => "textbox", "internalId" => "textbox3", "label" => "Text box", "properties" => ["id" => "last-name", "name" => "last-name", "caption" => "Last Name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none"],
            ["id" => "textbox", "internalId" => "textbox4", "label" => "Text box", "properties" => ["id" => "email", "name" => "email", "caption" => "Email", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => 0],
            ["id" => "textarea", "internalId" => "textarea5", "label" => "Textarea", "properties" => ["id" => "message", "name" => "message", "caption" => "Message", "description" => "", "default" => "", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => "none"],
            ["id" => "submitButton", "internalId" => "submitbutton6", "label" => "Submit Button", "properties" => ["id" => "submit", "caption" => "Send message", "description" => ""], "constraint" => 0],
            ["id" => "checkbox", "internalId" => "checkbox11", "label" => "Checkbox", "properties" => ["id" => "gdpr", "name" => "checkbox", "caption" => "", "description" => "", "default" => "", "flow" => "vertical", "choices" => [["value" => "gdpr", "label" => "I consent to having this website store my personal information so they can respond to my inquiry."]], "required" => true, "readonly" => false], "constraint" => 0],
        ];
    }
}
