<?php
namespace KaliForms\Inc\Backend\PredefinedForms;

if (!defined('ABSPATH')) {
    exit;
}
class Reservation_Form extends Predefined_Form
{
    public function __construct()
    {
        parent::__construct();
        $this->id = 'reservationForm';
		$this->name = esc_html__('Reservation Form', 'kaliforms');
        $this->field_components = array(array("id" => "dateTimePicker", "internalId" => "datetimepicker1", "label" => "Date and Time picker", "properties" => array("id" => "checkIn", "name" => "checkIn", "caption" => "Check in date", "description" => "", "default" => "", "dateFormat" => "d-m-Y", "minDateToday" => false, "minDate" => "", "maxDate" => "", "showTime" => false, "minTime" => "", "maxTime" => "", "required" => false, "readonly" => false, "disabledDates" => "", "disabledPreviousSavedDates" => false, "coDependancyField" => ""), "constraint" => 0), array("id" => "dateTimePicker", "internalId" => "datetimepicker2", "label" => "Date and Time picker", "properties" => array("id" => "checkOut", "name" => "checkout", "caption" => "Check out date", "description" => "", "default" => "", "dateFormat" => "d-m-Y", "minDateToday" => false, "minDate" => "", "maxDate" => "", "showTime" => false, "minTime" => "", "maxTime" => "", "required" => false, "readonly" => false), "constraint" => 0), array("id" => "textbox", "internalId" => "textbox3", "label" => "Text box", "properties" => array("id" => "fullName", "name" => "fullName", "caption" => "Full Name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false), "constraint" => 0), array("id" => "email", "internalId" => "email4", "label" => "Email", "properties" => array("id" => "email4", "name" => "email", "caption" => "Email", "description" => "", "default" => "", "placeholder" => "", "required" => false, "readonly" => false), "constraint" => 0), array("id" => "dropdown", "internalId" => "dropdown5", "label" => "Dropdown", "properties" => array("id" => "dropdown5", "name" => "roomNumber", "caption" => "How many rooms?", "description" => "", "default" => "", "choices" => array(array("value" => "1", "label" => "One room"), array("value" => "2", "label" => "Two rooms"), array("value" => "3", "label" => "Three rooms"), array("value" => "4", "label" => "Four rooms"), array("value" => "5", "label" => "Five rooms")), "required" => false, "readonly" => false), "constraint" => 0), array("id" => "dropdown", "internalId" => "dropdown6", "label" => "Dropdown", "properties" => array("id" => "dropdown6", "name" => "children", "caption" => "Children in your party?", "description" => "", "default" => "", "choices" => array(array("value" => "0", "label" => "No children"), array("value" => "1", "label" => "One child"), array("value" => "2", "label" => "Two children"), array("value" => "3", "label" => "Three children"), array("value" => "4", "label" => "Four children")), "required" => false, "readonly" => false), "constraint" => "none"), array("id" => "dropdown", "internalId" => "dropdown7", "label" => "Dropdown", "properties" => array("id" => "dropdown7", "name" => "adults", "caption" => "Number of adults", "description" => "", "default" => "", "choices" => array(array("value" => "1", "label" => "One adult"), array("value" => "2", "label" => "Two adults"), array("value" => "3", "label" => "Three adults"), array("value" => "4", "label" => "Four adults")), "required" => false, "readonly" => false), "constraint" => "none"), array("id" => "textarea", "internalId" => "textarea8", "label" => "Textarea", "properties" => array("id" => "extraInstructions", "name" => "extraInstructions", "caption" => "Any extra instructions?", "description" => "", "default" => "", "placeholder" => "", "rows" => "5", "changeToEditor" => false, "required" => false, "readonly" => false), "constraint" => "none"), array("id" => "submitButton", "internalId" => "submitbutton9", "label" => "Submit Button", "properties" => array("id" => "bookNow", "clickAction" => "", "caption" => "Book now", "description" => ""), "constraint" => 0));

        $this->grid = array(array("h" => 1, "i" => "datetimepicker1", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 0, "y" => 0), array("h" => 1, "i" => "datetimepicker2", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 6, "y" => 0), array("h" => 1, "i" => "textbox3", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 1), array("h" => 1, "i" => "email4", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 2), array("h" => 1, "i" => "dropdown5", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 4, "x" => 0, "y" => 3), array("h" => 1, "i" => "dropdown7", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 4, "x" => 4, "y" => 3), array("h" => 1, "i" => "dropdown6", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 4, "x" => 8, "y" => 3), array("h" => 1, "i" => "textarea8", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 4), array("h" => 1, "i" => "submitbutton9", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 5));

		$this->emails = array(array("fromName" => "{sitetitle}", "fromEmail" => "{admin_email}", "toEmail" => "{email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "Your reservation information!", "emailAttachmentFilePaths" => "", "emailAttachment" => "", "emailAttachmentMediaIds" => array(), "emailBody" => "<p>Check in date: {checkIn}</p><p>Check out date: {checkOut}</p><p>Name: {fullName}</p><p>Email: {email}</p><p>Number of rooms: {roomNumber}</p><p>Number of adults: {adults}</p><p>Number of children: {children}</p><p>Extra instructions:</p><p>{extraInstructions}</p><p></p><p></p>"), array("fromName" => "{sitetitle}", "fromEmail" => "{admin_email}", "toEmail" => "{admin_email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "A new booking has been made!", "emailAttachmentFilePaths" => "", "emailAttachment" => "", "emailAttachmentMediaIds" => array(), "emailBody" => "<p>Check in date: {checkIn}</p><p>Check out date: {checkOut}</p><p>Name: {fullName}</p><p>Email: {email}</p><p>Number of rooms: {roomNumber}</p><p>Number of adults: {adults}</p><p>Number of children: {children}</p><p>Extra instructions:</p><p>{extraInstructions}</p><p></p><p></p>"));

		$this->form_info = [
			'saveFormSubmissions' => '1',
		];
    }
}
