<?php

namespace KaliForms\Inc\Backend\PredefinedForms;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class Running_Calculators
 *
 * @package Inc\Backend\PredefinedForms
 */
class Running_Calculators extends Predefined_Form
{
    /**
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->id          = 'runningCalculators';
        $this->name        = esc_html__('Running formula calculator', 'kaliforms');
        $this->description = esc_html__('A form that your users can use to calculate their running pace, distance or time .', 'kaliforms');
        $this->emails      = [];
        $this->form_info   = [
            'hideFormName' => '1',
        ];
        $this->conditional_logic = [
            array(
                "field"       => "freetext2",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "pace",
                "name"        => "pace",
            ),
            array(
                "field"       => "textbox5",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "pace",
                "name"        => "distance-pace",
            ),
            array(
                "field"       => "textbox1",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "pace",
                "name"        => "hours",
            ),
            array(
                "field"       => "textbox3",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "pace",
                "name"        => "Condition #0",
            ),
            array(
                "field"       => "textbox4",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "pace",
                "name"        => "Condition #1",
            ),
            array(
                "field"       => "smarttextoutput6",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "pace",
                "name"        => "Condition #2",
            ),
            array(
                "field"       => "freetext9",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "distance",
                "name"        => "Condition #3",
            ),
            array(
                "field"       => "textbox10",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "distance",
                "name"        => "Condition #4",
            ),
            array(
                "field"       => "textbox11",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "distance",
                "name"        => "Condition #5",
            ),
            array(
                "field"       => "textbox12",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "distance",
                "name"        => "Condition #6",
            ),
            array(
                "field"       => "textbox14",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "distance",
                "name"        => "Condition #7",
            ),
            array(
                "field"       => "textbox15",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "distance",
                "name"        => "Condition #8",
            ),
            array(
                "field"       => "smarttextoutput17",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "distance",
                "name"        => "Condition #9",
            ),
            array(
                "field"       => "freetext19",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "time",
                "name"        => "Condition #10",
            ),
            array(
                "field"       => "textbox20",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "time",
                "name"        => "Condition #11",
            ),
            array(
                "field"       => "textbox22",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "time",
                "name"        => "Condition #12",
            ),
            array(
                "field"       => "textbox23",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "time",
                "name"        => "Condition #13",
            ),
            array(
                "field"       => "smarttextoutput25",
                "conditioner" => "dropdown27",
                "operator"    => "equal",
                "state"       => "show",
                "value"       => "time",
                "name"        => "Condition #14",
            ),
        ];

        $this->form_calculator = "//Running pace
pace=minuteConverter(sum(hours-field hour to seconds, minute-field minutes to seconds, seconds-field seconds to seconds)/distance-field to minutes)

//Running distance
calculated-distance=sum(hours-time hours to seconds, minutes-time minutes to seconds, seconds-time seconds to seconds)/sum(minutes-pace minutes to seconds, seconds-pace seconds to seconds)
calculated-distance-miles=calculated-distance km to miles

//Running time
time-calculator=hourMinuteConverter(multiply(time-calculator-distance, sum(time-calculator-minutes minutes to seconds, time-calculator-seconds seconds to seconds)) to minutes)";

        $this->grid = array(
            array(
                "h"      => 1,
                "i"      => "textbox3",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 3,
                "x"      => 6,
                "y"      => 2,
            ),
            array(
                "h"      => 1,
                "i"      => "textbox4",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 3,
                "x"      => 9,
                "y"      => 2,
            ),
            array(
                "h"      => 1,
                "i"      => "textbox10",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 4,
                "x"      => 0,
                "y"      => 6,
            ),
            array(
                "h"      => 1,
                "i"      => "textbox11",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 4,
                "x"      => 4,
                "y"      => 6,
            ),
            array(
                "h"      => 1,
                "i"      => "textbox14",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 6,
                "x"      => 0,
                "y"      => 7,
            ),
            array(
                "h"      => 1,
                "i"      => "textbox15",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 6,
                "x"      => 6,
                "y"      => 7,
            ),
            array(
                "h"      => 1,
                "i"      => "textbox12",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 4,
                "x"      => 8,
                "y"      => 6,
            ),
            array(
                "h"      => 1,
                "i"      => "textbox1",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 3,
                "x"      => 3,
                "y"      => 2,
            ),
            array(
                "h"      => 1,
                "i"      => "freetext9",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 12,
                "x"      => 0,
                "y"      => 5,
            ),
            array(
                "h"      => 1,
                "i"      => "freetext2",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 12,
                "x"      => 0,
                "y"      => 1,
            ),
            array(
                "h"      => 1,
                "i"      => "textbox20",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 4,
                "x"      => 0,
                "y"      => 12,
            ),
            array(
                "h"      => 1,
                "i"      => "textbox22",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 4,
                "x"      => 4,
                "y"      => 12,
            ),
            array(
                "h"      => 1,
                "i"      => "textbox23",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 4,
                "x"      => 8,
                "y"      => 12,
            ),
            array(
                "h"      => 1,
                "i"      => "textbox5",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 3,
                "x"      => 0,
                "y"      => 2,
            ),
            array(
                "h"      => 1,
                "i"      => "smarttextoutput6",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 12,
                "x"      => 0,
                "y"      => 4,
            ),
            array(
                "h"      => 1,
                "i"      => "hidden7",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 12,
                "x"      => 0,
                "y"      => 3,
            ),
            array(
                "h"      => 1,
                "i"      => "hidden16",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 12,
                "x"      => 0,
                "y"      => 8,
            ),
            array(
                "h"      => 1,
                "i"      => "smarttextoutput25",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 12,
                "x"      => 0,
                "y"      => 14,
            ),
            array(
                "h"      => 1,
                "i"      => "smarttextoutput17",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 12,
                "x"      => 0,
                "y"      => 10,
            ),
            array(
                "h"      => 1,
                "i"      => "freetext19",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 12,
                "x"      => 0,
                "y"      => 11,
            ),
            array(
                "h"      => 1,
                "i"      => "hidden24",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 12,
                "x"      => 0,
                "y"      => 13,
            ),
            array(
                "h"      => 1,
                "i"      => "hidden26",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 12,
                "x"      => 0,
                "y"      => 9,
            ),
            array(
                "h"      => 1,
                "i"      => "dropdown27",
                "maxH"   => 1,
                "minW"   => 3,
                "moved"  => false,
                "static" => false,
                "w"      => 12,
                "x"      => 0,
                "y"      => 0,
            ),
        );

        $this->field_components = array(
            array(
                "id"         => "textbox",
                "internalId" => "textbox1",
                "label"      => "Text box",
                "properties" => array(
                    "id"          => "textbox1",
                    "name"        => "hours-field",
                    "caption"     => "Hours",
                    "description" => "",
                    "default"     => "",
                    "type"        => "number",
                    "placeholder" => "",
                    "required"    => false,
                    "readonly"    => false,
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "freeText",
                "internalId" => "freetext2",
                "label"      => "Free Text",
                "properties" => array(
                    "id"               => "freeText2",
                    "name"             => "freeText",
                    "content"          => "<h4>Pace calculator (Time / Distance)</h4><p>Running Pace is calculated by dividing the distance you completed with the time it took.</p>",
                    "triggerShortcode" => false,
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "textbox",
                "internalId" => "textbox3",
                "label"      => "Text box",
                "properties" => array(
                    "id"          => "textbox3",
                    "name"        => "minute-field",
                    "caption"     => "Minutes",
                    "description" => "",
                    "default"     => "",
                    "type"        => "number",
                    "placeholder" => "",
                    "required"    => false,
                    "readonly"    => false,
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "textbox",
                "internalId" => "textbox4",
                "label"      => "Text box",
                "properties" => array(
                    "id"          => "textbox4",
                    "name"        => "seconds-field",
                    "caption"     => "Seconds",
                    "description" => "",
                    "default"     => "",
                    "type"        => "number",
                    "placeholder" => "",
                    "required"    => false,
                    "readonly"    => false,
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "textbox",
                "internalId" => "textbox5",
                "label"      => "Text box",
                "properties" => array(
                    "id"          => "textbox15",
                    "name"        => "distance-field",
                    "caption"     => "Distance",
                    "description" => "",
                    "default"     => "",
                    "type"        => "number",
                    "placeholder" => "",
                    "required"    => false,
                    "readonly"    => false,
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "smartTextOutput",
                "internalId" => "smarttextoutput6",
                "label"      => "Smart Text Output",
                "properties" => array(
                    "id"              => "smartTextOutput6",
                    "name"            => "smartTextOutput",
                    "caption"         => "",
                    "description"     => "",
                    "content"         => "Your running pace is: {pace}",
                    "outputIn"        => "div",
                    "copyToClipboard" => false,
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "hidden",
                "internalId" => "hidden7",
                "label"      => "Hidden field",
                "properties" => array(
                    "id"      => "hidden7",
                    "name"    => "pace",
                    "default" => "",
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "freeText",
                "internalId" => "freetext9",
                "label"      => "Free Text",
                "properties" => array(
                    "id"               => "freetext9",
                    "name"             => "freetext9",
                    "content"          => "<h4>Distance calculator (Time / Pace)</h4><p>We can calculate the distance you completed by multiplying the time it took you to complete the run and the average pace.<p>",
                    "triggerShortcode" => false,
                    "caption"          => "undefined(duplicate)",
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "textbox",
                "internalId" => "textbox10",
                "label"      => "Text box",
                "properties" => array(
                    "id"          => "textbox10",
                    "name"        => "hours-time",
                    "caption"     => "Hours",
                    "description" => "",
                    "default"     => "",
                    "type"        => "number",
                    "placeholder" => "",
                    "required"    => false,
                    "readonly"    => false,
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "textbox",
                "internalId" => "textbox11",
                "label"      => "Text box",
                "properties" => array(
                    "id"          => "textbox11",
                    "name"        => "minutes-time",
                    "caption"     => "Minutes",
                    "description" => "",
                    "default"     => "",
                    "type"        => "number",
                    "placeholder" => "",
                    "required"    => false,
                    "readonly"    => false,
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "textbox",
                "internalId" => "textbox12",
                "label"      => "Text box",
                "properties" => array(
                    "id"          => "textbox12",
                    "name"        => "seconds-time",
                    "caption"     => "Seconds",
                    "description" => "",
                    "default"     => "",
                    "type"        => "number",
                    "placeholder" => "",
                    "required"    => false,
                    "readonly"    => false,
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "textbox",
                "internalId" => "textbox14",
                "label"      => "Text box",
                "properties" => array(
                    "id"          => "textbox14",
                    "name"        => "minutes-pace",
                    "caption"     => "Minutes",
                    "description" => "",
                    "default"     => "",
                    "type"        => "number",
                    "placeholder" => "",
                    "required"    => false,
                    "readonly"    => false,
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "textbox",
                "internalId" => "textbox15",
                "label"      => "Text box",
                "properties" => array(
                    "id"          => "textbox15",
                    "name"        => "seconds-pace",
                    "caption"     => "Seconds",
                    "description" => "",
                    "default"     => "",
                    "type"        => "number",
                    "placeholder" => "",
                    "required"    => false,
                    "readonly"    => false,
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "hidden",
                "internalId" => "hidden16",
                "label"      => "Hidden field",
                "properties" => array(
                    "id"      => "hidden16",
                    "name"    => "calculated-distance",
                    "default" => "",
                ),
                "constraint" => 0,
            ),
            array(
                "id"         => "smartTextOutput",
                "internalId" => "smarttextoutput17",
                "label"      => "Smart Text Output",
                "properties" => array(
                    "id"              => "smartTextOutput17",
                    "name"            => "smartTextOutput2",
                    "caption"         => "",
                    "description"     => "",
                    "content"         => "You ran the following distance: {calculated-distance} KM / {calculated-distance-miles}",
                    "outputIn"        => "div",
                    "copyToClipboard" => false,
                ),
                "constraint" => 0,
            ),
            array(
                "id"         => "freeText",
                "internalId" => "freetext19",
                "label"      => "Free Text",
                "properties" => array(
                    "id"               => "freeText19",
                    "name"             => "freeText",
                    "content"          => "<h4>Time calculator (Distance * Pace)</h4><p>We can calculate how much time it takes you to complete a run, by multiplying the distance with your average pace</p>",
                    "triggerShortcode" => false,
                ),
                "constraint" => 0,
            ),
            array(
                "id"         => "textbox",
                "internalId" => "textbox20",
                "label"      => "Text box",
                "properties" => array(
                    "id"          => "textbox20",
                    "name"        => "time-calculator-distance",
                    "caption"     => "Distance",
                    "description" => "",
                    "default"     => "",
                    "type"        => "number",
                    "placeholder" => "",
                    "required"    => false,
                    "readonly"    => false,
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "textbox",
                "internalId" => "textbox22",
                "label"      => "Text box",
                "properties" => array(
                    "id"          => "textbox22",
                    "name"        => "time-calculator-minutes",
                    "caption"     => "Minutes",
                    "description" => "",
                    "default"     => "",
                    "type"        => "number",
                    "placeholder" => "",
                    "required"    => false,
                    "readonly"    => false,
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "textbox",
                "internalId" => "textbox23",
                "label"      => "Text box",
                "properties" => array(
                    "id"          => "textbox23",
                    "name"        => "time-calculator-seconds",
                    "caption"     => "Seconds",
                    "description" => "",
                    "default"     => "",
                    "type"        => "number",
                    "placeholder" => "",
                    "required"    => false,
                    "readonly"    => false,
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "hidden",
                "internalId" => "hidden24",
                "label"      => "Hidden field",
                "properties" => array(
                    "id"      => "hidden24",
                    "name"    => "time-calculator",
                    "default" => "",
                ),
                "constraint" => 0,
            ),
            array(
                "id"         => "smartTextOutput",
                "internalId" => "smarttextoutput25",
                "label"      => "Smart Text Output",
                "properties" => array(
                    "id"              => "smarttextoutput25",
                    "name"            => "smarttextoutput25",
                    "caption"         => "",
                    "description"     => "",
                    "content"         => "You will have to run: {time-calculator}",
                    "outputIn"        => "div",
                    "copyToClipboard" => false,
                ),
                "constraint" => 0,
            ),
            array(
                "id"         => "hidden",
                "internalId" => "hidden26",
                "label"      => "Hidden field",
                "properties" => array(
                    "id"      => "hidden26",
                    "name"    => "calculated-distance-miles",
                    "default" => "",
                ),
                "constraint" => "none",
            ),
            array(
                "id"         => "dropdown",
                "internalId" => "dropdown27",
                "label"      => "Dropdown",
                "properties" => array(
                    "id"          => "dropdown27",
                    "name"        => "scenario",
                    "caption"     => "What do you want to calculate",
                    "description" => "",
                    "default"     => "pace",
                    "choices"     => array(
                        array(
                            "value" => "pace",
                            "label" => "Pace",
                        ),
                        array(
                            "value" => "distance",
                            "label" => "Distance",
                        ),
                        array(
                            "value" => "time",
                            "label" => "Time",
                        ),
                    ),
                    "required"    => false,
                    "readonly"    => false,
                ),
                "constraint" => "none",
            ),
        );
    }
}
