<?php
namespace KaliForms\Inc\Backend\PredefinedForms;

if (!defined('ABSPATH')) {
    exit;
}
class Simple_Booking_Form extends Predefined_Form
{
    public function __construct()
    {
		parent::__construct();
		$this->id = 'simpleBookingForm';
		$this->name = esc_html__('Booking Form', 'kaliforms');
        $this->field_components = array(array("id" => "dropdown", "internalId" => "dropdown1", "label" => "Dropdown", "properties" => array("id" => "dropdown1", "name" => "venue", "caption" => "Venue", "description" => "", "default" => "", "choices" => array(array("value" => "gold", "label" => "Golden Venue"), array("value" => "platinum", "label" => "Platinum Venue"), array("value" => "vip", "label" => "VIP Venue")), "required" => false, "readonly" => false), "constraint" => "none"), array("id" => "dateTimePicker", "internalId" => "datetimepicker2", "label" => "Date and Time picker", "properties" => array("id" => "dateTimePicker2", "name" => "booking-date", "caption" => "Date", "description" => "", "default" => "", "dateFormat" => "d-m-Y", "minDateToday" => true, "minDate" => "", "maxDate" => "", "showTime" => false, "minTime" => "", "maxTime" => "", "disabledDates" => "", "disabledPreviousSavedDates" => true, "required" => false, "readonly" => false, "coDependancyField" => "dropdown1"), "constraint" => "none"), array("id" => "submitButton", "internalId" => "submitbutton3", "label" => "Submit Button", "properties" => array("id" => "submitButton3", "clickAction" => "", "caption" => "Book Date", "description" => ""), "constraint" => 0), array("id" => "textbox", "internalId" => "textbox4", "label" => "Text box", "properties" => array("id" => "textbox4", "name" => "first-name", "caption" => "First name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false), "constraint" => 0), array("id" => "textbox", "internalId" => "textbox5", "label" => "Text box", "properties" => array("id" => "textbox45", "name" => "last-name", "caption" => "Last name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => false, "readonly" => false), "constraint" => 0), array("id" => "email", "internalId" => "email6", "label" => "Email", "properties" => array("id" => "email6", "name" => "email", "caption" => "Email", "description" => "", "default" => "", "placeholder" => "", "required" => false, "readonly" => false), "constraint" => 0), array("id" => "telephone", "internalId" => "telephone7", "label" => "Phone", "properties" => array("id" => "telephone7", "name" => "telephone", "caption" => "Phone", "description" => "", "default" => "", "placeholder" => "", "required" => false, "format" => "free", "readonly" => false), "constraint" => 0), array("id" => "divider", "internalId" => "divider8", "label" => "Divider", "properties" => array("id" => "divider8", "name" => "divider", "caption" => "", "type" => "line"), "constraint" => 12), array("id" => "textarea", "internalId" => "textarea9", "label" => "Textarea", "properties" => array("id" => "textarea9", "name" => "description", "caption" => "Tell us a few words about your event", "description" => "", "default" => "", "placeholder" => "", "rows" => "5", "changeToEditor" => true, "required" => false, "readonly" => false), "constraint" => 0));

        $this->grid = array(array("h" => 1, "i" => "dropdown1", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 0), array("h" => 1, "i" => "datetimepicker2", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 1), array("h" => 1, "i" => "submitbutton3", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 6), array("h" => 1, "i" => "textbox4", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 0, "y" => 3), array("h" => 1, "i" => "textbox5", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 6, "y" => 3), array("h" => 1, "i" => "email6", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 0, "y" => 4), array("h" => 1, "i" => "telephone7", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 6, "x" => 6, "y" => 4), array("h" => 1, "i" => "divider8", "maxH" => 1, "minW" => 12, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 2), array("h" => 1, "i" => "textarea9", "maxH" => 1, "minW" => 3, "moved" => false, "static" => false, "w" => 12, "x" => 0, "y" => 5));

        $this->emails = array(array("fromName" => "{sitetitle}", "fromEmail" => "{admin_email}", "toEmail" => "{email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "Hello {first-name} {last-name}", "emailAttachmentFilePaths" => "", "emailAttachment" => "", "emailAttachmentMediaIds" => array(), "emailBody" => "<p>Your booking for {booking-date} on the {venue:label} has been saved. Our team will contact you directly on the specified phone number ({telephone}) for further details.</p><p></p><p>Thank you!</p>"), array("fromName" => "{sitetitle}", "fromEmail" => "{admin_email}", "toEmail" => "{admin_email}", "replyTo" => "{email}", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "A new booking has been made", "emailAttachmentFilePaths" => "", "emailAttachment" => "", "emailAttachmentMediaIds" => array(), "emailBody" => "<p>A new booking has been made!</p><p></p><p>Name: {first-name} {last-name}</p><p>Date: {booking-date}</p><p>Email: {email}</p><p>Phone: {telephone}</p><p>Venue: {venue:label}</p>"));

        $this->form_info = [
            'showThankYouMessage' => '1',
            'saveFormSubmissions'  => '1',
            'thankYouMessage'      => '<p>Thank you for your booking!</p>',
        ];
    }
}
