<?php

namespace KaliForms\Inc\Backend\Views;

if (!defined('WPINC')) {
    die;
}
use KaliForms\Inc\Utils\KaliForms_Store;

/**
 * Class Store_Page
 *
 * @package Inc\Backend\Views
 */
class Store_Page
{
    /**
     * Plugin slug
     *
     * @var string
     */
    protected $slug = 'kaliforms';

    /**
     * HubSpot_Page constructor.
     */
    public function __construct()
    {
        add_action('admin_init', [$this, 'register_settings']);

        $store = KaliForms_Store::get_instance();
        if (!empty($_GET)
            && (isset($_GET['post_type']) && $_GET['post_type'] === 'kaliforms_forms')
            && (isset($_GET['page']) && $_GET['page'] === 'kaliforms-store-auth')) {

            if (isset($_GET['refresh_token']) && isset($_GET['access_token'])) {
                $store->store_auth(['access_token' => $_GET['access_token'], 'refresh_token' => $_GET['refresh_token']]);
            }

            if (isset($_GET['do'])) {
                switch ($_GET['do']) {
                    case 'deauth':
                        $store->deauthenticate();
                        break;
                    default:
                        break;
                }
            }
        }
    }
    /**
     * Register license key
     *
     * @return void
     */
    public function register_settings()
    {
        register_setting('kaliforms_license', 'kaliforms_pro_license_key', [$this, 'sanitize_license']);
    }
    /**
     * Sanitizers
     *
     * @param [type] $new
     * @return void
     */
    public function sanitize_license($new)
    {
        $old = get_option('kaliforms_pro_license_key');
        if ($old && $old != $new) {
            delete_option('kaliforms_pro_license_key');
        }
        return $new;
    }

    /**
     * Shows success page in the iframe
     *
     * @return void
     */
    public function show_success_page()
    {
        echo '<style>
		#wpadminbar { display:none }
		.wrap {
			display: flex;
			width: 100%;
			height: 50vh;
			flex-direction: column;
			justify-content: center;
			align-items: center;
		}
		#kali-forms-logo {
			width:200px;
		}

		</style>';
        echo '<div class="wrap">';
        echo '<img src="' . KALIFORMS_PRO_URL . '/assets/img/logo.png" id="kali-forms-logo"/>';
        echo '<h2 id="success-login">' . esc_html__('Successful Login', 'kaliforms') . '<h2>';
        echo '</div>';
        echo '<script>setTimeout( function() { window.close() }, 1000 );</script>';
    }

    /**
     * Renders app
     */
    public function render_app()
    {
        if (isset($_GET['refresh_token']) && isset($_GET['access_token'])) {
            return $this->show_success_page();
        }

        echo '<div class="wrap">';
        echo '</div>';

        echo '<div id="kaliforms-store-page">';
        echo '</div>';

    }

    /**
     * Invoking the class will render the app
     */
    public function __invoke()
    {
        /**
         * Initiate an action before rendering the app div
         */
        do_action($this->slug . '_before_store_page_rendering');

        /**
         * Echo the container
         */
        $this->render_app();

        /**
         * Initiate an action after rendering the app div
         */
        do_action($this->slug . '_after_store_page_rendering');
    }
}
