<?php
namespace KaliForms\Inc\Backend;

if (!defined('ABSPATH')) {
    exit;
}

class Conditional_Thank_You
{
    /**
     * Plugin slug
     *
     * @var string
     */
    protected $slug = 'kaliforms-pro';
    /**
     * Parent plugin slug
     *
     * @var string
     */
    protected $parent_slug = 'kaliforms';
    /**
     * Conditional_Thank_You constructor.
     */
    public function __construct()
    {
        /**
         * Meta save fields
         */
        add_filter($this->parent_slug . '_meta_save_fields', [$this, 'add_meta_fields']);
        /**
         * Populate the JSVars object
         */
        add_filter($this->parent_slug . '_jsvars_object', [$this, 'add_conditional_logic_to_thank_you']);
        add_filter($this->parent_slug . '_form_options', [$this, 'alter_form_options']);
        add_filter($this->parent_slug . '_before_form_end', [$this, 'add_pagebreak_complete_label']);
    }

    /**
     * Get options
     *
     * @param [type] $id
     * @return void
     */
    public function get_options($id)
    {
        $conditionalTyMessage   = get_post_meta($id, $this->parent_slug . '_conditional_thank_you_message', true);
        $conditionalEnabled     = get_post_meta($id, $this->parent_slug . '_conditional_thank_you', true);
        $pageBreakCompleteLabel = get_post_meta($id, $this->parent_slug . '_pagebreak_complete_label', true);

        if ($conditionalTyMessage === null || $conditionalTyMessage === '') {
            $conditionalTyMessage = '[]';
        }
        if ($conditionalEnabled === null || $conditionalEnabled === '') {
            $conditionalEnabled = '0';
        }
        if ($pageBreakCompleteLabel === null || $pageBreakCompleteLabel === '') {
            $pageBreakCompleteLabel = '';
        }
        $data                               = [];
        $data['conditionalThankYouMessage'] = json_decode($conditionalTyMessage, false, 512, JSON_HEX_QUOT);
        $data['conditionalThankYou']        = $conditionalEnabled;
        $data['pagebreakCompleteLabel']     = $pageBreakCompleteLabel;

        return $data;
    }

    /**
     * Alter form options
     *
     * @param [type] $options
     * @return void
     */
    public function alter_form_options($options)
    {
        return array_merge($options, $this->get_options($options['formId']));
    }

    /**
     * Adds conditional thank you message
     *
     * @param [type] $vars
     * @return void
     */
    public function add_conditional_logic_to_thank_you($jsvars)
    {
        return array_merge($jsvars, $this->get_options($jsvars['formId']));
    }

    /**
     * Add new meta fields
     *
     * @param [type] $meta
     * @todo move pagebreak label out of here
     * @return void
     */
    public function add_meta_fields($meta)
    {
        $meta->add_fields(
            ['id' => 'conditional_thank_you', 'sanitize' => 'KaliForms\Inc\Backend\Sanitizers::sanitize_boolean'],
            ['id' => 'conditional_thank_you_message', 'sanitize' => 'KaliForms\Inc\Backend\Sanitizers_Helper::sanitize_conditional_thank_you'],
            ['id' => 'pagebreak_complete_label', 'sanitize' => 'sanitize_text_field']
        );

        return $meta;
    }
    /**
     * @TODO MOVE THIS OUT OF HERE
     *
     * @param [type] $context
     * @return void
     */
    public function add_pagebreak_complete_label($args)
    {
        if (defined('REST_REQUEST')) {
            return $args;
        }
        $label = get_post_meta($args['context']->form_info['form_id'], $this->parent_slug . '_pagebreak_complete_label', true);
        if (!empty($label)) {
            $js = 'var KaliFormsPageBreakCompleteLabel' . $args['context']->form_info['form_id'] . ' = "' . $label . '"';
            wp_add_inline_script(
                'kaliforms-pro',
                $js,
                'before'
            );
        }
        return $args;
    }
}
