<?php

namespace KaliForms\Inc\Backend\PredefinedForms;

if (!defined('ABSPATH')) {
	exit;
}

/**
 * Class Art_Contest_Form
 *
 * @package Inc\Backend\PredefinedForms
 */
class Art_Contest_Form extends Predefined_Form
{
	public $id;
	/**
	 * Class constructor
	 *
	 * @return void
	 */
	public function __construct()
	{
		parent::__construct();
		$this->id = 'artContest';
		$this->name = __('Art contest', 'kaliforms');
		$this->description = __('This form will help you accept registrations for an art contest event.', 'kaliforms');
		$this->emails = [
			["fromName" => "{sitetitle}", "fromEmail" => "{admin_email}", "toEmail" => "{participant-email}", "replyTo" => "", "ccEmail" => "", "bccEmail" => "", "emailSubject" => "This is your confirmation", "emailAttachment" => "", "emailBody" => "<p>Hello {participant-name},</p> <p>You\'ve been signed up to the art show in the {category} category.</p><p>Have a good day</p>", "emailAttachmentFilePaths" => "", "emailAttachmentMediaIds" => ""],
		];
		$this->thank_you_message = ['key' => 'thankYouMessage', 'value' => '{participant-name}, thank you for your submission!\r\n{imagePreview:{entry-image}}'];

		$this->form_info = [
			'thankYouMessage' => '{participant-name}, thank you for your submission!\r\n{imagePreview:{entry-image}}',
			'showThankYouMessage' => '1',
			'requiredFieldMark' => '*',
			'saveFormSubmissions' => '1',
		];
		$this->grid = [
			["w" => 12, "h" => 1, "x" => 0, "y" => 0, "i" => "textbox0", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 3, "i" => "dropdown1", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 6, "h" => 1, "x" => 0, "y" => 1, "i" => "textbox2", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 6, "h" => 1, "x" => 6, "y" => 1, "i" => "textbox3", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 4, "i" => "fileUpload4", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 6, "i" => "submitButton5", "minW" => 3, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 2, "i" => "divider6", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
			["w" => 12, "h" => 1, "x" => 0, "y" => 5, "i" => "divider7", "minW" => 12, "maxH" => 1, "moved" => false, "static" => false],
		];
		$this->field_components = [
			["id" => "textbox", "label" => "Text box", "internalId" => "textbox0", "properties" => ["id" => "participant-name", "name" => "participant-name", "caption" => "Participant Name", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => 0],
			["id" => "dropdown", "label" => "Dropdown", "internalId" => "dropdown1", "properties" => ["id" => "category", "name" => "category", "caption" => "I am participating in", "description" => "", "default" => "", "choices" => [["value" => "portrait", "label" => "Portrait"], ["value" => "landscape", "label" => "Landscape"], ["value" => "abstract", "label" => "Abstract"]], "required" => true, "readonly" => false], "constraint" => 0],
			["id" => "textbox", "label" => "Text box", "internalId" => "textbox2", "properties" => ["id" => "email", "name" => "participant-email", "caption" => "Email", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => 0],
			["id" => "textbox", "label" => "Text box", "internalId" => "textbox3", "properties" => ["id" => "participant-grade", "name" => "participant-grade", "caption" => "Grade", "description" => "", "default" => "", "type" => "text", "placeholder" => "", "required" => true, "readonly" => false], "constraint" => 0],
			["id" => "fileUpload", "label" => "File upload", "internalId" => "fileUpload4", "properties" => ["id" => "entry-image", "name" => "entry-image", "caption" => "Upload a picture of your painting", "description" => "", "default" => "", "maxFileSize" => "", "acceptedExtensions" => "", "filePrefix" => "", "instantUpload" => true, "imagePreview" => true, "required" => true, "readonly" => false], "constraint" => 0],
			["id" => "submitButton", "label" => "Submit Button", "internalId" => "submitButton5", "properties" => ["id" => "submit", "caption" => "Submit application", "description" => ""], "constraint" => 0],
			["id" => "divider", "label" => "Divider", "internalId" => "divider6", "properties" => ["id" => "first-divider", "name" => "first-divider", "caption" => "", "type" => "both"], "constraint" => 12],
			["id" => "divider", "label" => "Divider", "internalId" => "divider7", "properties" => ["id" => "second-divider", "name" => "second-divider", "caption" => "", "type" => "space"], "constraint" => 12],
		];
	}
}
