<?php

namespace KaliForms\Inc\Frontend\FormFields;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class GDPR
 *
 * @package Inc\Frontend\FormFields;
 */
class GDPR extends Form_Field
{
    /**
     * Class constructor
     */
    public function __construct()
    {
        $this->id = 'gdpr';
    }
    /**
     * Render function
     *
     * @param [type] $item
     * @param [type] $form_info
     * @return void
     */
    public function render($item, $form_info)
    {
        $item['type'] = 'checkbox';
        $div          = '';
        $offset       = isset($item['offset']) && $item['offset'] > 0 ? 'offset-md-' . absint($item['offset']) : '';
        $div          = '<div class="col-12 col-md-' . absint($item['col']) . ' ' . $offset . '">';

        $div .= '<label class="checkbox-label">';
        $attributes = $this->generate_attribute_string($item);
        $div .= '<input ' . $attributes . ' required value="yes" />';
        $div .= '<span style="position:relative;bottom:3px">' . $this->render_required_mark($form_info['required_field_mark']) . ' ' . esc_html($item['caption']) . '</span>';
        $div .= '</label>';

        $div .= !empty($item['description']) ? '<small>' . esc_html($item['description']) . '</small>' : '';
        $div .= '</div>';

        return $div;

    }
}
