<?php

namespace KaliForms\Inc\Frontend\FormFields;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class Rating
 *
 * @package Inc\Frontend\FormFields;
 */
class Rating extends Form_Field
{
    /**
     * Class constructor
     */
    public function __construct()
    {
        $this->id = 'rating';
    }

    /**
     * Render function
     *
     * @return void
     */
    public function render($item, $form_info)
    {
        $item['kali-form-type'] = $item['type'];
        $item['type'] = 'hidden';
        $min          = isset($item['min']) ? absint($item['min']) : 0;
        $max          = isset($item['max']) ? absint($item['max']) : 5;
        $size         = isset($item['size']) ? esc_attr($item['size']) : '';
        $color        = isset($item['color']) ? esc_attr($item['color']) : '';
        $icon         = isset($item['icon']) ? esc_attr($item['icon']) : '';
        $val          = $this->default_value($item, $item['default']);
        if ($icon === 'default') {
            $icon = 'star';
        }

        $attributes = $this->generate_attribute_string($item);
        $offset     = isset($item['offset']) && $item['offset'] > 0 ? 'offset-md-' . absint($item['offset']) : '';
        $div        = '<div class="col-12 col-md-' . absint($item['col']) . ' ' . $offset . '">';
        $div .= $this->generate_label($item, $form_info);
        $div .= '<div class="ui rating ' . $size . ' ' . $color . '" data-icon="' . str_replace('-', ' ', $icon) . '" data-max-rating="' . $max . '" data-min-rating="' . $min . '" data-rating="' . $val . '"></div>';
        $div .= '<input ' . $attributes . ' class="kaliforms-rating">';
        $div .= !empty($item['description']) ? '<small>' . esc_html($item['description']) . '</small>' : '';

        $div .= '</div>';
        return $div;
    }
}
