<?php

namespace KaliForms\Inc\Backend\Views;

if (!defined('WPINC')) {
    die;
}
/**
 * Class WebHooks Page
 *
 * @package Inc\Backend\Views
 */
class WebHooks_Page
{
    /**
     * Plugin slug
     *
     * @var string
     */
    protected $slug = 'kaliforms-webhooks';
    /**
     * Parent plugin slug
     *
     * @var string
     */
    protected $parent_slug = 'kaliforms';
    /**
     * Newsletter page constructor.
     */
    public function __construct()
    {
        add_action('admin_init', [$this, 'register_settings']);
    }

    /**
     * Renders app
     */
    public function render_app()
    {
        echo '<div class="wrap">';
        echo '<h2>Kali Forms WebHooks</h2>';
        settings_errors();
        echo '<form method="post" action="options.php">';
        settings_fields('kaliforms_webhooks');
        wp_nonce_field($this->parent_slug . '_webhooks_nonce', $this->parent_slug . '_webhooks_nonce');
        echo '<table class="form-table">';
        echo '<tbody>';
        echo $this->_fields();
        echo $this->_submit_button();
        echo '</tbody>';
        echo '</table>';
        echo '</form>';
        echo '<p>' . sprintf(esc_html(__('Any questions or problems with the webhooks plugin? %sContact us%s!', 'kaliforms')), '<a href="https://www.kaliforms.com/contact-us" target="_blank">', '</a>') . '</p>';
        echo '</div>';
    }

    /**
     * Mailchimp fields
     *
     * @return string
     */
    public function _fields()
    {
        $option = get_option($this->parent_slug . '_webhooks_option', '');
        $html   = '';
        $html .= '<tr valign="top">';
        $html .= '<th scope="row" valign="top">';
        $html .= esc_html__('Option', 'kaliforms');
        $html .= '</th>';
        $html .= '<td>';
        $html .= '<input type="text" id="' . $this->parent_slug . '_webhooks_option" name="' . $this->parent_slug . 'webhooksoption" class="regular-text" value="' . esc_attr($option) . '"/>';
        $html .= '</td>';
        $html .= '</tr>';

        return $html;
    }

    /**
     * Submit button
     *
     * @return void
     */
    public function _submit_button()
    {
        echo '<tr valign="top">';
        echo '<th scope="row" valign="top">';
        echo esc_html__('Save options', 'kaliforms');
        echo '</th>';
        echo '<td>';
        echo '<input type="submit" class="button-secondary" id="' . $this->parent_slug . '_webhooks_submit" name="' . $this->parent_slug . '_webhooks_submit" value="' . esc_html__('Save', 'kaliforms') . '"/>';
        echo '</td>';
        echo '</tr>';
    }
    /**
     * Register the settings
     *
     * @return void
     */
    public function register_settings()
    {
        register_setting($this->parent_slug . '_webhooks', $this->parent_slug . '_webhooks_option', 'sanitize_text_field');
    }

    /**
     * Invoking the class will render the app
     */
    public function __invoke()
    {
        /**
         * Initiate an action before rendering the app div
         */
        do_action($this->slug . '_before_webhooks_page_rendering');

        /**
         * Echo the container
         */
        $this->render_app();

        /**
         * Initiate an action after rendering the app div
         */
        do_action($this->slug . '_after_webhooks_page_rendering');
    }
}
