<?php
namespace KaliForms\Inc\Traits;

use KaliForms\Inc\Utils\Plugin_Updater;

/**
 * Trait Utilities
 *
 * @package Inc\Traits
 */
trait WebHooks_Utilities
{
    /**
     * Checks if kaliforms is installed, and if not .. display a notice
     */
    public function check_if_kaliforms_is_installed()
    {
        $plugins = get_plugins();
        $status  = array_key_exists('kali-forms/kali-forms.php', $plugins) ? 'installed' : 'not-installed';

        if ($status === 'installed') {
            $status = is_plugin_active('kali-forms/kali-forms.php') ? 'active' : 'installed';
        }

        if ($status === 'active') {
            return;
        }

        $action = '';
        $url    = '';
        $label  = '';
        switch ($status) {
            case 'installed':
                //activate plugin
                $label  = esc_html__('Activate', 'kaliforms');
                $action = 'activate';
                $url    = add_query_arg(
                    [
                        'action'        => 'activate',
                        'plugin'        => rawurlencode('kali-forms/kali-forms.php'),
                        'plugin_status' => 'all',
                        'paged'         => '1',
                        '_wpnonce'      => wp_create_nonce('activate-plugin_kali-forms/kali-forms.php'),
                    ],
                    admin_url('plugins.php')
                );
                break;
            case 'not-installed':
                //install & activate plugin
                $label  = esc_html__('Install & activate', 'kaliforms');
                $action = 'install';
                $url    = 'https://downloads.wordpress.org/plugin/kali-forms.latest-stable.zip';
                break;
        }

        $html = '<div class="notice" style="background: #e9eff3;padding: 40px;border: 10px solid #fff;text-align:center;">';
        $html .= '<h1 style="text-align:center; margin-bottom:15px">';
        $html .= esc_html__('Install & Activate Kali Forms', 'kaliforms');
        $html .= '</h1>';
        $html .= '<h4>' . esc_html__('To use Kali Forms WebHooks, you also need to install & activate Kali Forms Lite & Kali Forms Pro.') . '</h4>';
        $html .= '<a href="' . esc_url($url) . '" data-download-url="' . esc_url($url) . '" data-action="' . esc_attr($action) . '" class="button button-primary button-hero" id="install-kali-forms" style="line-height: 23px;padding: 12px 36px;">' . $label . '</a>';
        $html .= '</div>';

        echo $html;
    }

    /**
     * Update plugin
     *
     * @return void
     */
    public function updater()
    {
        // retrieve our license key from the DB
        $license = get_option('kaliforms_pro_license_key');
        $status  = get_option('kaliforms_pro_license_status');

        // setup the updater
        new Plugin_Updater('https://www.kaliforms.com/', KALIFORMS_WEBHOOKS_PLUGIN_FILE,
            [
                'version' => KALIFORMS_WEBHOOKS_VERSION,
                'license' => $license,
                'item_id' => 28512,
                'author'  => 'Kali Forms',
            ],
            [
                'license_status' => $status,
                'admin_page_url' => admin_url('edit.php?post_type=kaliforms_forms&page=kaliforms-license'),
                'purchase_url'   => 'https://www.kaliforms.com/pricing',
                'plugin_title'   => 'Kali Forms WebHooks',
            ]
        );
    }
}
