<?php
namespace KaliForms\Inc\Traits;

/**
 * Parent_Hooks
 *
 * @package Inc\Traits
 */
trait WebHooks_Parent_Hooks
{
    /**
     * Admin enqueue scripts
     *
     * @return void
     */
    public function admin_enqueue()
    {

    }
    /**
     * Enqueue scripts
     *
     * @return void
     */
    public function enqueue()
    {

    }
    /**
     * Alter the JSVars object
     * Data that we need to pass to our REACT app
     * @param [type] $jsvars
     * @return void
     */
    public function alter_jsvars($jsvars)
    {
        $jsvars['webhooksInstalled'] = true;
        $webhooksData                = get_post_meta($jsvars['formId'], $this->parent_slug . '_webhooks', true);
        if ($webhooksData === null || $webhooksData === '') {
            $webhooksData = [];
        }

        $jsvars['webhooks'] = $webhooksData;

        return $jsvars;
    }
    /**
     * Generic data, that JS will need to use.
     *
     * We create a new object here so that we don't POLLUTE the main Kali Object
     *
     * @return void
     */
    public function add_generic_data_to_js()
    {
        $screen = get_current_screen();
        if ('kaliforms_forms' === get_post_type() && 'post' === $screen->base) {
            $data = [
                'data' => ['hello world'],
            ];

            wp_localize_script(
                'kaliforms-forms',
                'KaliFormsWebhooks',
                $data
            );
        }
    }
    /**
     * Adds meta fields to our sanitization ( coming from the react app )
     *
     * @param [type] $meta
     * @return void
     */
    public function add_meta_fields($meta)
    {
        $meta->add_fields(
            ['id' => 'webhooks', 'sanitize' => 'KaliForms\Inc\Backend\Sanitizers::sanitize_webhooks']
        );
        return $meta;
    }
    /**
     * Register submenus
     *
     * @return void
     */
    public function register_submenus()
    {
        add_submenu_page(
            'edit.php?post_type=kaliforms_forms',
            esc_html__('WebHooks', 'kaliforms'),
            esc_html__('WebHooks', 'kaliforms'),
            'manage_options',
            'kaliforms-webhooks-settings',
            new WebHooks_Page()
        );
    }

    /**
     * Adds options to presets
     *
     * @param [type] $presets
     * @return void
     */
    public function add_options_to_presets($presets)
    {
        return $presets;
    }

    /**
     * Returns an instance of the plugin in the main plugin object
     *
     * @param [type] $plugins
     * @return void
     */
    public function return_an_instance($plugins)
    {
        $plugins[$this->slug] = $this;
        return $plugins;
    }
}
