<?php
namespace KaliForms\Inc;

if (!defined('ABSPATH')) {
    exit;
}

use KaliForms\Inc\Traits\WebHooks_Parent_Hooks as Parent_Hooks;
use KaliForms\Inc\Traits\WebHooks_Utilities as Utilities;

/**
 * Class KaliForms_WebHooks
 *
 * @package Inc
 */
class KaliForms_WebHooks
{
    use Utilities, Parent_Hooks;
    /**
     * Plugin slug
     *
     * @var string
     */
    protected $slug = 'kaliforms-webhooks';
    /**
     * Parent plugin slug
     *
     * @var string
     */
    protected $parent_slug = 'kaliforms';

    /**
     * Class constructor
     */
    public function __construct()
    {
        /**
         * A small check to see if kf is installed else - display a notice
         */
        add_action('admin_head', [$this, 'check_if_kaliforms_is_installed']);
        /**
         * Hook after the main plugin finished construction
         */
        add_action($this->parent_slug . '_after_construction', [$this, 'init']);
        /**
         * After all plugins are loaded, hook your way in the main plugin
         */
        add_action('plugins_loaded', [$this, 'hook_into_main'], 9);
        /**
         * Init the updater
         */
        if (defined('KALIFORMS_PRO_PLUGIN_FILE') && class_exists('KaliForms\Inc\Utils\Plugin_Updater')) {
            add_action('admin_init', [$this, 'updater'], 0);
        }
    }
    /**
     * Returns an instance of the plugin
     *
     * @return KaliForms_WebHooks
     */
    public static function get_instance()
    {
        static $inst;
        if (!$inst) {
            $inst = new KaliForms_WebHooks();
        }

        return $inst;
    }

    /**
     * Init newsletter
     *
     * @return void
     */
    public function init()
    {
        $handler = new WebHooks_Handler();
        add_filter($this->parent_slug . '_jsvars_object', [$this, 'alter_jsvars']);
		add_filter($this->parent_slug . '_form_options', [$this, 'alter_jsvars']);
    }

    /**
     * Hook your way into main
     *
     * @return void
     */
    public function hook_into_main()
    {
        add_action(
            'admin_enqueue_scripts',
            [$this, 'admin_enqueue'],
            98
        );

        if (!defined('KALIFORMS_VERSION')) {
            return;
        }

        if (version_compare(KALIFORMS_VERSION, '2.0.0', '>=')) {
            add_action(
                $this->parent_slug . '_after_load_script_function',
                [$this, 'enqueue'],
                98
            );
        } else {
            add_action(
                'wp_enqueue_scripts',
                [$this, 'enqueue'],
                98
            );
        }

        add_filter($this->parent_slug . '_meta_save_fields', [$this, 'add_meta_fields']);
        add_filter($this->parent_slug . '_predefined_options', [$this, 'add_options_to_presets']);
        add_filter($this->parent_slug . '_hook_external_plugins', [$this, 'return_an_instance']);
    }
}
