<?php

namespace LWVendor\PhpOffice\PhpSpreadsheet\Worksheet\Drawing;

use LWVendor\PhpOffice\PhpSpreadsheet\IComparable;
use LWVendor\PhpOffice\PhpSpreadsheet\Style\Color;
class Shadow implements IComparable
{
    // Shadow alignment
    const SHADOW_BOTTOM = 'b';
    const SHADOW_BOTTOM_LEFT = 'bl';
    const SHADOW_BOTTOM_RIGHT = 'br';
    const SHADOW_CENTER = 'ctr';
    const SHADOW_LEFT = 'l';
    const SHADOW_TOP = 't';
    const SHADOW_TOP_LEFT = 'tl';
    const SHADOW_TOP_RIGHT = 'tr';
    /**
     * Visible.
     *
     * @var bool
     */
    private $visible;
    /**
     * Blur radius.
     *
     * Defaults to 6
     *
     * @var int
     */
    private $blurRadius;
    /**
     * Shadow distance.
     *
     * Defaults to 2
     *
     * @var int
     */
    private $distance;
    /**
     * Shadow direction (in degrees).
     *
     * @var int
     */
    private $direction;
    /**
     * Shadow alignment.
     *
     * @var int
     */
    private $alignment;
    /**
     * Color.
     *
     * @var Color
     */
    private $color;
    /**
     * Alpha.
     *
     * @var int
     */
    private $alpha;
    /**
     * Create a new Shadow.
     */
    public function __construct()
    {
        // Initialise values
        $this->visible = \false;
        $this->blurRadius = 6;
        $this->distance = 2;
        $this->direction = 0;
        $this->alignment = self::SHADOW_BOTTOM_RIGHT;
        $this->color = new Color(Color::COLOR_BLACK);
        $this->alpha = 50;
    }
    /**
     * Get Visible.
     *
     * @return bool
     */
    public function getVisible()
    {
        return $this->visible;
    }
    /**
     * Set Visible.
     *
     * @param bool $pValue
     *
     * @return $this
     */
    public function setVisible($pValue)
    {
        $this->visible = $pValue;
        return $this;
    }
    /**
     * Get Blur radius.
     *
     * @return int
     */
    public function getBlurRadius()
    {
        return $this->blurRadius;
    }
    /**
     * Set Blur radius.
     *
     * @param int $pValue
     *
     * @return $this
     */
    public function setBlurRadius($pValue)
    {
        $this->blurRadius = $pValue;
        return $this;
    }
    /**
     * Get Shadow distance.
     *
     * @return int
     */
    public function getDistance()
    {
        return $this->distance;
    }
    /**
     * Set Shadow distance.
     *
     * @param int $pValue
     *
     * @return $this
     */
    public function setDistance($pValue)
    {
        $this->distance = $pValue;
        return $this;
    }
    /**
     * Get Shadow direction (in degrees).
     *
     * @return int
     */
    public function getDirection()
    {
        return $this->direction;
    }
    /**
     * Set Shadow direction (in degrees).
     *
     * @param int $pValue
     *
     * @return $this
     */
    public function setDirection($pValue)
    {
        $this->direction = $pValue;
        return $this;
    }
    /**
     * Get Shadow alignment.
     *
     * @return int
     */
    public function getAlignment()
    {
        return $this->alignment;
    }
    /**
     * Set Shadow alignment.
     *
     * @param int $pValue
     *
     * @return $this
     */
    public function setAlignment($pValue)
    {
        $this->alignment = $pValue;
        return $this;
    }
    /**
     * Get Color.
     *
     * @return Color
     */
    public function getColor()
    {
        return $this->color;
    }
    /**
     * Set Color.
     *
     * @param Color $pValue
     *
     * @return $this
     */
    public function setColor(?Color $pValue = null)
    {
        $this->color = $pValue;
        return $this;
    }
    /**
     * Get Alpha.
     *
     * @return int
     */
    public function getAlpha()
    {
        return $this->alpha;
    }
    /**
     * Set Alpha.
     *
     * @param int $pValue
     *
     * @return $this
     */
    public function setAlpha($pValue)
    {
        $this->alpha = $pValue;
        return $this;
    }
    /**
     * Get hash code.
     *
     * @return string Hash code
     */
    public function getHashCode()
    {
        return \md5(($this->visible ? 't' : 'f') . $this->blurRadius . $this->distance . $this->direction . $this->alignment . $this->color->getHashCode() . $this->alpha . __CLASS__);
    }
    /**
     * Implement PHP __clone to create a deep clone, not just a shallow copy.
     */
    public function __clone()
    {
        $vars = \get_object_vars($this);
        foreach ($vars as $key => $value) {
            if (\is_object($value)) {
                $this->{$key} = clone $value;
            } else {
                $this->{$key} = $value;
            }
        }
    }
}
