<?php

namespace Rdgcorp\OpenAI\Application;

use Rdgcorp\OpenAI\Domain\OpenAICompletionsInterface;
use Rdgcorp\OpenAI\Infrastructure\OpenAIClient;

class CustomChatCompletion
{
    private OpenAIClient $openAiClient;

    public function __construct(OpenAIClient $openAiClient)
    {
        $this->openAiClient = $openAiClient;
    }

    public function __invoke(OpenAICompletionsInterface $openAICompletions): string
    {
        $responseData = $this->openAiClient->chatCompletion($openAICompletions);

        return $responseData['choices'][0]['message']['content'];
    }
}
