<?php

namespace Rdgcorp\OpenAI\Application;

use Rdgcorp\OpenAI\Domain\Constants\OpenAIModels;
use Rdgcorp\OpenAI\Domain\OpenAICompletions;
use Rdgcorp\OpenAI\Domain\OpenAIMessageContent;
use Rdgcorp\OpenAI\Infrastructure\OpenAIClient;

class GenerateFeaturedImageName
{
    private OpenAIClient $openAiClient;

    public function __construct(OpenAIClient $openAiClient)
    {
        $this->openAiClient = $openAiClient;
    }

    public function __invoke($imageUrl): string
    {
        $openAIMessageContent = (new OpenAIMessageContent())->addImageContent($imageUrl);

        $openAICompletions = (new OpenAICompletions(OpenAIModels::GPT4_VISION_PREVIEW))
            ->addSystemMessage('You are helpful copywriter')
            ->addUserMessage('Generate an SEO friendly name of no more than 50 characters for the following image')
            ->addUserMessage($openAIMessageContent);

        $responseData = $this->openAiClient->chatCompletion($openAICompletions);

        return $responseData['choices'][0]['message']['content'];
    }
}
