<?php

namespace Rdgcorp\OpenAI\Domain;

class OpenAIMessageContent
{
    private array $content = [];

    public function getContent(): array
    {
        return $this->content;
    }

    public function addTextContent(string $text): self
    {
        $this->content[] = [
            'type' => 'text',
            'text' => $text,
        ];

        return $this;
    }

    public function addImageContent(string $url): self
    {
        $this->content[] = [
            'type' => 'image_url',
            'image_url' => [
                'url' => $url,
            ],
        ];

        return $this;
    }
}
