<?php

namespace Rdgcorp\OpenAI\Infrastructure;

use Rdgcorp\OpenAI\Domain\OpenAICompletionsInterface;
use Symfony\Component\HttpClient\HttpClient;
use Symfony\Contracts\HttpClient\HttpClientInterface;

class OpenAIClient
{
    private HttpClientInterface $httpClient;

    public function __construct(string $token)
    {
        $this->httpClient = HttpClient::create([
            'auth_bearer' => $token,
            'headers' => [
                'Accept' => 'application/json',
                'Content-Type' => 'application/json; charset=utf-8',
            ],
        ]);
    }

    public function chatCompletion(OpenAICompletionsInterface $openAICompletions): array
    {
        $response = $this->httpClient->request('POST', 'https://api.openai.com/v1/chat/completions', [
            'body' => $openAICompletions->getRequestBody(),
        ]);

        if (200 !== $response->getStatusCode()) {
            throw new \Exception(json_encode([
                'statusCode' => $response->getStatusCode(),
                'response' => $response->toArray(false),
            ]));
        }

        return $response->toArray();
    }
}
