<?php

namespace Rdgcorp\OpenAI;

use Rdgcorp\OpenAI\Application\CustomChatCompletion;
use Rdgcorp\OpenAI\Application\GenerateFeaturedImageName;
use Rdgcorp\OpenAI\Application\GeneratePostTitle;
use Rdgcorp\OpenAI\Domain\OpenAICompletionsInterface;
use Rdgcorp\OpenAI\Infrastructure\OpenAIClient;

class OpenAI
{
    private OpenAIClient $openAIClient;

    public function __construct(string $token)
    {
        $this->openAIClient = new OpenAIClient($token);
    }

    public function generatePostTitle(string $content): string
    {
        $generatePostTitle = new GeneratePostTitle($this->openAIClient);

        return $generatePostTitle($content);
    }

    public function generateFeaturedImageName(string $imageUrl): string
    {
        $generateFeaturedImageName = new GenerateFeaturedImageName($this->openAIClient);

        return $generateFeaturedImageName($imageUrl);
    }

    public function generateCustomChatCompletion(OpenAICompletionsInterface $openAICompletions): string
    {
        $generateCustomChatCompletions = new CustomChatCompletion($this->openAIClient);

        return $generateCustomChatCompletions($openAICompletions);
    }
}
