<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Load the main class for the core functionality
 */
require_once RDGBLOCKS_PLUGIN_DIR.'core/includes/classes/class-rdg-blocks-helpers.php';

class Rdg_Blocks_Block2
{
    private $block_name = 'rdg-block2';
    private $block_folder_name = 'rdg-block2';
    private $block_title = 'Block 2';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'block2'];
    private $block_mode = 'preview';
    private $block_category = "rdg-blocks";

    public function init() {
        $this->register_block();
        //$this->register_fields();
    }

    public function get_block_name() {
        return $this->block_name;
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_block2.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => true,
                        'text' => true,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_block_faq',
                'title' => 'Block_faq',
                'fields' => array(
                    array(
                        'key' => 'field_block_faq_001',
                        'label' => 'FAQ Page ID',
                        'name' => 'faq-page-id',
                        'type' => 'text',
                        'required' => 1,
                    ),
                    array(
                        'key' => 'field_block_faq_002',
                        'label' => 'Title',
                        'name' => 'title',
                        'type' => 'text',
                        'required' => 1,
                    ),
                    array(
                        'key' => 'field_block_faq_003',
                        'label' => 'Description',
                        'name' => 'description',
                        'type' => 'textarea',
                        'required' => 1,
                    ),
                    array(
                        'key' => 'field_block_faq_004',
                        'label' => 'Items',
                        'name' => 'items',
                        'type' => 'repeater',
                        'required' => 1,
                        'min' => 1,
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_block_faq_005',
                                'label' => 'Title',
                                'name' => 'title',
                                'type' => 'text',
                                'required' => 1,
                            ),
                            array(
                                'key' => 'field_block_faq_006',
                                'label' => 'Content',
                                'name' => 'content',
                                'type' => 'wysiwyg',
                                'required' => 1,
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 0,
                                'delay' => 0,
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/faq',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }
}

$rdg_block2_class = new Rdg_Blocks_Block2();
$rdg_block2_class->init();

return $rdg_block2_class;
