<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

/**
 * HELPER COMMENT START
 * 
 * This is the main class that is responsible for registering
 * the core functions, including the files and setting up all features. 
 * 
 * To add a new class, here's what you need to do: 
 * 1. Add your new class within the following folder: core/includes/classes
 * 2. Create a new variable you want to assign the class to (as e.g. public $helpers)
 * 3. Assign the class within the instance() function ( as e.g. self::$instance->helpers = new Rdg_Blocks_Helpers();)
 * 4. Register the class you added to core/includes/classes within the includes() function
 * 
 * HELPER COMMENT END
 */

if (!class_exists('Rdg_Blocks')):
    /**
     * Main Rdg_Blocks Class.
     *
     * @package		RDGBLOCKS
     * @subpackage	Classes/Rdg_Blocks
     * @since		1.0.0
     * @author		RDGCorp
     */

    final class Rdg_Blocks {
        /**
         * The real instance
         *
         * @access	private
         * @since	1.0.0
         * @var		object|Rdg_Blocks
         */

        private static $instance;

        /**
         * RDGBLOCKS helpers object.
         *
         * @access	public
         * @since	1.0.0
         * @var		object|Rdg_Blocks_Helpers
         */

        public $helpers;

        /**
         * RDGBLOCKS settings object.
         *
         * @access	public
         * @since	1.0.0
         * @var		object|Rdg_Blocks_Settings
         */

        public $settings;

        /**
         * Throw error on object clone.
         *
         * Cloning instances of the class is forbidden.
         *
         * @access	public
         * @since	1.0.0
         * @return	void
         */

        public function __clone() {
            _doing_it_wrong(__FUNCTION__, __('You are not allowed to clone this class.', 'rdg-blocks'), '1.0.0');
        }

        /**
         * Disable unserializing of the class.
         *
         * @access	public
         * @since	1.0.0
         * @return	void
         */

        public function __wakeup() {
            _doing_it_wrong(__FUNCTION__, __('You are not allowed to unserialize this class.', 'rdg-blocks'), '1.0.0');
        }

        /**
         * Main Rdg_Blocks Instance.
         *
         * Insures that only one instance of Rdg_Blocks exists in memory at any one
         * time. Also prevents needing to define globals all over the place.
         *
         * @access		public
         * @since		1.0.0
         * @static
         * @return		object|Rdg_Blocks	The one true Rdg_Blocks
         */

        public static function instance() {
            if (!isset(self::$instance) && !(self::$instance instanceof Rdg_Blocks)) {
                self::$instance = new Rdg_Blocks;
                self::$instance->base_hooks();
                self::$instance->includes();
                self::$instance->helpers = new Rdg_Blocks_Helpers();
                self::$instance->settings = new Rdg_Blocks_Settings();

                //Fire the plugin logic
                new Rdg_Blocks_Run();

                /**
                 * Fire a custom action to allow dependencies
                 * after the successful plugin setup
                 */

                do_action('RDGBLOCKS/plugin_loaded');
            }

            return self::$instance;
        }

        /**
         * Include required files.
         *
         * @access  private
         * @since   1.0.0
         * @return  void
         */

        private function includes() {
            require_once RDGBLOCKS_PLUGIN_DIR . 'core/includes/classes/class-rdg-blocks-helpers.php';
            require_once RDGBLOCKS_PLUGIN_DIR . 'core/includes/classes/class-rdg-blocks-settings.php';
            require_once RDGBLOCKS_PLUGIN_DIR . 'core/includes/classes/class-rdg-blocks-run.php';
        }

        /**
         * Add base hooks for the core functionality
         *
         * @access  private
         * @since   1.0.0
         * @return  void
         */

        private function base_hooks() {
            add_action('plugins_loaded', array(self::$instance, 'load_textdomain'));
        }

        /**
         * Loads the plugin language files.
         *
         * @access  public
         * @since   1.0.0
         * @return  void
         */

        public function load_textdomain() {
            load_plugin_textdomain('rdg-blocks', FALSE, dirname(plugin_basename(RDGBLOCKS_PLUGIN_FILE )) . '/languages/');
        }
    }

endif; // End if class_exists check.
