<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

/**
 * Class Rdg_Blocks_Helpers
 *
 * This class contains repetitive functions that
 * are used globally within the plugin.
 *
 * @package		RDGBLOCKS
 * @subpackage	Classes/Rdg_Blocks_Helpers
 * @author		RDGCorp
 * @since		1.0.0
 */
class Rdg_Blocks_Helpers
{
    /**
     * ######################
     * ###
     * #### CALLABLE FUNCTIONS
     * ###
     * ######################
     */

    /**
     * HELPER COMMENT START
     *
     * Within this class, you can define common functions that you are 
     * going to use throughout the whole plugin. 
     * 
     * Down below you will find a demo function called output_text()
     * To access this function from any other class, you can call it as followed:
     * 
     * RDGBLOCKS()->helpers->output_text( 'my text' );
     * 
     */

    /**
     * Output some text
     *
     * @param	string	$text	The text to output
     * @since	1.0.0
     *
     * @return	void
     */
    public function output_text( $text = '' ) {
        echo $text;
    }

    /**
     * HELPER COMMENT END
    */

    public function webpack($file, $buildDirectory = 'dist') {
        static $manifest;
        static $manifestPath;

        if (is_null($manifest) || $manifestPath !== $buildDirectory) {
            $manifest = json_decode(
                file_get_contents(RDGBLOCKS_PLUGIN_URL.$buildDirectory.'/manifest.json'),
                true
            );

            $manifestPath = $buildDirectory;
        }

        if (isset($manifest[$file])) {
            return RDGBLOCKS_PLUGIN_URL.trim($buildDirectory.'/'.$manifest[$file], '/');
        }

        throw new InvalidArgumentException("File {$file} not defined in asset manifest.");
    }
}
