<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

class Rdg_Blocks_Main_Banner
{
    private $block_name = 'rdg-main-banner';
    private $block_folder_name = 'rdg-main-banner';
    private $block_title = 'RDG Main Banner';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'main banner', 'main', 'banner'];
    private $block_mode = 'preview';
    private $block_category = "rdg-blocks";

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    public function get_block_name() {
        return $this->block_name;
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_main_banner.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_main_banner_block_hd73nsdu7sb32y',
                'title' => 'Block_rdg_main_banner',
                'fields' => array(
                    array(
                        'key' => 'field_6373ac3613630',
                        'label' => 'Block Options',
                        'name' => '',
                        'aria-label' => '',
                        'type' => 'accordion',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'open' => 0,
                        'multi_expand' => 0,
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_6373ac6613631',
                        'label' => 'Background',
                        'name' => 'background',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6373ac8413632',
                                'label' => 'Background color',
                                'name' => 'color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#172d54',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6373acaf13633',
                                'label' => 'Background Image',
                                'name' => 'image',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_6373ad1513634',
                        'label' => 'Padding / Spaces',
                        'name' => 'padding_spaces',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6373ad3113635',
                                'label' => 'Padding Top',
                                'name' => 'padding_top',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_6373ad5d13636',
                                'label' => 'Padding Left',
                                'name' => 'padding_left',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_6373ad6b13637',
                                'label' => 'Padding Right',
                                'name' => 'padding_right',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'min' => 0,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_6373ad9113638',
                                'label' => 'Width',
                                'name' => 'width',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 100,
                                'min' => 10,
                                'max' => 100,
                                'placeholder' => '',
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_6373adbe13639',
                                'label' => 'Position',
                                'name' => 'position',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'left' => 'Left',
                                    'center' => 'Center',
                                    'right' => 'Right',
                                ),
                                'default_value' => 'right',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_6373ae0a1363a',
                        'label' => 'Texts',
                        'name' => 'texts',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6373ae181363b',
                                'label' => 'Text',
                                'name' => 'texts',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'pagination' => 0,
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_6373ae761363c',
                                        'label' => 'Title',
                                        'name' => 'title',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_6373ae871363d',
                                        'label' => 'Heading',
                                        'name' => 'heading',
                                        'aria-label' => '',
                                        'type' => 'select',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            'h1' => 'H1',
                                            'h2' => 'H2',
                                            'h3' => 'H3',
                                            'span' => 'Span',
                                        ),
                                        'default_value' => 'h1',
                                        'return_format' => 'value',
                                        'multiple' => 0,
                                        'allow_null' => 0,
                                        'ui' => 0,
                                        'ajax' => 0,
                                        'placeholder' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_6373aecf1363e',
                                        'label' => 'Size',
                                        'name' => 'size',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => 3,
                                        'min' => 1,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_6373aefa1363f',
                                        'label' => 'Size LG',
                                        'name' => 'size_lg',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'min' => 1,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_6373af0713640',
                                        'label' => 'Size MD',
                                        'name' => 'size_md',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'min' => 1,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_6373af1513641',
                                        'label' => 'Size SM',
                                        'name' => 'size_sm',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'min' => 1,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_6373af3313642',
                                        'label' => 'Padding',
                                        'name' => 'padding',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => 0,
                                        'min' => 0,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_6373af5213643',
                                        'label' => 'Weight',
                                        'name' => 'weight',
                                        'aria-label' => '',
                                        'type' => 'select',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'choices' => array(
                                            100 => '100',
                                            200 => '200',
                                            300 => '300',
                                            400 => '400',
                                            500 => '500',
                                            600 => '600',
                                            700 => '700',
                                            800 => '800',
                                            900 => '900',
                                        ),
                                        'default_value' => 500,
                                        'return_format' => 'value',
                                        'multiple' => 0,
                                        'allow_null' => 0,
                                        'ui' => 0,
                                        'ajax' => 0,
                                        'placeholder' => '',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_6373af8f13644',
                                        'label' => 'Color',
                                        'name' => 'color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#00bc00',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                    array(
                                        'key' => 'field_6373afac13645',
                                        'label' => 'Shadow Color',
                                        'name' => 'shadow_color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '#000000',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                        'parent_repeater' => 'field_6373ae181363b',
                                    ),
                                ),
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_6373affa2145f',
                        'label' => 'Member',
                        'name' => 'member',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6373b00921460',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                            ),
                            array(
                                'key' => 'field_6373b02121461',
                                'label' => 'Background Color',
                                'name' => 'background_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#00bc00',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6373b04421462',
                                'label' => 'Title Color',
                                'name' => 'title_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#ffffff',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                            array(
                                'key' => 'field_6373b06121463',
                                'label' => 'Shadow Color',
                                'name' => 'shadow_color',
                                'aria-label' => '',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#68f96e',
                                'enable_opacity' => 0,
                                'return_format' => 'string',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-main-banner',
                        ),
                    ),
                ),
                'menu_order' => 2,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_style($type, $fields) {
        $style = [];
    
        if ('block' == $type) {
            $color = (!empty($fields['color'])) ? $fields['color'] : '#172d54';
            $style[] = 'background-color: '.$color;
    
            if (!empty($fields['image']['url'])) {
                $style[] = 'background-image: url('.$fields['image']['url'].')';
            }
    
            return implode('; ', $style);
        }
    
        if ('position' == $type) {
            if (!empty($fields['padding_top'])) {
                $style[] = 'padding-top: '.$fields['padding_top'].'rem';
            }
    
            if (!empty($fields['padding_left'])) {
                $style[] = 'padding-left: '.$fields['padding_left'].'rem';
            }
    
            if (!empty($fields['padding_right'])) {
                $style[] = 'padding-right: '.$fields['padding_right'].'rem';
            }
    
            return implode('; ', $style);
        }
    }

    public function get_texts($spaces, $titles, $member) {
        $texts = [];
        $min_size = (100 - $spaces['width']) / 2;
        $align = $spaces['position'];
    
        if (empty($titles)) {
            return;
        }

        $rdg_helpers = new Rdg_Blocks_Helpers();
        
        foreach($titles['texts'] as $title) {
            $style = $rdg_helpers->get_blocks_title_sizes($title);
            $style[] = (!empty($title['color'])) ? 'color: '.$title['color'] : 'color: #ffffff';
            $style[] = (!empty($title['weight'])) ? 'font-weight: '.$title['weight'] : 'font-weight: 400';
            $style[] = (!empty($title['padding'])) ? 'padding-bottom: '.$title['padding'].'rem' : 'padding-bottom: 0rem';
    
            if (!empty($title['shadow_color'])) {
                $style[] = 'text-shadow: 0px 1px 1px '.$title['shadow_color'];
            }
    
            $texts[] = '<'.$title['heading'].' style="'.implode('; ', $style).'">'.$title['title'].'</'.$title['heading'].'>';
            $style = [];
        }
        
        $button = $this->get_link($member);
        
        if ('left' == $align) {
            echo '<div class="position size-left" style="width: '.$spaces['width'].'%;"><div class="texts"><div class="content">'.implode('', $texts).'</div></div><div class="button">'.$button.'</div></div>';
            echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
            echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
    
            return;
        }
    
        if ('center' == $align) {
            echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
            echo '<div class="position size-center" style="width: '.$spaces['width'].'%;"><div class="texts"><div class="content">'.implode('', $texts).'</div></div><div class="button">'.$button.'</div></div>';
            echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
    
            return;
        }
    
        if ('right' == $align) {
            echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
            echo '<div class="position size-small" style="width: '.$min_size.'%;"></div>';
            echo '<div class="position size-right" style="width: '.$spaces['width'].'%;"><div class="texts"><div class="content">'.implode('', $texts).'</div></div><div class="button">'.$button.'</div></div>';
    
            return;
        }
    }

    private function get_link($member) {
        if (is_array($member['link'])) {
            if (!empty($member['background_color'])) {
                $styles[] = 'background-color: '.$member['background_color'].';';
            } else {
                $styles[] = 'background-color: #459519;';
            }
    
            if (!empty($member['title_color'])) {
                $styles[] = 'color: '.$member['title_color'].';';
            } else {
                $styles[] = 'color: #ffffff;';
            }
    
            if (!empty($member['shadow_color'])) {
                $styles[] = '--btn-box-shadow: '.$member['shadow_color'].';';
            } else {
                $styles[] = '--btn-box-shadow: #68f96e;';
            }
    
            $target = (!empty($member['link']['title'])) ? $member['link']['target'] : '_self';
            return '<a class="link-member" href="'.$member['link']['url'].'" target="'.$target.'" style="'.implode(' ', $styles).'">'.$member['link']['title'].'</a>';
        }
    
        return '';
    }
}

$rdg_main_banner_class = new Rdg_Blocks_Main_Banner();
$rdg_main_banner_class->init();

return $rdg_main_banner_class;
