<?php 
    global $rdgb;
    $block_styles = [];
    $block_classes = ['rdg-main-banner'];
    $block_main_banner = $rdgb->settings->get_block('rdg-main-banner');

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }
    
    $texts = get_field('texts');
    $member = get_field('member');
    $padding_spaces = get_field('padding_spaces');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    list($heading, $title, $styles) = $rdgb->helpers->get_blocks_title(get_fields());
    $style_block = $block_main_banner->get_style('block', get_field('background'));
    $style_position = $block_main_banner->get_style('position', get_field('padding_spaces'));
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php if(!empty($title)): ?>
            <div class="rdg-title" style="<?php echo $styles; ?>">
                <<?php echo $heading; ?>><?php echo $title; ?></<?php echo $heading; ?>>
            </div>
        <?php endif; ?>
        <div class="body" style="<?php echo $style_block; ?>">
            <div class="positions" style="<?php echo $style_position; ?>">
                <?php $block_main_banner->get_texts($padding_spaces, $texts, $member); ?>
            </div>
        </div>
    </div>
</div>
