<?php 
    global $rdgb;
    $block_styles = [];
    $block_classes = ['rdg-title'];
    $block_title = $rdgb->settings->get_block('rdg-title');

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    list($heading, $title, $styles) = $block_title->get_title(get_fields());
?>

<?php if(!empty($title)): ?>
    <div class="rdg-blocks">
        <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="rdg-blocks-title" style="<?php echo $styles; ?>">
                <<?php echo $heading; ?>><?php echo $title; ?></<?php echo $heading; ?>>
            </div>
        </div>
    </div>
<?php endif; ?>
