<?php
    global $rdgb;
    $block_top_winners = $rdgb->settings->get_block(BLOCK_RDG_TOP_WINNERS);

    $link = get_field('link');
    $tops = get_field('tops');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    list($heading, $title, $styles) = $block_top_winners->get_title(get_fields());

    $message = '';
    $source = get_field('source');

    if ($source == 'api') {
        $api_url = get_field('top_winners_api_url', 'option');
        $api_token = get_field('top_winners_api_token', 'option');
        $items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_top_winners->get_api_attributes($items);
            $response = $block_top_winners->get_resources($api_attributes['request'], $items);

            if (empty($response->message)) {
                $tops = $response->json;
            } else {
                $tops = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }
?>

<div class="rdg-blocks">
    <div class="rdg-top-winners" style="<?php echo $position_block; ?>">
        <div class="header">
            <?php if(!empty($title)): ?>
                <div class="title" style="<?php echo $styles; ?>">
                    <<?php echo $heading; ?> class="header-title"><?php echo $title; ?></<?php echo $heading; ?>>
                </div>
            <?php endif; ?>
        </div>

        <div class="body">
            <div class="legend">
                <div class="legend-logo"></div>
                <div class="legend-win">Win</div>
                <div class="legend-dra">Dra</div>
            </div>
            <div class="tops">
                <?php if (!empty($tops)): ?>
                    <?php
                        if ($source == 'api') {
                            require 'partials/api.php';
                        } else {
                            require 'partials/manual.php';
                        }
                    ?>
                <?php else: ?>
                    <?php if (!empty($message)): ?>
                        <span class="message"><?php echo $message; ?></span>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>

        <div class="footer">
            <?php if(!empty($link)): ?>
                <div class="footer-link">
                    <a href="<?php echo $link['url']; ?>" target="<?php echo $link['target']; ?>">
                        <?php echo $link['title']; ?>
                    </a>
                </div>
            <?php endif; ?>
        </div>

    </div>
</div>
