<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

require_once  RDGBLOCKS_PLUGIN_BLOCKS_DIR."rdg-blocks-base.php";

class Rdg_Blocks_Call_To_Action extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_CALL_TO_ACTION;
    private $block_folder_name = 'rdg-call-to-action';
    private $block_title = 'RDG Call to Action';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'cta', 'call to action', 'call', 'action'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_call_to_action.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_call_to_action_block_hd73nsdu7sb32y',
                'title' => 'Block_rdg_call_to_action',
                'fields' => array(
                    array(
                        'key' => 'rdg_call_to_action_field_632cabc1b8785',
                        'label' => 'Background Image',
                        'name' => 'background_image',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                        'preview_size' => 'medium',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                    ),
                    array(
                        'key' => 'rdg_call_to_action_field_632cac05b8786',
                        'label' => 'Primary Text',
                        'name' => 'text_primary',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'rdg_call_to_action_field_632cac13b8787',
                                'label' => 'Text',
                                'name' => 'text',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 0,
                                'delay' => 0,
                            ),
                            array(
                                'key' => 'rdg_call_to_action_field_632cac32b8788',
                                'label' => 'Heading',
                                'name' => 'heading',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'h1' => 'Heading H1',
                                    'h2' => 'Heading H2',
                                    'h3' => 'Heading H3',
                                    'span' => 'Heading Span',
                                ),
                                'default_value' => 'span',
                                'allow_null' => 0,
                                'multiple' => 0,
                                'ui' => 0,
                                'return_format' => 'value',
                                'ajax' => 0,
                                'placeholder' => '',
                            ),
                            array(
                                'key' => 'rdg_call_to_action_field_632cac6fb8789',
                                'label' => 'Size',
                                'name' => 'size',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 4,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'min' => 1,
                                'max' => 20,
                                'step' => 1,
                            ),
                            array(
                                'key' => 'rdg_call_to_action_field_6373aefa1363f',
                                'label' => 'Size LG',
                                'name' => 'size_lg',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 1,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'rdg_call_to_action_field_6373af0713640',
                                'label' => 'Size MD',
                                'name' => 'size_md',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 1,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'rdg_call_to_action_field_6373af1513641',
                                'label' => 'Size SM',
                                'name' => 'size_sm',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 1,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'rdg_call_to_action_field_632cac93b878a',
                                'label' => 'Spacing',
                                'name' => 'spacing',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 0,
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'min' => 0,
                                'max' => 20,
                                'step' => 1,
                            ),
                            array(
                                'key' => 'rdg_call_to_action_field_632cacbf414dc',
                                'label' => 'Color',
                                'name' => 'color',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '#ffffff',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'rdg_call_to_action_field_632cad0f3e0eb',
                        'label' => 'Links',
                        'name' => 'links',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'collapsed' => '',
                        'min' => 0,
                        'max' => 0,
                        'layout' => 'block',
                        'button_label' => '',
                        'sub_fields' => array(
                            array(
                                'key' => 'rdg_call_to_action_field_632cad293e0ec',
                                'label' => 'Link',
                                'name' => 'link',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                            ),
                            array(
                                'key' => 'rdg_call_to_action_field_632cad413e0ed',
                                'label' => 'Default Styles',
                                'name' => 'default_styles',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'link-success' => 'Success',
                                    'link-warning' => 'Warning',
                                    'link-danger' => 'Danger',
                                    'link-default' => 'Default',
                                    'custom' => 'Custom',
                                ),
                                'default_value' => 'link-warning',
                                'allow_null' => 0,
                                'multiple' => 0,
                                'ui' => 0,
                                'return_format' => 'value',
                                'ajax' => 0,
                                'placeholder' => '',
                            ),
                            array(
                                'key' => 'rdg_call_to_action_field_632cad773e0ee',
                                'label' => 'Background color',
                                'name' => 'background_color',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'rdg_call_to_action_field_632cad413e0ed',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                            ),
                            array(
                                'key' => 'rdg_call_to_action_field_632cada03e0ef',
                                'label' => 'Background Hover Color',
                                'name' => 'background_hover_color',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'rdg_call_to_action_field_632cad413e0ed',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                            ),
                            array(
                                'key' => 'rdg_call_to_action_field_632cadd73e0f0',
                                'label' => 'Text color',
                                'name' => 'text_color',
                                'type' => 'color_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'rdg_call_to_action_field_632cad413e0ed',
                                            'operator' => '==',
                                            'value' => 'custom',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-call-to-action',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_style($type, $fields) {
        $style = [];

        if ('texts' == $type) {
            $rdg_helpers = new Rdg_Blocks_Helpers();

            $style = $rdg_helpers->get_title_sizes($fields);
            $spacing = $fields['spacing'];
            $color = ($fields['color'] != '') ? $fields['color'] : '#ffffff';
            $style[] = 'padding-bottom: '.$spacing.'rem';
            $style[] = 'color: '.$color;

            return implode('; ', $style);
        }
    
        if ('buttons' == $type) {
            $style[] = 'background-color: '.$fields['background_color'];
            $style[] = 'color: '.$fields['text_color'];
    
            return implode('; ', $style);
        }
    
        return '';
    }
}

$rdg_call_to_action_class = new Rdg_Blocks_Call_To_Action();
$rdg_call_to_action_class->init();

return $rdg_call_to_action_class;
