<?php
    global $rdgb;
    $block_styles = [];
    $block_classes = ['rdg-sports-picks'];
    $block_sports_picks = $rdgb->settings->get_block(BLOCK_RDG_SPORTS_PICKS);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $picks = get_field('picks');
    $links = get_field('links');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    list($heading, $title, $styles) = $block_sports_picks->get_title(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php if(!empty($title)): ?>
            <div class="title" style="<?php echo $styles; ?>">
                <<?php echo $heading; ?>><?php echo $title; ?></<?php echo $heading; ?>>
            </div>
        <?php endif; ?>

        <?php if (!empty($picks) && count($picks) > 0): ?>
            <div class="picks">
                <?php foreach($picks as $pick):?>
                    <div class="pick">
                        <div class="pick-header">
                            <div class="title">
                                <span class="header-title"><?php echo $pick['title']; ?></span>
                            </div>
                            <div class="content">
                                <div class="sport"><span><?php echo $pick['category']; ?></span></div>
                                <div class="date-time"><span><?php echo $pick['time']; ?></span></div>
                                <div class="status"><span><?php echo $pick['status']; ?></span></div>
                            </div>
                        </div>
                        <div class="pick-body">
                            <?php if (isset($pick['teams']) && count($pick['teams']) > 0 && count($pick['teams']) == 2): ?>
                                <div class="teams">
                                    <?php $teams = 0; ?>
                                    <?php foreach($pick['teams'] as $team): ?>
                                        <?php $class_team = ($teams == 0) ? 'team-a' : 'team-b'; ?>

                                        <div class="team <?php echo $class_team; ?>">
                                            <div class="team-logo">
                                                <?php if (isset($team['logo']['url']) && $team['logo']['url'] != ''): ?>
                                                    <img src="<?php echo $team['logo']['url']; ?>" alt="">
                                                <?php endif; ?>
                                            </div>
                                            <div class="team-name"><span><?php echo $team['name']; ?></span></div>
                                        </div>

                                        <?php if ($teams == 0): ?>
                                            <div class="team team-vs">
                                                <div class="vs-logo"><span>vs</span></div>
                                                <div class="vs-name"><span><?php echo $pick['vs']; ?></span></div>
                                            </div>
                                        <?php endif;?>

                                        <?php $teams++; ?>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($pick['ranking']) && count($pick['ranking']) > 0): ?>
                                <div class="numbers">
                                    <?php foreach($pick['ranking'] as $ranking): ?>
                                        <div class="number"><span><?php echo $ranking['value']; ?></span></div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <?php if (!empty($pick['link'])): ?>
                            <div class="pick-footer">
                                <a href="<?php echo $pick['link']['url']; ?>" target="<?php echo (empty($pick['link']['target'])) ? '_self' : $pick['link']['target']; ?>"><?php echo $pick['link']['title']; ?></a>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <?php if (is_array($links) && count($links) > 0): ?>
            <div class="buttons">
                <?php foreach($links as $link): ?>
                    <?php
                        $link_class = '';
                        $link_style = '';
                        if ($link['default_styles'] != 'custom') {
                            $link_class = 'class="'.$link['default_styles'].'"';
                        } else {
                            $link_style = 'onMouseOut="this.style.backgroundColor=\''.$link['background_color'].'\'" onmouseover="this.style.backgroundColor=\''.$link['background_hover_color'].'\'" class="link-default" style="'.gameadvisers2022_simple_text_button_get_style('buttons', $link).'"';
                        }
                    ?>
                    <?php if (!empty($link['link']['url']) && $link['link']['title']): ?>
                        <a href="<?php echo $link['link']['url']; ?>" <?php echo $link_class; ?> <?php echo $link_style; ?>><?php echo $link['link']['title']; ?></a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
