<?php
    global $rdgb;
    $block_styles = [];
    $block_classes = ['rdg-admin-cappers'];
    $block_name = BLOCK_RDG_ADMIN_CAPPERS;
    $block_admin_cappers = $rdgb->settings->get_block(BLOCK_RDG_ADMIN_CAPPERS);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $cappers = get_field('cappers');
    $links = get_field('links');

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php if (is_array($titles) && count($titles) > 0): ?>
            <?php foreach ($titles as $title): ?>
                <?php list($heading, $title, $styles) = $block_admin_cappers->get_title($title); ?>

                <?php if(!empty($title)): ?>
                    <div class="title" style="<?php echo $styles; ?>">
                        <<?php echo $heading; ?>><?php echo $title; ?></<?php echo $heading; ?>>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        <?php endif; ?>

        <?php if (!empty($cappers) && count($cappers) > 0): ?>
            <div class="cappers">
                <?php foreach($cappers as $capper):?>
                    <div class="capper">
                        <div class="content">
                            <div class="capper-header">
                                <div class="header-avatar">
                                    <img src="<?php echo $capper['logo']['url']; ?>" alt="">
                                </div>
                                <div class="header-content">
                                    <span class="title"><?php echo $capper['title']; ?></span>
                                    <span class="sub-title"><?php echo $capper['sub_title']; ?></span>
                                    <span class="total"><?php echo $capper['total']; ?>
                                        <span class="picks"><?php echo $capper['picks']; ?></span>
                                    </span>
                                </div>
                            </div>
                            
                            <div class="capper-content">
                                <?php if (!empty($capper['description'])): ?>
                                    <div class="content-description"><?php echo $capper['description']; ?> </div>
                                <?php endif; ?>

                                <div class="content-category">
                                    <div class="category">
                                        <span><?php echo $capper['category']; ?></span>
                                    </div>
                                    <div class="date">
                                        <span><?php echo $capper['date']; ?></span>
                                    </div>
                                    <div class="status">
                                        <span><?php echo $capper['status']; ?></span>
                                    </div>
                                </div>

                                <div class="content-teams">
                                    <span class="team-home">
                                            <?php echo $capper['home_team']; ?>
                                    </span>
                                    <span class="team-vs">@</span>
                                    <span class="team-visitor">
                                        <?php echo $capper['visitor_team']; ?>
                                    </span>
                                </div>
                                
                                <div class="content-release">
                                    <span class="release-date">Release Date:
                                        <span><?php echo $capper['release_date']; ?></span>
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="capper-footer">
                            <div class="footer-link">
                                <a href="<?php echo $capper['link']['url']; ?>"><?php echo $capper['link']['title']; ?></a>
                            </div>
                            <div class="footer-status">
                                <span><?php echo $capper['status']; ?></span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <?php if (is_array($links) && count($links) > 0): ?>
            <div class="buttons">
                <?php foreach($links as $link): ?>
                    <?php
                        $link_class = '';
                        $link_style = '';
                        if ($link['default_styles'] != 'custom') {
                            $link_class = 'class="'.$link['default_styles'].'"';
                        } else {
                            $link_style = 'onMouseOut="this.style.backgroundColor=\''.$link['background_color'].'\'" onmouseover="this.style.backgroundColor=\''.$link['background_hover_color'].'\'" class="link-default" style="'.$block_admin_cappers->get_style('buttons', $link).'"';
                        }
                    ?>
                    <?php if (!empty($link['link']['url']) && $link['link']['title']): ?>
                        <a href="<?php echo $link['link']['url']; ?>" <?php echo $link_class; ?> <?php echo $link_style; ?>><?php echo $link['link']['title']; ?></a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
