<?php 
    global $rdgb;
    $block_styles = [];
    $block_classes = ['rdg-call-to-action'];
    $block_call_to_action = $rdgb->settings->get_block(BLOCK_RDG_CALL_TO_ACTION);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $links = get_field('links');
    $text_primary = get_field('text_primary');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
    <?php $image = (isset(get_field('background_image')['url'])) ? "--background-image: url(".get_field('background_image')['url'].");" :''; ?>
        <div class="body" style="<?php echo $image; ?>">
            <div class="container content grid-container">
                <?php if (is_array($text_primary) && !empty($text_primary['text'])): ?>
                    <<?php echo $text_primary['heading']; ?> style="<?php echo $block_call_to_action->get_style('texts', $text_primary); ?>;"><?php echo $text_primary['text']; ?></<?php echo $text_primary['heading']; ?>>
                <?php endif; ?>
                <div class="footer">
                    <?php if (is_array($links) && count($links)): ?>
                    <div class="buttons">
                            <?php foreach($links as $link): ?>
                                <?php
                                    $link_class = '';
                                    $link_style = '';
                                    if ($link['default_styles'] != 'custom') {
                                        $link_class = 'class="'.$link['default_styles'].'"';
                                    } else {
                                        $link_style = 'onMouseOut="this.style.backgroundColor=\''.$link['background_color'].'\'" onmouseover="this.style.backgroundColor=\''.$link['background_hover_color'].'\'" class="link-default" style="'.$block_call_to_action->get_style('buttons', $link).'"';
                                    }
                                ?>
                                <a href="<?php echo $link['link']['url']; ?>" <?php echo $link_class; ?> <?php echo $link_style; ?>><?php echo $link['link']['title']; ?></a>
                            <?php endforeach; ?>
                        </div>
                        <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
