<?php
    global $rdgb;
    $block_styles = [];
    $block_classes = ['rdg-image-column'];
    $block_image_column = $rdgb->settings->get_block(BLOCK_RDG_IMAGE_COLUMN);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $links = get_field('links');
    $items = get_field('items');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $image = (!empty(get_field('image'))) ? get_field('image') : null;
    list($heading, $title, $styles) = $block_image_column->get_title(get_fields());
    $padding_column = (!empty(get_field('padding_column'))) ? get_field('padding_column') : 0;
    [$width_image, $width_items] = $block_image_column->get_width(!empty($image), !empty($items));
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container">
            <?php if(!empty($title)): ?>
                <div class="title" style="<?php echo $styles; ?>">
                    <<?php echo $heading; ?>><?php echo $title; ?></<?php echo $heading; ?>>
                </div>
            <?php endif; ?>

            <div class="content" style="--padding-column: <?php echo $padding_column.'rem';?>;">
                <?php if (!empty($image)): ?>
                    <div class="image <?php echo $width_image; ?>">
                        <img src="<?php echo $image['url']; ?>" alt="">
                    </div>
                <?php endif; ?>
                <div class="items <?php echo $width_items; ?>">
                    <?php if (!empty($items)): ?>
                        <?php foreach($items as $item): ?>
                            <div class="item">
                                <span class="item-title"><?php echo (isset($item['title'])) ? $item['title'] : ''; ?></span>
                                <p class="item-text"><?php echo (isset($item['text'])) ? $item['text'] : ''; ?></p>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>

            <div class="buttons">
                <?php if (is_array($links) && count($links)): ?>
                    <?php foreach($links as $link): ?>
                        <?php
                            $link_class = '';
                            $link_style = '';
                            if ($link['default_styles'] != 'custom') {
                                $link_class = 'class="'.$link['default_styles'].'"';
                            } else {
                                $link_style = 'onMouseOut="this.style.backgroundColor=\''.$link['background_color'].'\'" onmouseover="this.style.backgroundColor=\''.$link['background_hover_color'].'\'" class="link-default" style="'.$block_image_column->get_style('buttons', $link).'"';
                            }
                        ?>
                        <?php if (!empty($link['link']['url']) && !empty($link['link']['title'])): ?>
                            <a href="<?php echo $link['link']['url']; ?>" <?php echo $link_class; ?> <?php echo $link_style; ?>><?php echo $link['link']['title']; ?></a>
                        <?php endif; ?>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
