// Require path.
const path = require('path');

const MiniCssExtractPlugin = require("mini-css-extract-plugin");
const { CleanWebpackPlugin } = require('clean-webpack-plugin');
const ManifestPlugin = require('webpack-manifest-plugin');


// Configuration object.
const config = {
    // Create the entry points.
    // One for frontend and one for the admin area.
    entry: {
        rdg_main_banner: './blocks/rdg-main-banner/assets/build.js',
        rdg_call_to_action: './blocks/rdg-call-to-action/assets/build.js',
        rdg_title: './blocks/rdg-title/assets/build.js',
        rdg_image_column: './blocks/rdg-image-column/assets/build.js',
        rdg_top_winners: './blocks/rdg-top-winners/assets/build.js',
        rdg_sports_picks: './blocks/rdg-sports-picks/assets/build.js',
        rdg_admin_cappers: './blocks/rdg-admin-cappers/assets/build.js',
        rdg_next_game: './blocks/rdg-next-game/assets/build.js',
        rdg_slider_latest_post: './blocks/rdg-slider-latest-post/assets/build.js',
        rdg_latest_post: './blocks/rdg-latest-post/assets/build.js',
        rdg_picks_list: './blocks/rdg-picks-list/assets/build.js',
        rdg_faq: './blocks/rdg-faq/assets/build.js',
        rdg_faq_script: './blocks/rdg-faq/assets/js/block-faq-script.js',
        rdg_base_style: './assets/app.js'
    },

    // Create the output files.
    // One for each of our entry points.
    output: {
        // [name] allows for the entry object keys to be used as file names.
        filename: 'js/[name].[contenthash].js',
        // Specify the path to the JS files.
        path: path.resolve( __dirname, 'dist' )
    },
    mode: "development",
    // Setup a loader to transpile down the latest and great JavaScript so older browsers
    // can understand it.
    module: {
        rules: [
            {
                // Look for any .js files.
                test: /\.js$/,
                // Exclude the node_modules folder.
                //exclude: /node_modules/,
                // Use babel loader to transpile the JS files.
                use: [
                    {
                        loader: 'babel-loader',
                        options: {
                            presets: ['@babel/preset-env']
                        },
                    }]
            },
            {
                // Apply rule for .sass, .scss or .css files
                test: /\.(sa|sc|c)ss$/,

                // Set loaders to transform files.
                // Loaders are applying from right to left(!)
                // The first loader will be applied after others
                use: [
                    {
                        // After all CSS loaders we use plugin to do his work.
                        // It gets all transformed CSS and extracts it into separate
                        // single bundled file
                        loader: MiniCssExtractPlugin.loader
                    },
                    {
                        // This loader resolves url() and @imports inside CSS
                        loader: "css-loader",
                    },
                    /*{
                        // Then we apply postCSS fixes like autoprefixer and minifying
                        loader: "postcss-loader"
                    },*/
                    {
                        // First we transform SASS to standard CSS
                        loader: "sass-loader",
                        options: {
                            implementation: require("sass"),
                            sourceMap: true,
                        }
                    }
                ]
            },
            {
                test: /\.(png|jpe?g|gif)$/i,
                use: [
                    {
                        loader: 'file-loader',
                    },
                ],
            },
            {
                test: /\.(woff(2)?|ttf|eot|svg)(\?v=\d+\.\d+\.\d+)?$/,
                use: [
                    {
                        loader: 'file-loader',
                        options: {
                            name: '[name].[ext]',
                            outputPath: 'fonts/',
                            publicPath: '../fonts/',
                        }
                    }
                ]
            }
        ]
    },
    plugins: [

        new MiniCssExtractPlugin({
            filename: "css/[name].[contenthash].css"
        }),
        new CleanWebpackPlugin(),
        new ManifestPlugin({writeToFileEmit: true}),


    ],
    watchOptions: {
        aggregateTimeout: 300,
        ignored: /node_modules/,
        poll: 1000
    }
}

// Export the config object.
module.exports = config;