<?php
    global $rdgb;
    $block_styles = [];
    $block_classes = ['rdg-buttons'];
    $block_buttons = $rdgb->settings->get_block(BLOCK_RDG_BUTTONS);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $links = get_field('links');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>
<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php if (is_array($links) && count($links)): ?>
            <div class="buttons">
                <?php foreach($links as $link): ?>
                    <?php
                        $link_class = '';
                        $link_style = '';
                        if ($link['default_styles'] != 'custom') {
                            $link_class = 'class="'.$link['default_styles'].'"';
                        } else {
                            $link_style = 'onMouseOut="this.style.backgroundColor=\''.$link['background_color'].'\'" onmouseover="this.style.backgroundColor=\''.$link['background_hover_color'].'\'" class="link-default" style="'.$block_buttons->get_style('buttons', $link).'"';
                        }

                        $icon = (!empty($link['icon'])) ? '<i class="fa-regular '.$link['icon'].'"></i>' : '';
                    ?>
                    <?php if (!empty($link['link']['url']) && !empty($link['link']['title'])): ?>
                        <a href="<?php echo $link['link']['url']; ?>" <?php echo $link_class; ?> <?php echo $link_style; ?>><?php echo $link['link']['title']; echo $icon;?></a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
